/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509AuthenticationProvider;
import org.apache.nifi.web.security.x509.X509AuthenticationRequestToken;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509AuthenticationProviderTest {
    private static final String INVALID_CERTIFICATE = "invalid-certificate";
    private static final String IDENTITY_1 = "identity-1";
    private static final String ANONYMOUS = "";
    private static final String UNTRUSTED_PROXY = "untrusted-proxy";
    private static final String PROXY_1 = "proxy-1";
    private static final String PROXY_2 = "proxy-2";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";
    private X509AuthenticationProvider x509AuthenticationProvider;
    private X509IdentityProvider certificateIdentityProvider;
    private SubjectDnX509PrincipalExtractor extractor;
    private Authorizer authorizer;

    @Before
    public void setup() {
        System.clearProperty("nifi.properties.file.path");
        this.extractor = new SubjectDnX509PrincipalExtractor();
        this.certificateIdentityProvider = (X509IdentityProvider)Mockito.mock(X509IdentityProvider.class);
        Mockito.when((Object)this.certificateIdentityProvider.authenticate((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class))).then(invocation -> {
            X509Certificate[] certChain = (X509Certificate[])invocation.getArgument(0);
            String identity = this.extractor.extractPrincipal(certChain[0]).toString();
            if (INVALID_CERTIFICATE.equals(identity)) {
                throw new IllegalArgumentException();
            }
            return new AuthenticationResponse(identity, identity, TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS), ANONYMOUS);
        });
        this.authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Mockito.when((Object)this.authorizer.authorize((AuthorizationRequest)ArgumentMatchers.any(AuthorizationRequest.class))).then(invocation -> {
            AuthorizationRequest request = (AuthorizationRequest)invocation.getArgument(0);
            if (UNTRUSTED_PROXY.equals(request.getIdentity())) {
                return AuthorizationResult.denied();
            }
            return AuthorizationResult.approved();
        });
        this.x509AuthenticationProvider = new X509AuthenticationProvider(this.certificateIdentityProvider, this.authorizer, NiFiProperties.createBasicNiFiProperties(null));
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testInvalidCertificate() {
        this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(ANONYMOUS, INVALID_CERTIFICATE));
    }

    @Test
    public void testNoProxyChain() {
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(ANONYMOUS, IDENTITY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)IDENTITY_1, (Object)user.getIdentity());
        Assert.assertFalse((boolean)user.isAnonymous());
    }

    @Test(expected=UntrustedProxyException.class)
    public void testUntrustedProxy() {
        this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1), UNTRUSTED_PROXY));
    }

    @Test
    public void testOneProxy() {
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)IDENTITY_1, (Object)user.getIdentity());
        Assert.assertFalse((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().isAnonymous());
    }

    @Test
    public void testAnonymousWithOneProxy() {
        HashMap<String, String> additionalProperties = new HashMap<String, String>(){
            {
                this.put("nifi.security.allow.anonymous.authentication", Boolean.TRUE.toString());
            }
        };
        NiFiProperties properties = NiFiProperties.createBasicNiFiProperties(null, (Map)additionalProperties);
        this.x509AuthenticationProvider = new X509AuthenticationProvider(this.certificateIdentityProvider, this.authorizer, properties);
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(ANONYMOUS), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"anonymous", (Object)user.getIdentity());
        Assert.assertTrue((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().isAnonymous());
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testAnonymousWithOneProxyWhileAnonymousAuthenticationPrevented() {
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(ANONYMOUS), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"anonymous", (Object)user.getIdentity());
        Assert.assertTrue((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().isAnonymous());
    }

    @Test
    public void testTwoProxies() {
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1, PROXY_2), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)IDENTITY_1, (Object)user.getIdentity());
        Assert.assertFalse((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)PROXY_2, (Object)user.getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().isAnonymous());
        Assert.assertNotNull((Object)user.getChain().getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().getChain().isAnonymous());
    }

    @Test(expected=UntrustedProxyException.class)
    public void testUntrustedProxyInChain() {
        this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1, UNTRUSTED_PROXY), PROXY_1));
    }

    @Test
    public void testAnonymousProxyInChain() {
        HashMap<String, String> additionalProperties = new HashMap<String, String>(){
            {
                this.put("nifi.security.allow.anonymous.authentication", Boolean.TRUE.toString());
            }
        };
        NiFiProperties properties = NiFiProperties.createBasicNiFiProperties(null, (Map)additionalProperties);
        this.x509AuthenticationProvider = new X509AuthenticationProvider(this.certificateIdentityProvider, this.authorizer, properties);
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1, ANONYMOUS), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)IDENTITY_1, (Object)user.getIdentity());
        Assert.assertFalse((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)"anonymous", (Object)user.getChain().getIdentity());
        Assert.assertTrue((boolean)user.getChain().isAnonymous());
        Assert.assertNotNull((Object)user.getChain().getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().getChain().isAnonymous());
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testAnonymousProxyInChainWhileAnonymousAuthenticationPrevented() {
        NiFiAuthenticationToken auth = (NiFiAuthenticationToken)this.x509AuthenticationProvider.authenticate((Authentication)this.getX509Request(this.buildProxyChain(IDENTITY_1, ANONYMOUS), PROXY_1));
        NiFiUser user = ((NiFiUserDetails)auth.getDetails()).getNiFiUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)IDENTITY_1, (Object)user.getIdentity());
        Assert.assertFalse((boolean)user.isAnonymous());
        Assert.assertNotNull((Object)user.getChain());
        Assert.assertEquals((Object)"anonymous", (Object)user.getChain().getIdentity());
        Assert.assertTrue((boolean)user.getChain().isAnonymous());
        Assert.assertNotNull((Object)user.getChain().getChain());
        Assert.assertEquals((Object)PROXY_1, (Object)user.getChain().getChain().getIdentity());
        Assert.assertFalse((boolean)user.getChain().getChain().isAnonymous());
    }

    @Test
    public void testShouldCreateAnonymousUser() {
        String identity = "someone";
        NiFiUser user = X509AuthenticationProvider.createUser((String)identity, null, null, null, null, (boolean)true);
        assert (user != null);
        assert (user instanceof StandardNiFiUser);
        assert (user.getIdentity().equals("anonymous"));
        assert (user.isAnonymous());
    }

    @Test
    public void testShouldCreateKnownUser() {
        String identity = "someone";
        NiFiUser user = X509AuthenticationProvider.createUser((String)identity, null, null, null, null, (boolean)false);
        assert (user != null);
        assert (user instanceof StandardNiFiUser);
        assert (user.getIdentity().equals(identity));
        assert (!user.isAnonymous());
    }

    private String buildProxyChain(String ... identities) {
        List<String> elements = Arrays.asList(identities);
        return StringUtils.join((Iterable)elements.stream().map(X509AuthenticationProviderTest::formatDn).collect(Collectors.toList()), (String)ANONYMOUS);
    }

    private static String formatDn(String rawDn) {
        return LT + X509AuthenticationProviderTest.sanitizeDn(rawDn) + GT;
    }

    private static String sanitizeDn(String rawDn) {
        if (StringUtils.isEmpty((CharSequence)rawDn)) {
            return rawDn;
        }
        return rawDn.replaceAll(GT, ESCAPED_GT).replaceAll(LT, ESCAPED_LT);
    }

    private static String unsanitizeDn(String sanitizedDn) {
        if (StringUtils.isEmpty((CharSequence)sanitizedDn)) {
            return sanitizedDn;
        }
        return sanitizedDn.replaceAll(ESCAPED_GT, GT).replaceAll(ESCAPED_LT, LT);
    }

    private X509AuthenticationRequestToken getX509Request(String proxyChain, String identity) {
        return this.getX509Request(proxyChain, null, identity);
    }

    private X509AuthenticationRequestToken getX509Request(String proxyChain, String proxiedEntityGroups, String identity) {
        return new X509AuthenticationRequestToken(proxyChain, proxiedEntityGroups, (X509PrincipalExtractor)this.extractor, new X509Certificate[]{this.getX509Certificate(identity)}, ANONYMOUS);
    }

    private X509Certificate getX509Certificate(String identity) {
        X509Certificate certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)certificate.getSubjectDN()).then(invocation -> {
            Principal principal = (Principal)Mockito.mock(Principal.class);
            Mockito.when((Object)principal.getName()).thenReturn((Object)identity);
            return principal;
        });
        return certificate;
    }
}

