/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.security.util.TemporaryKeyStoreBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.registration.StandardRelyingPartyRegistrationRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

class StandardRelyingPartyRegistrationRepositoryTest {
    private static final String METADATA_PATH = "/saml/sso-circle-meta.xml";
    private static final String ENTITY_ID = "nifi";
    private static final X500Principal CERTIFICATE_PRINCIPAL = new X500Principal("CN=localhost");

    StandardRelyingPartyRegistrationRepositoryTest() {
    }

    @Test
    void testFindByRegistrationId() {
        NiFiProperties properties = this.getProperties();
        StandardRelyingPartyRegistrationRepository repository = new StandardRelyingPartyRegistrationRepository(properties);
        RelyingPartyRegistration registration = repository.findByRegistrationId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
        this.assertRegistrationPropertiesFound(registration);
        Assertions.assertNull((Object)registration.getSingleLogoutServiceLocation());
        Assertions.assertNull((Object)registration.getSingleLogoutServiceResponseLocation());
        RelyingPartyRegistration.AssertingPartyDetails assertingPartyDetails = registration.getAssertingPartyDetails();
        Assertions.assertFalse((boolean)assertingPartyDetails.getWantAuthnRequestsSigned());
        Assertions.assertTrue((boolean)assertingPartyDetails.getSigningAlgorithms().contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Collection signingCredentials = registration.getSigningX509Credentials();
        Assertions.assertTrue((boolean)signingCredentials.isEmpty());
    }

    @Test
    void testFindByRegistrationIdSingleLogoutEnabled() {
        TlsConfiguration tlsConfiguration = new TemporaryKeyStoreBuilder().build();
        NiFiProperties properties = this.getSingleLogoutProperties(tlsConfiguration);
        StandardRelyingPartyRegistrationRepository repository = new StandardRelyingPartyRegistrationRepository(properties);
        RelyingPartyRegistration registration = repository.findByRegistrationId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
        this.assertRegistrationPropertiesFound(registration);
        Assertions.assertEquals((Object)StandardRelyingPartyRegistrationRepository.SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION, (Object)registration.getSingleLogoutServiceLocation());
        Assertions.assertEquals((Object)StandardRelyingPartyRegistrationRepository.SINGLE_LOGOUT_RESPONSE_SERVICE_LOCATION, (Object)registration.getSingleLogoutServiceResponseLocation());
        RelyingPartyRegistration.AssertingPartyDetails assertingPartyDetails = registration.getAssertingPartyDetails();
        Assertions.assertFalse((boolean)assertingPartyDetails.getWantAuthnRequestsSigned());
        Assertions.assertTrue((boolean)assertingPartyDetails.getSigningAlgorithms().contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
        this.assertSigningCredentialsFound(registration);
        this.assertEncryptionCredentialsFound(assertingPartyDetails);
    }

    private void assertSigningCredentialsFound(RelyingPartyRegistration registration) {
        Collection signingCredentials = registration.getSigningX509Credentials();
        Assertions.assertFalse((boolean)signingCredentials.isEmpty());
        Saml2X509Credential credential = (Saml2X509Credential)signingCredentials.iterator().next();
        X509Certificate certificate = credential.getCertificate();
        Assertions.assertEquals((Object)CERTIFICATE_PRINCIPAL, (Object)certificate.getSubjectX500Principal());
        Assertions.assertEquals((Object)CERTIFICATE_PRINCIPAL, (Object)certificate.getIssuerX500Principal());
    }

    private void assertEncryptionCredentialsFound(RelyingPartyRegistration.AssertingPartyDetails assertingPartyDetails) {
        Collection encryptionCredentials = assertingPartyDetails.getEncryptionX509Credentials();
        Assertions.assertFalse((boolean)encryptionCredentials.isEmpty());
        Optional<Saml2X509Credential> certificateCredential = encryptionCredentials.stream().filter(credential -> CERTIFICATE_PRINCIPAL.equals(credential.getCertificate().getSubjectX500Principal())).findFirst();
        Assertions.assertTrue((boolean)certificateCredential.isPresent(), (String)"Trust Store certificate credential not found");
    }

    private void assertRegistrationPropertiesFound(RelyingPartyRegistration registration) {
        Assertions.assertNotNull((Object)registration);
        Assertions.assertEquals((Object)Saml2RegistrationProperty.REGISTRATION_ID.getProperty(), (Object)registration.getRegistrationId());
        Assertions.assertEquals((Object)ENTITY_ID, (Object)registration.getEntityId());
        Assertions.assertEquals((Object)StandardRelyingPartyRegistrationRepository.LOGIN_RESPONSE_LOCATION, (Object)registration.getAssertionConsumerServiceLocation());
    }

    private NiFiProperties getProperties() {
        Properties properties = this.getStandardProperties();
        return NiFiProperties.createBasicNiFiProperties(null, (Properties)properties);
    }

    private NiFiProperties getSingleLogoutProperties(TlsConfiguration tlsConfiguration) {
        Properties properties = this.getStandardProperties();
        properties.setProperty("nifi.security.user.saml.single.logout.enabled", Boolean.TRUE.toString());
        properties.setProperty("nifi.security.user.saml.signature.algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        properties.setProperty("nifi.security.keystore", tlsConfiguration.getKeystorePath());
        properties.setProperty("nifi.security.keystoreType", tlsConfiguration.getKeystoreType().getType());
        properties.setProperty("nifi.security.keystorePasswd", tlsConfiguration.getKeystorePassword());
        properties.setProperty("nifi.security.keyPasswd", tlsConfiguration.getKeyPassword());
        properties.setProperty("nifi.security.truststore", tlsConfiguration.getTruststorePath());
        properties.setProperty("nifi.security.truststoreType", tlsConfiguration.getTruststoreType().getType());
        properties.setProperty("nifi.security.truststorePasswd", tlsConfiguration.getTruststorePassword());
        return NiFiProperties.createBasicNiFiProperties(null, (Properties)properties);
    }

    private Properties getStandardProperties() {
        Properties properties = new Properties();
        String metadataUrl = this.getFileMetadataUrl();
        properties.setProperty("nifi.security.user.saml.idp.metadata.url", metadataUrl);
        properties.setProperty("nifi.security.user.saml.sp.entity.id", ENTITY_ID);
        return properties;
    }

    private String getFileMetadataUrl() {
        URL resource = Objects.requireNonNull(this.getClass().getResource(METADATA_PATH));
        return resource.toString();
    }
}

