/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.logout;

import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogoutRequestManager {
    private LogoutRequestManager logoutRequestManager;

    @Before
    public void setup() {
        this.logoutRequestManager = new LogoutRequestManager();
    }

    @Test
    public void testLogoutSequence() {
        String logoutRequestId = "logoutRequest1";
        String userIdentity = "user1";
        LogoutRequest logoutRequest = new LogoutRequest("logoutRequest1", "user1");
        this.logoutRequestManager.start(logoutRequest);
        LogoutRequest retrievedRequest = this.logoutRequestManager.get("logoutRequest1");
        Assert.assertNotNull((Object)retrievedRequest);
        Assert.assertEquals((Object)"logoutRequest1", (Object)retrievedRequest.getRequestIdentifier());
        Assert.assertEquals((Object)"user1", (Object)retrievedRequest.getMappedUserIdentity());
        LogoutRequest completedRequest = this.logoutRequestManager.complete("logoutRequest1");
        Assert.assertNotNull((Object)completedRequest);
        Assert.assertEquals((Object)"logoutRequest1", (Object)completedRequest.getRequestIdentifier());
        Assert.assertEquals((Object)"user1", (Object)completedRequest.getMappedUserIdentity());
        LogoutRequest shouldNotExistRequest = this.logoutRequestManager.get("logoutRequest1");
        Assert.assertNull((Object)shouldNotExistRequest);
    }

    @Test
    public void testCompleteLogoutWhenDoesNotExist() {
        LogoutRequest shouldNotExistRequest = this.logoutRequestManager.complete("does-not-exist");
        Assert.assertNull((Object)shouldNotExistRequest);
    }
}

