/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.id.State;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.oidc.OidcIdentityProvider;
import org.apache.nifi.web.security.oidc.OidcService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OidcServiceTest {
    public static final String TEST_REQUEST_IDENTIFIER = "test-request-identifier";
    public static final String TEST_STATE = "test-state";

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledCreateState() {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.createState(TEST_REQUEST_IDENTIFIER);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateStateMultipleInvocations() {
        OidcService service = this.getServiceWithOidcSupport();
        service.createState(TEST_REQUEST_IDENTIFIER);
        service.createState(TEST_REQUEST_IDENTIFIER);
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledValidateState() {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.isStateValid(TEST_REQUEST_IDENTIFIER, new State(TEST_STATE));
    }

    @Test
    public void testOidcUnknownState() {
        OidcService service = this.getServiceWithOidcSupport();
        Assert.assertFalse((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, new State(TEST_STATE)));
    }

    @Test
    public void testValidateState() {
        OidcService service = this.getServiceWithOidcSupport();
        State state = service.createState(TEST_REQUEST_IDENTIFIER);
        Assert.assertTrue((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, state));
    }

    @Test
    public void testValidateStateExpiration() throws Exception {
        OidcService service = this.getServiceWithOidcSupportAndCustomExpiration(1, TimeUnit.SECONDS);
        State state = service.createState(TEST_REQUEST_IDENTIFIER);
        Thread.sleep(3000L);
        Assert.assertFalse((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, state));
    }

    @Test(expected=IllegalStateException.class)
    public void testStoreJwtMultipleInvocation() {
        OidcService service = this.getServiceWithOidcSupport();
        String TEST_JWT1 = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRoyZyJ9.b4NIl0RONKdVLOH0D1eObdwAEX8qX-ExqB8KuKSZFLw";
        String TEST_JWT2 = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiI5ODc2NTQzMjEwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRob3JpdHkiLCJhdWQiOiJhbGwiLCJ1c2VybmFtZSI6Im9pZGNfdGVzdCIsImVtYWlsIjoib2lkY190ZXN0QG5pZmkuYXBhY2hlLm9yZyJ9.nlYhplDLXeGAwW62rJ_ZnEaG7nxEB4TbaJNK-_pC4WQ";
        service.storeJwt(TEST_REQUEST_IDENTIFIER, "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRoyZyJ9.b4NIl0RONKdVLOH0D1eObdwAEX8qX-ExqB8KuKSZFLw");
        service.storeJwt(TEST_REQUEST_IDENTIFIER, "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiI5ODc2NTQzMjEwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRob3JpdHkiLCJhdWQiOiJhbGwiLCJ1c2VybmFtZSI6Im9pZGNfdGVzdCIsImVtYWlsIjoib2lkY190ZXN0QG5pZmkuYXBhY2hlLm9yZyJ9.nlYhplDLXeGAwW62rJ_ZnEaG7nxEB4TbaJNK-_pC4WQ");
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledExchangeCodeForLoginAuthenticationToken() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.exchangeAuthorizationCodeForLoginAuthenticationToken(this.getAuthorizationGrant());
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledExchangeCodeForAccessToken() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.exchangeAuthorizationCodeForAccessToken(this.getAuthorizationGrant());
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledExchangeCodeForIdToken() throws IOException {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.exchangeAuthorizationCodeForIdToken(this.getAuthorizationGrant());
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledGetJwt() {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.getJwt(TEST_REQUEST_IDENTIFIER);
    }

    private OidcService getServiceWithNoOidcSupport() {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)false);
        OidcService service = new OidcService(provider);
        Assert.assertFalse((boolean)service.isOidcEnabled());
        return service;
    }

    private OidcService getServiceWithOidcSupport() {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)true);
        OidcService service = new OidcService(provider);
        Assert.assertTrue((boolean)service.isOidcEnabled());
        return service;
    }

    private OidcService getServiceWithOidcSupportAndCustomExpiration(int duration, TimeUnit units) throws Exception {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)true);
        Mockito.when((Object)provider.exchangeAuthorizationCodeforLoginAuthenticationToken((AuthorizationGrant)ArgumentMatchers.any())).then(invocation -> UUID.randomUUID().toString());
        OidcService service = new OidcService(provider, duration, units);
        Assert.assertTrue((boolean)service.isOidcEnabled());
        return service;
    }

    private AuthorizationGrant getAuthorizationGrant() {
        return new AuthorizationCodeGrant(new AuthorizationCode("code"), URI.create("http://localhost:8080/nifi"));
    }
}

