/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.web.client.BasicProxyAuthenticator;
import org.apache.nifi.web.client.InputStreamRequestBody;
import org.apache.nifi.web.client.StandardHttpEntityHeaders;
import org.apache.nifi.web.client.StandardHttpResponseEntity;
import org.apache.nifi.web.client.api.HttpRequestBodySpec;
import org.apache.nifi.web.client.api.HttpRequestHeadersSpec;
import org.apache.nifi.web.client.api.HttpRequestMethod;
import org.apache.nifi.web.client.api.HttpRequestUriSpec;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.StandardHttpRequestMethod;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.api.WebClientServiceException;
import org.apache.nifi.web.client.proxy.ProxyContext;
import org.apache.nifi.web.client.redirect.RedirectHandling;
import org.apache.nifi.web.client.ssl.SSLSocketFactoryProvider;
import org.apache.nifi.web.client.ssl.StandardSSLSocketFactoryProvider;
import org.apache.nifi.web.client.ssl.TlsContext;

public class StandardWebClientService
implements WebClientService {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final SSLSocketFactoryProvider sslSocketFactoryProvider = new StandardSSLSocketFactoryProvider();
    private OkHttpClient okHttpClient = new OkHttpClient.Builder().build();

    public void setConnectTimeout(Duration connectTimeout) {
        Objects.requireNonNull(connectTimeout, "Connect Timeout required");
        this.okHttpClient = this.okHttpClient.newBuilder().connectTimeout(connectTimeout).build();
    }

    public void setReadTimeout(Duration readTimeout) {
        Objects.requireNonNull(readTimeout, "Read Timeout required");
        this.okHttpClient = this.okHttpClient.newBuilder().readTimeout(readTimeout).build();
    }

    public void setWriteTimeout(Duration writeTimeout) {
        Objects.requireNonNull(writeTimeout, "Write Timeout required");
        this.okHttpClient = this.okHttpClient.newBuilder().writeTimeout(writeTimeout).build();
    }

    public void setProxyContext(ProxyContext proxyContext) {
        Objects.requireNonNull(proxyContext, "Proxy Context required");
        Proxy proxy = Objects.requireNonNull(proxyContext.getProxy(), "Proxy required");
        this.okHttpClient = this.okHttpClient.newBuilder().proxy(proxy).build();
        Optional<String> proxyUsername = proxyContext.getUsername();
        if (proxyUsername.isPresent()) {
            String username = proxyUsername.get();
            String password = proxyContext.getPassword().orElseThrow(() -> new IllegalArgumentException("Proxy password required"));
            String credentials = Credentials.basic((String)username, (String)password);
            BasicProxyAuthenticator proxyAuthenticator = new BasicProxyAuthenticator(credentials);
            this.okHttpClient = this.okHttpClient.newBuilder().proxyAuthenticator((Authenticator)proxyAuthenticator).build();
        }
    }

    public void setRedirectHandling(RedirectHandling redirectHandling) {
        Objects.requireNonNull(redirectHandling, "Redirect Handling required");
        boolean followRedirects = RedirectHandling.FOLLOWED == redirectHandling;
        this.okHttpClient = this.okHttpClient.newBuilder().followRedirects(followRedirects).followSslRedirects(followRedirects).build();
    }

    public void setTlsContext(TlsContext tlsContext) {
        Objects.requireNonNull(tlsContext, "TLS Context required");
        X509TrustManager trustManager = Objects.requireNonNull(tlsContext.getTrustManager(), "Trust Manager required");
        SSLSocketFactory sslSocketFactory = sslSocketFactoryProvider.getSocketFactory(tlsContext);
        this.okHttpClient = this.okHttpClient.newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
    }

    public HttpRequestUriSpec method(HttpRequestMethod httpRequestMethod) {
        Objects.requireNonNull(httpRequestMethod, "HTTP Request Method required");
        return new StandardHttpRequestUriSpec(httpRequestMethod);
    }

    public HttpRequestUriSpec delete() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.DELETE);
    }

    public HttpRequestUriSpec get() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.GET);
    }

    public HttpRequestUriSpec patch() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.PATCH);
    }

    public HttpRequestUriSpec post() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.POST);
    }

    public HttpRequestUriSpec put() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.PUT);
    }

    class StandardHttpRequestBodySpec
    implements HttpRequestBodySpec {
        private static final long UNKNOWN_CONTENT_LENGTH = -1L;
        private final HttpRequestMethod httpRequestMethod;
        private final URI uri;
        private final Headers.Builder headersBuilder;
        private long contentLength = -1L;
        private InputStream body;

        StandardHttpRequestBodySpec(HttpRequestMethod httpRequestMethod, URI uri) {
            this.httpRequestMethod = httpRequestMethod;
            this.uri = uri;
            this.headersBuilder = new Headers.Builder();
        }

        public HttpRequestHeadersSpec body(InputStream body, OptionalLong contentLength) {
            this.body = Objects.requireNonNull(body, "Body required");
            this.contentLength = Objects.requireNonNull(contentLength, "Content Length required").orElse(-1L);
            return this;
        }

        public HttpRequestBodySpec header(String headerName, String headerValue) {
            Objects.requireNonNull(headerName, "Header Name required");
            Objects.requireNonNull(headerValue, "Header Value required");
            this.headersBuilder.add(headerName, headerValue);
            return this;
        }

        public HttpResponseEntity retrieve() {
            Request request = this.getRequest();
            Call call = StandardWebClientService.this.okHttpClient.newCall(request);
            Response response = this.execute(call);
            int code = response.code();
            Headers responseHeaders = response.headers();
            StandardHttpEntityHeaders headers = new StandardHttpEntityHeaders(responseHeaders.toMultimap());
            ResponseBody responseBody = response.body();
            InputStream body = responseBody == null ? new ByteArrayInputStream(EMPTY_BYTES) : responseBody.byteStream();
            return new StandardHttpResponseEntity(code, headers, body);
        }

        private Response execute(Call call) {
            try {
                return call.execute();
            }
            catch (IOException e) {
                throw new WebClientServiceException("Request execution failed", (Throwable)e, this.uri, this.httpRequestMethod);
            }
        }

        private Request getRequest() {
            HttpUrl url = HttpUrl.get((URI)this.uri);
            Objects.requireNonNull(url, "HTTP Request URI required");
            Headers headers = this.headersBuilder.build();
            RequestBody requestBody = this.getRequestBody();
            return new Request.Builder().method(this.httpRequestMethod.getMethod(), requestBody).url(url).headers(headers).build();
        }

        private RequestBody getRequestBody() {
            InputStreamRequestBody requestBody = this.body == null ? null : new InputStreamRequestBody(this.body, this.contentLength);
            return requestBody;
        }
    }

    class StandardHttpRequestUriSpec
    implements HttpRequestUriSpec {
        private final HttpRequestMethod httpRequestMethod;

        StandardHttpRequestUriSpec(HttpRequestMethod httpRequestMethod) {
            this.httpRequestMethod = httpRequestMethod;
        }

        public HttpRequestBodySpec uri(URI uri) {
            Objects.requireNonNull(uri, "URI required");
            return new StandardHttpRequestBodySpec(this.httpRequestMethod, uri);
        }
    }
}

