/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.io.File;
import java.nio.file.Path;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.EntityStoreAuditService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.migration.FlowConfigurationHistoryMigrator;
import org.apache.nifi.web.security.configuration.WebSecurityConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@Import(value={WebSecurityConfiguration.class})
@ImportResource(value={"classpath:nifi-context.xml", "classpath:nifi-authorizer-context.xml", "classpath:nifi-cluster-manager-context.xml", "classpath:nifi-cluster-protocol-context.xml", "classpath:nifi-web-api-context.xml"})
public class NiFiWebApiConfiguration {
    @Autowired
    @Bean
    public AuditService auditService(NiFiProperties properties) throws Exception {
        File databaseDirectory = properties.getDatabaseRepositoryPath().toFile();
        EntityStoreAuditService auditService = new EntityStoreAuditService(databaseDirectory);
        FlowConfigurationHistoryMigrator.reconcileDatabaseRepository((Path)databaseDirectory.toPath(), (AuditService)auditService);
        return auditService;
    }
}

