/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics.jmx;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JmxMetricsResultConverter {
    private static final String COMPOSITE_DATA_KEY = "CompositeData%s";

    public Object convert(Object attributeValue) {
        if (attributeValue instanceof CompositeData[]) {
            CompositeData[] valueArray = (CompositeData[])attributeValue;
            LinkedHashMap values = new LinkedHashMap();
            for (int i = 0; i < valueArray.length; ++i) {
                LinkedHashMap subValues = new LinkedHashMap();
                this.convertCompositeData(valueArray[i], subValues);
                values.put(String.format(COMPOSITE_DATA_KEY, i), subValues);
            }
            return values;
        }
        if (attributeValue instanceof CompositeData) {
            LinkedHashMap values = new LinkedHashMap();
            this.convertCompositeData((CompositeData)attributeValue, values);
            return values;
        }
        if (attributeValue instanceof TabularData) {
            LinkedHashMap values = new LinkedHashMap();
            this.convertTabularData((TabularData)attributeValue, values);
            return values;
        }
        return attributeValue;
    }

    private void convertCompositeData(CompositeData attributeValue, Map<String, Object> values) {
        for (String key : attributeValue.getCompositeType().keySet()) {
            values.put(key, this.convert(attributeValue.get(key)));
        }
    }

    private void convertTabularData(TabularData attributeValue, Map<String, Object> values) {
        Set<?> keys = attributeValue.keySet();
        for (List key : keys) {
            Object value = this.convert((Object)attributeValue.get(key.toArray()));
            values.put(key.toString(), value);
        }
    }
}

