/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.nifi.util.EscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Provider
public class JsonContentConversionExceptionMapper
implements ExceptionMapper<InvalidFormatException> {
    private static final Logger logger = LoggerFactory.getLogger(JsonContentConversionExceptionMapper.class);

    public Response toResponse(InvalidFormatException ex) {
        JsonMappingException.Reference path;
        logger.info(String.format("%s. Returning %s response.", ex, Response.Status.BAD_REQUEST));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)ex);
        }
        String value = ex.getValue().toString();
        String propName = "field";
        if (ex.getPath() != null && !ex.getPath().isEmpty() && (path = (JsonMappingException.Reference)ex.getPath().get(ex.getPath().size() - 1)) != null) {
            propName = path.getFieldName();
        }
        String errorMessage = "The provided " + propName + " value '" + JsonContentConversionExceptionMapper.sanitizeMessage((String)value) + "' is not of required type " + ex.getTargetType();
        logger.error(errorMessage);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).type("text/plain").build();
    }

    private static String sanitizeMessage(String input) {
        return EscapeUtils.escapeHtml((String)input);
    }
}

