/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.persistence.TemplateSerializer;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.TemplateEntity;

@Path(value="/templates")
@Api(value="/templates", description="Endpoint for managing a Template.")
public class TemplateResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<TemplateEntity> populateRemainingTemplateEntitiesContent(Set<TemplateEntity> templateEntities) {
        for (TemplateEntity templateEntity : templateEntities) {
            if (templateEntity.getTemplate() == null) continue;
            this.populateRemainingTemplateContent(templateEntity.getTemplate());
        }
        return templateEntities;
    }

    public TemplateDTO populateRemainingTemplateContent(TemplateDTO template) {
        template.setUri(this.generateResourceUri(new String[]{"templates", template.getId()}));
        return template;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/download")
    @ApiOperation(value="Exports a template", response=String.class, authorizations={@Authorization(value="Read - /templates/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response exportTemplate(@ApiParam(value="The template id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable template = lookup.getTemplate(id);
            template.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        TemplateDTO template = this.serviceFacade.exportTemplate(id);
        template.setId(null);
        String attachmentName = template.getName();
        attachmentName = StringUtils.isBlank((CharSequence)attachmentName) ? "template" : attachmentName.replaceAll("\\s", "_");
        Charset utf8 = StandardCharsets.UTF_8;
        try {
            attachmentName = URLEncoder.encode(attachmentName, utf8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String serializedTemplate = new String(TemplateSerializer.serialize((TemplateDTO)template), utf8);
        String filename = attachmentName + ".xml";
        return this.generateOkResponse((Object)serializedTemplate).encoding(utf8.name()).header("Content-Disposition", (Object)("attachment; filename* = " + utf8.name() + "''" + filename)).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /templates/{uuid}"), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The template id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        TemplateEntity requestTemplateEntity = new TemplateEntity();
        requestTemplateEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestTemplateEntity, lookup -> {
            Authorizable template = lookup.getTemplate(id);
            template.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            template.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, templateEntity -> {
            this.serviceFacade.deleteTemplate(templateEntity.getId());
            TemplateEntity entity = new TemplateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

