/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ConfigurationAnalysisDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ConfigurationAnalysisEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceRunStatusEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.UpdateControllerServiceReferenceRequestEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/controller-services")
@Api(value="/controller-services", description="Endpoint for managing a Controller Service.")
public class ControllerServiceResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ControllerServiceResource.class);
    private static final String VERIFICATION_REQUEST_TYPE = "verification-request";
    private RequestManager<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> configVerificationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Verify Controller Service Config Thread");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ControllerServiceEntity> populateRemainingControllerServiceEntitiesContent(Set<ControllerServiceEntity> controllerServiceEntities) {
        for (ControllerServiceEntity controllerServiceEntity : controllerServiceEntities) {
            this.populateRemainingControllerServiceEntityContent(controllerServiceEntity);
        }
        return controllerServiceEntities;
    }

    public ControllerServiceEntity populateRemainingControllerServiceEntityContent(ControllerServiceEntity controllerServiceEntity) {
        controllerServiceEntity.setUri(this.generateResourceUri(new String[]{"controller-services", controllerServiceEntity.getId()}));
        if (controllerServiceEntity.getComponent() != null) {
            this.populateRemainingControllerServiceContent(controllerServiceEntity.getComponent());
        }
        return controllerServiceEntity;
    }

    public ControllerServiceDTO populateRemainingControllerServiceContent(ControllerServiceDTO controllerService) {
        BundleDTO bundle = controllerService.getBundle();
        UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
        if (uiExtensionMapping.hasUiExtension(controllerService.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
            List uiExtensions = uiExtensionMapping.getUiExtension(controllerService.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            for (UiExtension uiExtension : uiExtensions) {
                if (!UiExtensionType.ControllerServiceConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                controllerService.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
            }
        }
        return controllerService;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}")}, notes="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerService(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ControllerServiceEntity entity = this.serviceFacade.getControllerService(id, true);
        if (uiOnly) {
            this.stripNonUiRelevantFields(entity);
        }
        this.populateRemainingControllerServiceEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/descriptors")
    @ApiOperation(value="Gets a controller service property descriptor", response=PropertyDescriptorEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPropertyDescriptor(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The property name to return the descriptor for.", required=true) @QueryParam(value="propertyName") String propertyName, @ApiParam(value="Property Descriptor requested sensitive status", defaultValue="false") @QueryParam(value="sensitive") boolean sensitive) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getControllerServicePropertyDescriptor(id, propertyName, sensitive);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state")
    @ApiOperation(value="Gets the state for a controller service", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getState(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getControllerServiceState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @ApiOperation(value="Clears the state for a controller service", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response clearState(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ControllerServiceEntity requestControllerServiceEntity = new ControllerServiceEntity();
        requestControllerServiceEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearControllerServiceState(id), controllerServiceEntity -> {
            this.serviceFacade.clearControllerServiceState(controllerServiceEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/references")
    @ApiOperation(value="Gets a controller service", response=ControllerServiceReferencingComponentsEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServiceReferences(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ControllerServiceReferencingComponentsEntity entity = this.serviceFacade.getControllerServiceReferencingComponents(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/references")
    @ApiOperation(value="Updates a controller services references", response=ControllerServiceReferencingComponentsEntity.class, authorizations={@Authorization(value="Write - /{component-type}/{uuid} or /operate/{component-type}/{uuid} - For each referencing component specified")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerServiceReferences(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The controller service request update request.", required=true) UpdateControllerServiceReferenceRequestEntity requestUpdateReferenceRequest) {
        if (requestUpdateReferenceRequest == null || requestUpdateReferenceRequest.getId() == null) {
            throw new IllegalArgumentException("The controller service identifier must be specified.");
        }
        if (requestUpdateReferenceRequest.getReferencingComponentRevisions() == null) {
            throw new IllegalArgumentException("The controller service referencing components revisions must be specified.");
        }
        ControllerServiceState requestControllerServiceState = null;
        try {
            requestControllerServiceState = ControllerServiceState.valueOf((String)requestUpdateReferenceRequest.getState());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ScheduledState requestScheduledState = null;
        try {
            requestScheduledState = ScheduledState.valueOf((String)requestUpdateReferenceRequest.getState());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (requestScheduledState == null && requestControllerServiceState == null) {
            throw new IllegalArgumentException("Must specify the updated state. To update referencing Processors and Reporting Tasks the state should be RUNNING or STOPPED. To update the referencing Controller Services the state should be ENABLED or DISABLED.");
        }
        if (requestControllerServiceState != null && (ControllerServiceState.ENABLING.equals((Object)requestControllerServiceState) || ControllerServiceState.DISABLING.equals((Object)requestControllerServiceState))) {
            throw new IllegalArgumentException("Cannot set the referencing services to ENABLING or DISABLING");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestUpdateReferenceRequest);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestUpdateReferenceRequest.isDisconnectedNodeAcknowledged());
        }
        Map<String, Revision> requestReferencingRevisions = requestUpdateReferenceRequest.getReferencingComponentRevisions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RevisionDTO rev = (RevisionDTO)e.getValue();
            return new Revision(rev.getVersion(), rev.getClientId(), (String)e.getKey());
        }));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestReferencingRevisions.values());
        ScheduledState verifyScheduledState = requestScheduledState;
        ControllerServiceState verifyControllerServiceState = requestControllerServiceState;
        return this.withWriteLock(this.serviceFacade, (Entity)requestUpdateReferenceRequest, requestRevisions, lookup -> requestReferencingRevisions.entrySet().stream().forEach(e -> {
            Authorizable controllerService = lookup.getControllerServiceReferencingComponent(id, (String)e.getKey());
            OperationAuthorizable.authorizeOperation((Authorizable)controllerService, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }), () -> this.serviceFacade.verifyUpdateControllerServiceReferencingComponents(requestUpdateReferenceRequest.getId(), verifyScheduledState, verifyControllerServiceState), (revisions, updateReferenceRequest) -> {
            ScheduledState scheduledState = null;
            try {
                scheduledState = ScheduledState.valueOf((String)updateReferenceRequest.getState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ControllerServiceState controllerServiceState = null;
            try {
                controllerServiceState = ControllerServiceState.valueOf((String)updateReferenceRequest.getState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Map<String, Revision> referencingRevisions = updateReferenceRequest.getReferencingComponentRevisions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                RevisionDTO rev = (RevisionDTO)e.getValue();
                return new Revision(rev.getVersion(), rev.getClientId(), (String)e.getKey());
            }));
            ControllerServiceReferencingComponentsEntity entity = this.serviceFacade.updateControllerServiceReferencingComponents(referencingRevisions, updateReferenceRequest.getId(), scheduledState, controllerServiceState);
            if (updateReferenceRequest.getUiOnly() == Boolean.TRUE) {
                entity.getControllerServiceReferencingComponents().forEach(arg_0 -> ((ControllerServiceResource)this).stripNonUiRelevantFields(arg_0));
            }
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}"), @Authorization(value="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ControllerServiceDTO requestControllerServiceDTO = requestControllerServiceEntity.getComponent();
        if (!id.equals(requestControllerServiceDTO.getId())) {
            throw new IllegalArgumentException(String.format("The controller service id (%s) in the request body does not equal the controller service id of the requested resource (%s).", requestControllerServiceDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestControllerServiceEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestControllerServiceEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestControllerServiceEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, requestRevision, lookup -> {
            ComponentAuthorizable authorizable = lookup.getControllerService(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerServiceDTO.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
            AuthorizeParameterReference.authorizeParameterReferences((Map)requestControllerServiceDTO.getProperties(), (Authorizer)this.authorizer, (Authorizable)authorizable.getParameterContext(), (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateControllerService(requestControllerServiceDTO), (revision, controllerServiceEntity) -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            ControllerServiceEntity entity = this.serviceFacade.updateControllerService(revision, controllerService);
            this.populateRemainingControllerServiceEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}"), @Authorization(value="Write - Parent Process Group if scoped by Process Group - /process-groups/{uuid}"), @Authorization(value="Write - Controller if scoped by Controller - /controller"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ControllerServiceEntity requestControllerServiceEntity = new ControllerServiceEntity();
        requestControllerServiceEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, requestRevision, lookup -> {
            ComponentAuthorizable controllerService = lookup.getControllerService(id);
            controllerService.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            controllerService.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)controllerService, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteControllerService(id), (revision, controllerServiceEntity) -> {
            ControllerServiceEntity entity = this.serviceFacade.deleteControllerService(revision, controllerServiceEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/run-status")
    @ApiOperation(value="Updates run status of a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid} or /operation/controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRunStatus(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The controller service run status.", required=true) ControllerServiceRunStatusEntity requestRunStatus) {
        if (requestRunStatus == null) {
            throw new IllegalArgumentException("Controller service run status must be specified.");
        }
        if (requestRunStatus.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRunStatus.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRunStatus);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRunStatus.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRunStatus.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRunStatus, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getControllerService(id).getAuthorizable();
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateControllerService(this.createDTOWithDesiredRunStatus(id, requestRunStatus.getState())), (revision, runStatusEntity) -> {
            ControllerServiceEntity entity = this.serviceFacade.updateControllerService(revision, this.createDTOWithDesiredRunStatus(id, runStatusEntity.getState()));
            this.populateRemainingControllerServiceEntityContent(entity);
            if (runStatusEntity.getUiOnly() == Boolean.TRUE) {
                this.stripNonUiRelevantFields(entity);
            }
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/analysis")
    @ApiOperation(value="Performs analysis of the component's configuration, providing information about which attributes are referenced.", response=ConfigurationAnalysisEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response analyzeConfiguration(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String controllerServiceId, @ApiParam(value="The configuration analysis request.", required=true) ConfigurationAnalysisEntity configurationAnalysis) {
        if (configurationAnalysis == null || configurationAnalysis.getConfigurationAnalysis() == null) {
            throw new IllegalArgumentException("Controller Service's configuration must be specified");
        }
        ConfigurationAnalysisDTO dto = configurationAnalysis.getConfigurationAnalysis();
        if (dto.getComponentId() == null) {
            throw new IllegalArgumentException("Controller Service's identifier must be specified in the request");
        }
        if (!dto.getComponentId().equals(controllerServiceId)) {
            throw new IllegalArgumentException("Controller Service's identifier in the request must match the identifier provided in the URL");
        }
        if (dto.getProperties() == null) {
            throw new IllegalArgumentException("Controller Service's properties must be specified in the request");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)configurationAnalysis);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)configurationAnalysis, lookup -> {
            ComponentAuthorizable controllerService = lookup.getControllerService(controllerServiceId);
            controllerService.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ConfigurationAnalysisDTO analysis = entity.getConfigurationAnalysis();
            ConfigurationAnalysisEntity resultsEntity = this.serviceFacade.analyzeControllerServiceConfiguration(analysis.getComponentId(), analysis.getProperties());
            return this.generateOkResponse((Object)resultsEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/verification-requests")
    @ApiOperation(value="Performs verification of the Controller Service's configuration", response=VerifyConfigRequestEntity.class, notes="This will initiate the process of verifying a given Controller Service configuration. This may be a long-running task. As a result, this endpoint will immediately return a ControllerServiceConfigVerificationRequestEntity, and the process of performing the verification will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /controller-services/{serviceId}/verification-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /controller-services/{serviceId}/verification-requests/{requestId}.", authorizations={@Authorization(value="Read - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitConfigVerificationRequest(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String controllerServiceId, @ApiParam(value="The controller service configuration verification request.", required=true) VerifyConfigRequestEntity controllerServiceConfigRequest) {
        if (controllerServiceConfigRequest == null) {
            throw new IllegalArgumentException("Controller Service's configuration must be specified");
        }
        VerifyConfigRequestDTO requestDto = controllerServiceConfigRequest.getRequest();
        if (requestDto == null || requestDto.getProperties() == null) {
            throw new IllegalArgumentException("Controller Service properties must be specified");
        }
        if (requestDto.getComponentId() == null) {
            throw new IllegalArgumentException("Controller Service's identifier must be specified in the request");
        }
        if (!requestDto.getComponentId().equals(controllerServiceId)) {
            throw new IllegalArgumentException("Controller Service's identifier in the request must match the identifier provided in the URL");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)controllerServiceConfigRequest);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)controllerServiceConfigRequest, lookup -> {
            ComponentAuthorizable controllerService = lookup.getControllerService(controllerServiceId);
            controllerService.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanVerifyControllerServiceConfig(controllerServiceId), entity -> this.performAsyncConfigVerification(entity, user));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @ApiOperation(value="Returns the Verification Request with the given ID", response=VerifyConfigRequestEntity.class, notes="Returns the Verification Request with the given ID. Once an Verification Request has been created, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVerificationRequest(@ApiParam(value="The ID of the Controller Service") @PathParam(value="id") String controllerServiceId, @ApiParam(value="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
        VerifyConfigRequestEntity updateRequestEntity = this.createVerifyControllerServiceConfigRequestEntity(asyncRequest, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @ApiOperation(value="Deletes the Verification Request with the given ID", response=VerifyConfigRequestEntity.class, notes="Deletes the Verification Request with the given ID. After a request is created, it is expected that the client will properly clean up the request by DELETE'ing it, once the Verification process has completed. If the request is deleted before the request completes, then the Verification request will finish the step that it is currently performing and then will cancel any subsequent steps.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteVerificationRequest(@ApiParam(value="The ID of the Controller Service") @PathParam(value="id") String controllerServiceId, @ApiParam(value="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        boolean twoPhaseRequest = this.isTwoPhaseRequest(this.httpServletRequest);
        boolean executionPhase = this.isExecutionPhase(this.httpServletRequest);
        if (!twoPhaseRequest || executionPhase) {
            AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.removeRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            if (asyncRequest == null) {
                throw new ResourceNotFoundException("Could not find request of type verification-request with ID " + requestId);
            }
            if (!asyncRequest.isComplete()) {
                asyncRequest.cancel();
            }
            VerifyConfigRequestEntity updateRequestEntity = this.createVerifyControllerServiceConfigRequestEntity(asyncRequest, requestId);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        }
        if (this.isValidationPhase(this.httpServletRequest)) {
            this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            return this.generateContinueResponse().build();
        }
        if (this.isCancellationPhase(this.httpServletRequest)) {
            return this.generateOkResponse().build();
        }
        throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
    }

    public Response performAsyncConfigVerification(VerifyConfigRequestEntity configRequest, NiFiUser user) {
        String requestId = this.generateUuid();
        VerifyConfigRequestDTO requestDto = configRequest.getRequest();
        String serviceId = requestDto.getComponentId();
        List<StandardUpdateStep> updateSteps = Collections.singletonList(new StandardUpdateStep("Verify Controller Service Configuration"));
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)configRequest, serviceId, user, updateSteps);
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                Map attributes = requestDto.getAttributes() == null ? Collections.emptyMap() : requestDto.getAttributes();
                List results = this.serviceFacade.performControllerServiceConfigVerification(serviceId, requestDto.getProperties(), attributes);
                asyncRequest.markStepComplete((Object)results);
            }
            catch (Exception e) {
                logger.error("Failed to verify Controller Service configuration", (Throwable)e);
                asyncRequest.fail("Failed to verify Controller Service configuration due to " + e);
            }
        };
        this.configVerificationRequestManager.submitRequest(VERIFICATION_REQUEST_TYPE, requestId, (AsynchronousWebRequest)request, updateTask);
        VerifyConfigRequestEntity resultsEntity = this.createVerifyControllerServiceConfigRequestEntity((AsynchronousWebRequest)request, requestId);
        return this.generateOkResponse((Object)resultsEntity).build();
    }

    private VerifyConfigRequestEntity createVerifyControllerServiceConfigRequestEntity(AsynchronousWebRequest<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> asyncRequest, String requestId) {
        VerifyConfigRequestDTO requestDto = ((VerifyConfigRequestEntity)asyncRequest.getRequest()).getRequest();
        List resultsList = (List)asyncRequest.getResults();
        VerifyConfigRequestDTO dto = new VerifyConfigRequestDTO();
        dto.setComponentId(requestDto.getComponentId());
        dto.setProperties(requestDto.getProperties());
        dto.setResults(resultsList);
        dto.setComplete(asyncRequest.isComplete());
        dto.setFailureReason(asyncRequest.getFailureReason());
        dto.setLastUpdated(asyncRequest.getLastUpdated());
        dto.setPercentCompleted(asyncRequest.getPercentComplete());
        dto.setRequestId(requestId);
        dto.setState(asyncRequest.getState());
        dto.setUri(this.generateResourceUri(new String[]{"controller-services", requestDto.getComponentId(), "config", "verification-requests", requestId}));
        VerifyConfigRequestEntity entity = new VerifyConfigRequestEntity();
        entity.setRequest(dto);
        return entity;
    }

    private ControllerServiceDTO createDTOWithDesiredRunStatus(String id, String runStatus) {
        ControllerServiceDTO dto = new ControllerServiceDTO();
        dto.setId(id);
        dto.setState(runStatus);
        return dto;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

