/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class PortScheduledStateMatcher
implements AttributeMatcher<Port> {
    private static final String SEARCH_TERM_DISABLED = "disabled";
    private static final String SEARCH_TERM_INVALID = "invalid";
    private static final String SEARCH_TERM_RUNNING = "running";
    private static final String SEARCH_TERM_STOPPED = "stopped";
    private static final String MATCH_PREFIX = "Run status: ";
    private static final String MATCH_DISABLED = "Disabled";
    private static final String MATCH_INVALID = "Invalid";
    private static final String MATCH_RUNNING = "Running";
    private static final String MATCH_STOPPED = "Stopped";

    public void match(Port component, SearchQuery query, List<String> matches) {
        String searchTerm = query.getTerm();
        if (ScheduledState.DISABLED.equals((Object)component.getScheduledState())) {
            if (StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_DISABLED, (CharSequence)searchTerm)) {
                matches.add("Run status: Disabled");
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_INVALID, (CharSequence)searchTerm) && !component.isValid()) {
            matches.add("Run status: Invalid");
        } else if (ScheduledState.RUNNING.equals((Object)component.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_RUNNING, (CharSequence)searchTerm)) {
            matches.add("Run status: Running");
        } else if (ScheduledState.STOPPED.equals((Object)component.getScheduledState()) && StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_STOPPED, (CharSequence)searchTerm)) {
            matches.add("Run status: Stopped");
        }
    }
}

