/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.FlowUpdateResource;
import org.apache.nifi.web.api.VersionsResource;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.VersionedFlowDTO;
import org.apache.nifi.web.api.dto.VersionedFlowUpdateRequestDTO;
import org.apache.nifi.web.api.entity.CreateActiveRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessGroupDescriptorEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.StartVersionControlRequestEntity;
import org.apache.nifi.web.api.entity.VersionControlComponentMappingEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotEntity;
import org.apache.nifi.web.api.entity.VersionedFlowUpdateRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/versions")
@Api(value="/versions", description="Endpoint for managing version control for a flow")
public class VersionsResource
extends FlowUpdateResource<VersionControlInformationEntity, VersionedFlowUpdateRequestEntity> {
    private static final Logger logger = LoggerFactory.getLogger(VersionsResource.class);
    private ActiveRequest activeRequest = null;
    private final Object activeRequestMonitor = new Object();

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Gets the Version Control information for a process group", response=VersionControlInformationEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVersionInformation(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        VersionControlInformationEntity entity = this.serviceFacade.getVersionControlInformation(groupId);
        if (entity == null) {
            ProcessGroupEntity processGroup = this.serviceFacade.getProcessGroup(groupId);
            entity = new VersionControlInformationEntity();
            entity.setProcessGroupRevision(processGroup.getRevision());
        }
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/download")
    @ApiOperation(value="Gets the latest version of a Process Group for download", response=String.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response exportFlowVersion(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        this.serviceFacade.authorizeAccess(lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, false, true);
        });
        FlowSnapshotContainer snapshotContainer = this.serviceFacade.getVersionedFlowSnapshotByGroupId(groupId);
        RegisteredFlowSnapshot versionedFlowSnapshot = snapshotContainer.getFlowSnapshot();
        VersionedProcessGroup versionedProcessGroup = versionedFlowSnapshot.getFlowContents();
        String flowName = versionedProcessGroup.getName();
        int flowVersion = versionedFlowSnapshot.getSnapshotMetadata().getVersion();
        versionedFlowSnapshot.setFlow(null);
        versionedFlowSnapshot.setBucket(null);
        versionedFlowSnapshot.setSnapshotMetadata(null);
        this.sanitizeRegistryInfo(versionedProcessGroup);
        String filename = flowName.replaceAll("\\s", "_") + "_" + flowVersion + ".json";
        return this.generateOkResponse((Object)versionedFlowSnapshot).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", filename)).build();
    }

    private void sanitizeRegistryInfo(VersionedProcessGroup versionedProcessGroup) {
        versionedProcessGroup.setVersionedFlowCoordinates(null);
        for (VersionedProcessGroup innerVersionedProcessGroup : versionedProcessGroup.getProcessGroups()) {
            this.sanitizeRegistryInfo(innerVersionedProcessGroup);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Path(value="active-requests")
    @ApiOperation(value="Create a version control request", response=String.class, notes="Creates a request so that a Process Group can be placed under Version Control or have its Version Control configuration changed. Creating this request will prevent any other threads from simultaneously saving local changes to Version Control. It will not, however, actually save the local flow to the Flow Registry. A POST to /versions/process-groups/{id} should be used to initiate saving of the local flow to the Flow Registry. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createVersionControlRequest(@ApiParam(value="The versioned flow details.", required=true) CreateActiveRequestEntity requestEntity) {
        if (requestEntity == null || requestEntity.getProcessGroupId() == null) {
            throw new IllegalArgumentException("The id of the process group that will be updated must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(requestEntity.getProcessGroupId()).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
        }, null, entity -> {
            String requestId = this.generateUuid();
            Object object = this.activeRequestMonitor;
            synchronized (object) {
                if (this.activeRequest != null && !this.activeRequest.isExpired()) {
                    throw new IllegalStateException("A request is already underway to place a Process Group in this NiFi instance under Version Control. Only a single such request is allowed to occurred at a time. Please try the request again momentarily.");
                }
                this.activeRequest = new ActiveRequest(requestId, user, entity.getProcessGroupId());
            }
            return this.generateOkResponse((Object)requestId).build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="active-requests/{id}")
    @ApiOperation(value="Updates the request with the given ID", response=VersionControlInformationEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can update it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateVersionControlRequest(@ApiParam(value="The request ID.") @PathParam(value="id") String requestId, @ApiParam(value="The version control component mapping.", required=true) VersionControlComponentMappingEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Version control information must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionControlInformationDTO versionControlInfo = requestEntity.getVersionControlInformation();
        if (versionControlInfo == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied");
        }
        if (versionControlInfo.getGroupId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Process Group ID");
        }
        if (versionControlInfo.getBucketId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Bucket ID");
        }
        if (versionControlInfo.getFlowId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Flow ID");
        }
        if (versionControlInfo.getRegistryId() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Registry ID");
        }
        if (versionControlInfo.getVersion() == null) {
            throw new IllegalArgumentException("Version Control Information must supply Version");
        }
        Map mapping = requestEntity.getVersionControlComponentMapping();
        if (mapping == null) {
            throw new IllegalArgumentException("Version Control Component Mapping must be supplied");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Object object = this.activeRequestMonitor;
        synchronized (object) {
            if (this.activeRequest == null) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (!requestId.equals(this.activeRequest.getRequestId())) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (this.activeRequest.isExpired()) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " has already expired");
            }
            if (this.activeRequest.isUpdatePerformed()) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " has already been performed");
            }
            String groupId = requestEntity.getVersionControlInformation().getGroupId();
            if (!this.activeRequest.getProcessGroupId().equals(groupId)) {
                throw new IllegalStateException("Version Control Request with ID " + requestId + " was created for a different process group id");
            }
            Revision groupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), groupId);
            return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, groupRevision, lookup -> {
                NiFiUser user = NiFiUserUtils.getNiFiUser();
                if (user == null) {
                    throw new AccessDeniedException("Unknown user.");
                }
                if (!user.equals(this.activeRequest.getUser())) {
                    throw new AccessDeniedException("Only the user that creates the Version Control Request can use it.");
                }
            }, null, (rev, mappingEntity) -> {
                VersionControlInformationEntity responseEntity = this.serviceFacade.setVersionControlInformation(rev, groupId, mappingEntity.getVersionControlInformation(), mappingEntity.getVersionControlComponentMapping());
                this.activeRequest.updatePerformed();
                return this.generateOkResponse((Object)responseEntity).build();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="active-requests/{id}")
    @ApiOperation(value="Deletes the version control request with the given ID", notes="Deletes the Version Control Request with the given ID. This will allow other threads to save flows to the Flow Registry. See also the documentation for POSTing to /versions/active-requests for information regarding why this is done. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteVersionControlRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The request ID.") @PathParam(value="id") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Object object = this.activeRequestMonitor;
        synchronized (object) {
            if (this.activeRequest == null) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            if (!requestId.equals(this.activeRequest.getRequestId())) {
                throw new IllegalStateException("No Version Control Request with ID " + requestId + " is currently active");
            }
            return this.withWriteLock(this.serviceFacade, null, lookup -> {
                NiFiUser user = NiFiUserUtils.getNiFiUser();
                if (user == null) {
                    throw new AccessDeniedException("Unknown user.");
                }
                if (!user.equals(this.activeRequest.getUser())) {
                    throw new AccessDeniedException("Only the user that creates the Version Control Request can use it.");
                }
            }, null, requestEntity -> {
                this.activeRequest = null;
                return this.generateOkResponse().build();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Save the Process Group with the given ID", response=VersionControlInformationEntity.class, notes="Begins version controlling the Process Group with the given ID or commits changes to the Versioned Flow, depending on if the provided VersionControlInformation includes a flowId. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Read - any referenced Controller Services by any encapsulated components - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response saveToFlowRegistry(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The versioned flow details.", required=true) StartVersionControlRequestEntity requestEntity) {
        ProcessGroupEntity root;
        if (requestEntity == null) {
            throw new IllegalArgumentException("Version control request must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionedFlowDTO versionedFlowDto = requestEntity.getVersionedFlow();
        if (versionedFlowDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getBucketId())) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getFlowName()) && StringUtils.isEmpty((CharSequence)versionedFlowDto.getFlowId())) {
            throw new IllegalArgumentException("The Flow Name or Flow ID must be supplied.");
        }
        if (versionedFlowDto.getFlowName() != null && versionedFlowDto.getFlowName().length() > 1000) {
            throw new IllegalArgumentException("The Flow Name cannot exceed 1,000 characters");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getRegistryId())) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (versionedFlowDto.getDescription() != null && versionedFlowDto.getDescription().length() > 65535) {
            throw new IllegalArgumentException("Flow Description cannot exceed 65,535 characters");
        }
        if (versionedFlowDto.getComments() != null && versionedFlowDto.getComments().length() > 65535) {
            throw new IllegalArgumentException("Comments cannot exceed 65,535 characters");
        }
        if (StringUtils.isEmpty((CharSequence)versionedFlowDto.getAction())) {
            throw new IllegalArgumentException("Action is required");
        }
        if (!"COMMIT".equals(versionedFlowDto.getAction()) && !"FORCE_COMMIT".equals(versionedFlowDto.getAction())) {
            throw new IllegalArgumentException("Action must be one of COMMIT or FORCE_COMMIT");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        if ((root = this.serviceFacade.getProcessGroup("root")).getId().equals(groupId)) {
            throw new IllegalArgumentException("The Root Process Group cannot be versioned.");
        }
        if (this.isReplicateRequest()) {
            URI requestUri;
            try {
                URI originalUri = this.getAbsolutePath();
                String requestId = this.lockVersionControl(originalUri, groupId);
                requestUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/versions/active-requests/" + requestId, null, originalUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            try {
                VersionControlComponentMappingEntity mappingEntity = this.serviceFacade.registerFlowWithFlowRegistry(groupId, requestEntity);
                this.replicateVersionControlMapping(mappingEntity, requestEntity, requestUri, groupId);
                VersionControlInformationEntity responseEntity = this.serviceFacade.getVersionControlInformation(groupId);
                Response response = this.generateOkResponse((Object)responseEntity).build();
                return response;
            }
            finally {
                this.unlockVersionControl(requestUri, groupId);
            }
        }
        Revision groupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, groupRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, true, true);
        }, () -> {
            VersionedFlowDTO versionedFlow = requestEntity.getVersionedFlow();
            String registryId = versionedFlow.getRegistryId();
            String bucketId = versionedFlow.getBucketId();
            String flowId = versionedFlow.getFlowId();
            String action = versionedFlow.getAction();
            this.serviceFacade.verifyCanSaveToFlowRegistry(groupId, registryId, bucketId, flowId, action);
        }, (rev, flowEntity) -> {
            VersionControlComponentMappingEntity mappingEntity = this.serviceFacade.registerFlowWithFlowRegistry(groupId, flowEntity);
            VersionControlInformationEntity responseEntity = this.serviceFacade.setVersionControlInformation(rev, groupId, mappingEntity.getVersionControlInformation(), mappingEntity.getVersionControlComponentMapping());
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    private void unlockVersionControl(URI requestUri, String groupId) {
        NodeResponse clusterResponse;
        try {
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("DELETE", requestUri, (Object)new MultivaluedHashMap(), Collections.emptyMap()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "DELETE", requestUri, (Object)new MultivaluedHashMap(), Collections.emptyMap()).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("After starting Version Control on Process Group with ID " + groupId + ", interrupted while waiting for deletion of Version Control Request. Users may be unable to Version Control other Process Groups until the request lock times out.", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            logger.error("After starting Version Control on Process Group with ID " + groupId + ", failed to delete Version Control Request. Users may be unable to Version Control other Process Groups until the request lock times out. Response status code was " + clusterResponse.getStatus());
        }
    }

    private String lockVersionControl(URI originalUri, String groupId) throws URISyntaxException {
        NodeResponse clusterResponse;
        URI createRequestUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/versions/active-requests", null, originalUri.getFragment());
        try {
            CreateActiveRequestEntity activeRequestEntity = new CreateActiveRequestEntity();
            activeRequestEntity.setProcessGroupId(groupId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("POST", createRequestUri, (Object)activeRequestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "POST", createRequestUri, (Object)activeRequestEntity, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while updating Version Control Information for Process Group with ID " + groupId + ".", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            String errorResponse = (String)this.getResponseEntity(clusterResponse, String.class);
            throw new IllegalStateException("Failed to create a Version Control Request across all nodes in the cluster. Received response code " + clusterResponse.getStatus() + " with content: " + errorResponse);
        }
        String requestId = (String)this.getResponseEntity(clusterResponse, String.class);
        return requestId;
    }

    private void replicateVersionControlMapping(VersionControlComponentMappingEntity mappingEntity, StartVersionControlRequestEntity requestEntity, URI requestUri, String groupId) {
        NodeResponse clusterResponse;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        try {
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("PUT", requestUri, (Object)mappingEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "PUT", requestUri, (Object)mappingEntity, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (requestEntity.getVersionedFlow().getFlowId() == null) {
                VersionControlInformationDTO vci = mappingEntity.getVersionControlInformation();
                try {
                    this.serviceFacade.deleteVersionedFlow(vci.getRegistryId(), vci.getBucketId(), vci.getFlowId());
                }
                catch (Exception e) {
                    logger.error("Created Versioned Flow with ID {} in bucket with ID {} but failed to replicate the Version Control Information to cluster. Attempted to delete the newly created (empty) flow from the Flow Registry but failed", new Object[]{vci.getFlowId(), vci.getBucketId(), e});
                }
            }
            throw new RuntimeException("Interrupted while updating Version Control Information for Process Group with ID " + groupId + ".", ie);
        }
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            if (requestEntity.getVersionedFlow().getFlowId() == null) {
                VersionControlInformationDTO vci = mappingEntity.getVersionControlInformation();
                try {
                    this.serviceFacade.deleteVersionedFlow(vci.getRegistryId(), vci.getBucketId(), vci.getFlowId());
                }
                catch (Exception e) {
                    logger.error("Created Versioned Flow with ID {} in bucket with ID {} but failed to replicate the Version Control Information to cluster. Attempted to delete the newly created (empty) flow from the Flow Registry but failed", new Object[]{vci.getFlowId(), vci.getBucketId(), e});
                }
            }
            String message = "Failed to update Version Control Information for Process Group with ID " + groupId + ".";
            Throwable cause = clusterResponse.getThrowable();
            if (cause == null) {
                throw new IllegalStateException(message);
            }
            throw new IllegalStateException(message, cause);
        }
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Stops version controlling the Process Group with the given ID", response=VersionControlInformationEntity.class, notes="Stops version controlling the Process Group with the given ID. The Process Group will no longer track to any Versioned Flow. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response stopVersionControl(@ApiParam(value="The version is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The process group id.") @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), groupId);
        return this.withWriteLock(this.serviceFacade, null, requestRevision, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> {
            VersionControlInformationEntity currentVersionControlInfo = this.serviceFacade.getVersionControlInformation(groupId);
            if (currentVersionControlInfo == null) {
                throw new IllegalStateException("Process Group with ID " + groupId + " is not currently under Version Control");
            }
        }, (revision, groupEntity) -> {
            VersionControlInformationEntity entity = this.serviceFacade.deleteVersionControl(revision, groupId);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Update the version of a Process Group with the given ID", response=VersionControlInformationEntity.class, notes="For a Process Group that is already under Version Control, this will update the version of the flow to a different version. This endpoint expects that the given snapshot will not modify any Processor that is currently running or any Controller Service that is enabled. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateFlowVersion(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) VersionedFlowSnapshotEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Version control information must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified.");
        }
        RegisteredFlowSnapshot requestFlowSnapshot = requestEntity.getVersionedFlowSnapshot();
        if (requestFlowSnapshot == null) {
            throw new IllegalArgumentException("Versioned Flow Snapshot must be supplied.");
        }
        RegisteredFlowSnapshotMetadata requestSnapshotMetadata = requestFlowSnapshot.getSnapshotMetadata();
        if (requestSnapshotMetadata == null) {
            throw new IllegalArgumentException("Snapshot Metadata must be supplied.");
        }
        if (requestSnapshotMetadata.getBucketIdentifier() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestSnapshotMetadata.getFlowIdentifier() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanUpdate(groupId, requestFlowSnapshot, true, false), (revision, entity) -> {
            VersionControlInformationDTO versionControlInfoDto = new VersionControlInformationDTO();
            versionControlInfoDto.setRegistryId(entity.getRegistryId());
            VersionControlInformationEntity versionControlInfo = new VersionControlInformationEntity();
            versionControlInfo.setVersionControlInformation(versionControlInfoDto);
            ProcessGroupEntity updatedGroup = this.performUpdateFlow(groupId, revision, versionControlInfo, entity.getVersionedFlowSnapshot(), (String)this.getIdGenerationSeed().orElse(null), false, entity.getUpdateDescendantVersionedFlows().booleanValue());
            VersionControlInformationDTO updatedVci = updatedGroup.getComponent().getVersionControlInformation();
            VersionControlInformationEntity responseEntity = new VersionControlInformationEntity();
            responseEntity.setProcessGroupRevision(updatedGroup.getRevision());
            responseEntity.setVersionControlInformation(updatedVci);
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/{id}")
    @ApiOperation(value="Returns the Update Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /versions/update-requests/process-groups/{id}, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUpdateRequest(@ApiParam(value="The ID of the Update Request") @PathParam(value="id") String updateRequestId) {
        return this.retrieveFlowUpdateRequest("update-requests", updateRequestId);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/{id}")
    @ApiOperation(value="Returns the Revert Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Returns the Revert Request with the given ID. Once a Revert Request has been created by performing a POST to /versions/revert-requests/process-groups/{id}, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRevertRequest(@ApiParam(value="The ID of the Revert Request") @PathParam(value="id") String revertRequestId) {
        return this.retrieveFlowUpdateRequest("revert-requests", revertRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/{id}")
    @ApiOperation(value="Deletes the Update Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Deletes the Update Request with the given ID. After a request is created via a POST to /versions/update-requests/process-groups/{id}, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteUpdateRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the Update Request") @PathParam(value="id") String updateRequestId) {
        return this.deleteFlowUpdateRequest("update-requests", updateRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/{id}")
    @ApiOperation(value="Deletes the Revert Request with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="Deletes the Revert Request with the given ID. After a request is created via a POST to /versions/revert-requests/process-groups/{id}, it is expected that the client will properly clean up the request by DELETE'ing it, once the Revert process has completed. If the request is deleted before the request completes, then the Revert request will finish the step that it is currently performing and then will cancel any subsequent steps. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteRevertRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the Revert Request") @PathParam(value="id") String revertRequestId) {
        return this.deleteFlowUpdateRequest("revert-requests", revertRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="update-requests/process-groups/{id}")
    @ApiOperation(value="Initiate the Update Request of a Process Group with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="For a Process Group that is already under Version Control, this will initiate the action of changing from a specific version of the flow in the Flow Registry to a different version of the flow. This can be a lengthy process, as it will stop any Processors and disable any Controller Services necessary to perform the action and then restart them. As a result, the endpoint will immediately return a VersionedFlowUpdateRequestEntity, and the process of updating the flow will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /versions/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /versions/update-requests/{requestId}. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - if the template contains any restricted components - /restricted-components"), @Authorization(value="Read - /parameter-contexts/{uuid} - For any Parameter Context that is referenced by a Property that is changed, added, or removed")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response initiateVersionControlUpdate(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) VersionControlInformationEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Version control information must be specified.");
        }
        VersionControlInformationDTO requestVersionControlInfoDto = requestEntity.getVersionControlInformation();
        if (requestVersionControlInfoDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (requestVersionControlInfoDto.getGroupId() == null) {
            throw new IllegalArgumentException("The Process Group ID must be supplied.");
        }
        if (!requestVersionControlInfoDto.getGroupId().equals(groupId)) {
            throw new IllegalArgumentException("The Process Group ID in the request body does not match the Process Group ID of the requested resource.");
        }
        if (requestVersionControlInfoDto.getBucketId() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getFlowId() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getRegistryId() == null) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getVersion() == null) {
            throw new IllegalArgumentException("The Version of the flow must be supplied.");
        }
        return this.initiateFlowUpdate(groupId, (ProcessGroupDescriptorEntity)requestEntity, false, "update-requests", "/nifi-api/versions/process-groups/" + groupId, () -> this.serviceFacade.getVersionedFlowSnapshot(requestVersionControlInfoDto, true));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="revert-requests/process-groups/{id}")
    @ApiOperation(value="Initiate the Revert Request of a Process Group with the given ID", response=VersionedFlowUpdateRequestEntity.class, notes="For a Process Group that is already under Version Control, this will initiate the action of reverting any local changes that have been made to the Process Group since it was last synchronized with the Flow Registry. This will result in the flow matching the Versioned Flow that exists in the Flow Registry. This can be a lengthy process, as it will stop any Processors and disable any Controller Services necessary to perform the action and then restart them. As a result, the endpoint will immediately return a VersionedFlowUpdateRequestEntity, and the process of updating the flow will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /versions/revert-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /versions/revert-requests/{requestId}. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /process-groups/{uuid}"), @Authorization(value="Write - /process-groups/{uuid}"), @Authorization(value="Read - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components"), @Authorization(value="Write - if the template contains any restricted components - /restricted-components"), @Authorization(value="Read - /parameter-contexts/{uuid} - For any Parameter Context that is referenced by a Property that is changed, added, or removed")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response initiateRevertFlowVersion(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @ApiParam(value="The Version Control Information to revert to.", required=true) VersionControlInformationEntity requestEntity) {
        boolean replicateRequest;
        if (requestEntity == null) {
            throw new IllegalArgumentException("Version control information must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        VersionControlInformationDTO requestVersionControlInfoDto = requestEntity.getVersionControlInformation();
        if (requestVersionControlInfoDto == null) {
            throw new IllegalArgumentException("Version Control Information must be supplied.");
        }
        if (requestVersionControlInfoDto.getGroupId() == null) {
            throw new IllegalArgumentException("The Process Group ID must be supplied.");
        }
        if (!requestVersionControlInfoDto.getGroupId().equals(groupId)) {
            throw new IllegalArgumentException("The Process Group ID in the request body does not match the Process Group ID of the requested resource.");
        }
        if (requestVersionControlInfoDto.getBucketId() == null) {
            throw new IllegalArgumentException("The Bucket ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getFlowId() == null) {
            throw new IllegalArgumentException("The Flow ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getRegistryId() == null) {
            throw new IllegalArgumentException("The Registry ID must be supplied.");
        }
        if (requestVersionControlInfoDto.getVersion() == null) {
            throw new IllegalArgumentException("The Version of the flow must be supplied.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        ComponentLifecycle componentLifecycle = (replicateRequest = this.isReplicateRequest()) ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        FlowSnapshotContainer flowSnapshotContainer = this.serviceFacade.getVersionedFlowSnapshot(requestEntity.getVersionControlInformation(), true);
        RegisteredFlowSnapshot flowSnapshot = flowSnapshotContainer.getFlowSnapshot();
        this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshotContainer, groupId, NiFiUserUtils.getNiFiUser());
        this.serviceFacade.resolveParameterProviders(flowSnapshot, NiFiUserUtils.getNiFiUser());
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByFlowUpdate(groupId, flowSnapshot);
        FlowUpdateResource.InitiateUpdateFlowRequestWrapper requestWrapper = new FlowUpdateResource.InitiateUpdateFlowRequestWrapper((FlowUpdateResource)this, (ProcessGroupDescriptorEntity)requestEntity, componentLifecycle, "revert-requests", this.getAbsolutePath(), "/nifi-api/versions/process-groups/" + groupId, affectedComponents, replicateRequest, flowSnapshot);
        Revision requestRevision = this.getRevision(requestEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> this.authorizeFlowUpdate(lookup, user, groupId, flowSnapshot), () -> this.serviceFacade.verifyCanRevertLocalModifications(groupId, flowSnapshot), (revision, wrapper) -> {
            VersionControlInformationEntity versionControlInformationEntity = (VersionControlInformationEntity)wrapper.getRequestEntity();
            VersionControlInformationDTO versionControlInformationDTO = versionControlInformationEntity.getVersionControlInformation();
            VersionControlInformationEntity currentVersionEntity = this.serviceFacade.getVersionControlInformation(groupId);
            if (currentVersionEntity == null) {
                throw new IllegalStateException("Process Group cannot be reverted to the previous version of the flow because Process Group is not under Version Control.");
            }
            VersionControlInformationDTO currentVersion = currentVersionEntity.getVersionControlInformation();
            if (!currentVersion.getBucketId().equals(versionControlInformationDTO.getBucketId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getFlowId().equals(versionControlInformationDTO.getFlowId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getRegistryId().equals(versionControlInformationDTO.getRegistryId())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            if (!currentVersion.getVersion().equals(versionControlInformationDTO.getVersion())) {
                throw new IllegalArgumentException("The Version Control Information provided does not match the flow that the Process Group is currently synchronized with.");
            }
            return this.submitFlowUpdateRequest(user, groupId, revision, wrapper, true);
        });
    }

    protected ProcessGroupEntity performUpdateFlow(String groupId, Revision revision, VersionControlInformationEntity requestEntity, RegisteredFlowSnapshot flowSnapshot, String idGenerationSeed, boolean verifyNotModified, boolean updateDescendantVersionedFlows) {
        logger.info("Updating Process Group with ID {} to version {} of the Versioned Flow", (Object)groupId, (Object)flowSnapshot.getSnapshotMetadata().getVersion());
        VersionControlInformationDTO requestVci = requestEntity.getVersionControlInformation();
        FlowRegistryBucket bucket = flowSnapshot.getBucket();
        RegisteredFlow flow = flowSnapshot.getFlow();
        RegisteredFlowSnapshotMetadata metadata = flowSnapshot.getSnapshotMetadata();
        VersionControlInformationDTO versionControlInfo = new VersionControlInformationDTO();
        versionControlInfo.setBucketId(metadata.getBucketIdentifier());
        versionControlInfo.setBucketName(bucket.getName());
        versionControlInfo.setFlowDescription(flow.getDescription());
        versionControlInfo.setFlowId(flow.getIdentifier());
        versionControlInfo.setFlowName(flow.getName());
        versionControlInfo.setGroupId(groupId);
        versionControlInfo.setRegistryId(requestVci.getRegistryId());
        versionControlInfo.setRegistryName(this.serviceFacade.getFlowRegistryName(requestVci.getRegistryId()));
        versionControlInfo.setStorageLocation(requestVci.getStorageLocation());
        versionControlInfo.setVersion(Integer.valueOf(metadata.getVersion()));
        versionControlInfo.setState(flowSnapshot.isLatest() ? VersionedFlowState.UP_TO_DATE.name() : VersionedFlowState.STALE.name());
        return this.serviceFacade.updateProcessGroupContents(revision, groupId, versionControlInfo, flowSnapshot, idGenerationSeed, verifyNotModified, false, updateDescendantVersionedFlows);
    }

    protected Entity createReplicateUpdateFlowEntity(Revision revision, VersionControlInformationEntity requestEntity, RegisteredFlowSnapshot flowSnapshot) {
        VersionedFlowSnapshotEntity snapshotEntity = new VersionedFlowSnapshotEntity();
        snapshotEntity.setProcessGroupRevision(this.dtoFactory.createRevisionDTO(revision));
        snapshotEntity.setRegistryId(requestEntity.getVersionControlInformation().getRegistryId());
        snapshotEntity.setVersionedFlow(flowSnapshot);
        snapshotEntity.setUpdateDescendantVersionedFlows(Boolean.valueOf(true));
        return snapshotEntity;
    }

    protected VersionedFlowUpdateRequestEntity createUpdateRequestEntity() {
        return new VersionedFlowUpdateRequestEntity();
    }

    protected void finalizeCompletedUpdateRequest(VersionedFlowUpdateRequestEntity requestEntity) {
        VersionedFlowUpdateRequestDTO updateRequestDto = requestEntity.getRequest();
        if (updateRequestDto.isComplete()) {
            VersionControlInformationEntity vciEntity = this.serviceFacade.getVersionControlInformation(updateRequestDto.getProcessGroupId());
            updateRequestDto.setVersionControlInformation(vciEntity == null ? null : vciEntity.getVersionControlInformation());
        }
    }
}

