/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.slf4j.Logger;

public abstract class NiFiAuditor {
    protected static final String SENSITIVE_VALUE_PLACEHOLDER = "********";
    private AuditService auditService;
    private NiFiServiceFacade serviceFacade;
    private ProcessGroupDAO processGroupDAO;

    protected void saveAction(Action action, Logger logger) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(action);
        this.saveActions(actions, logger);
    }

    protected void saveActions(Collection<Action> actions, Logger logger) {
        block2: {
            try {
                this.auditService.addActions(actions);
            }
            catch (Throwable t) {
                logger.warn("Unable to record actions: ", t);
                if (!logger.isDebugEnabled()) break block2;
                logger.warn("", t);
            }
        }
    }

    protected void deletePreviousValues(String propertyName, String componentId, Logger logger) {
        block2: {
            try {
                this.auditService.deletePreviousValues(propertyName, componentId);
            }
            catch (Throwable t) {
                logger.warn("Unable to delete property history", t);
                if (!logger.isDebugEnabled()) break block2;
                logger.warn("", t);
            }
        }
    }

    protected MoveDetails createMoveDetails(String previousGroupId, String newGroupId, Logger logger) {
        FlowChangeMoveDetails moveDetails = null;
        ProcessGroup previousGroup = this.processGroupDAO.getProcessGroup(previousGroupId);
        ProcessGroup newGroup = this.processGroupDAO.getProcessGroup(newGroupId);
        if (previousGroup != null && newGroup != null) {
            moveDetails = new FlowChangeMoveDetails();
            moveDetails.setPreviousGroupId(previousGroup.getIdentifier());
            moveDetails.setPreviousGroup(previousGroup.getName());
            moveDetails.setGroupId(newGroup.getIdentifier());
            moveDetails.setGroup(newGroup.getName());
        } else {
            logger.warn("Unable to record move action because old [{}] and new [{}] groups could not be found.", (Object)previousGroupId, (Object)newGroupId);
        }
        return moveDetails;
    }

    protected String formatExtensionVersion(String type, BundleCoordinate bundle) {
        Object formattedType = "unversioned".equals(bundle.getVersion()) ? type : type + " " + bundle.getVersion();
        Object formattedBundle = "default".equals(bundle.getGroup()) ? bundle.getId() : bundle.getGroup() + " - " + bundle.getId();
        return String.format("%s from %s", formattedType, formattedBundle);
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setProcessGroupDAO(ProcessGroupDAO processGroupDAO) {
        this.processGroupDAO = processGroupDAO;
    }

    public ProcessGroupDAO getProcessGroupDAO() {
        return this.processGroupDAO;
    }
}

