/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.dao.ParameterContextDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ParameterContextAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ParameterContextAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.ParameterContextDAO+) && execution(org.apache.nifi.parameter.ParameterContext createParameterContext(org.apache.nifi.web.api.dto.ParameterContextDTO)) && args(parameterContextDTO) && target(parameterContextDAO)")
    public ParameterContext createParameterContextAdvice(ProceedingJoinPoint proceedingJoinPoint, ParameterContextDTO parameterContextDTO, ParameterContextDAO parameterContextDAO) throws Throwable {
        ParameterContext parameterContext = (ParameterContext)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<Action> actions = new ArrayList<Action>();
            Action createAction = this.generateAuditRecord(parameterContext, Operation.Add);
            actions.add(createAction);
            Map updatedValues = this.extractConfiguredParameterContextValues(parameterContext, parameterContextDTO);
            Date actionTimestamp = new Date(createAction.getTimestamp().getTime() + 1L);
            this.determineActions(user, parameterContext, actions, actionTimestamp, updatedValues, Collections.EMPTY_MAP);
            this.saveActions(actions, logger);
        }
        return parameterContext;
    }

    @Around(value="within(org.apache.nifi.web.dao.ParameterContextDAO+) && execution(org.apache.nifi.parameter.ParameterContext updateParameterContext(org.apache.nifi.web.api.dto.ParameterContextDTO)) && args(parameterContextDTO) && target(parameterContextDAO)")
    public ParameterContext updateParameterContextAdvice(ProceedingJoinPoint proceedingJoinPoint, ParameterContextDTO parameterContextDTO, ParameterContextDAO parameterContextDAO) throws Throwable {
        ParameterContext parameterContext = parameterContextDAO.getParameterContext(parameterContextDTO.getId());
        Map values = this.extractConfiguredParameterContextValues(parameterContext, parameterContextDTO);
        ParameterContext updatedParameterContext = (ParameterContext)proceedingJoinPoint.proceed();
        parameterContext = parameterContextDAO.getParameterContext(updatedParameterContext.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Map updatedValues = this.extractConfiguredParameterContextValues(parameterContext, parameterContextDTO);
            Date actionTimestamp = new Date();
            ArrayList actions = new ArrayList();
            this.determineActions(user, parameterContext, actions, actionTimestamp, updatedValues, values);
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedParameterContext;
    }

    private void determineActions(NiFiUser user, ParameterContext parameterContext, Collection<Action> actions, Date actionTimestamp, Map<String, String> updatedValues, Map<String, String> values) {
        for (String key : updatedValues.keySet()) {
            String newValue = updatedValues.get(key);
            String oldValue = values.get(key);
            Operation operation = null;
            if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                operation = Operation.Configure;
            }
            if (operation == null) continue;
            Parameter parameter = parameterContext.getParameter(key).orElse(null);
            if (parameter != null && parameter.getDescriptor().isSensitive()) {
                if (newValue != null) {
                    newValue = "********";
                }
                if (oldValue != null) {
                    oldValue = "********";
                }
            }
            FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
            actionDetails.setName(key);
            actionDetails.setValue(newValue);
            actionDetails.setPreviousValue(oldValue);
            FlowChangeAction configurationAction = new FlowChangeAction();
            configurationAction.setUserIdentity(user.getIdentity());
            configurationAction.setOperation(operation);
            configurationAction.setTimestamp(actionTimestamp);
            configurationAction.setSourceId(parameterContext.getIdentifier());
            configurationAction.setSourceName(parameterContext.getName());
            configurationAction.setSourceType(Component.ParameterContext);
            configurationAction.setActionDetails((ActionDetails)actionDetails);
            actions.add((Action)configurationAction);
        }
    }

    @Around(value="within(org.apache.nifi.web.dao.ParameterContextDAO+) && execution(void deleteParameterContext(java.lang.String)) && args(parameterContextId) && target(parameterContextDAO)")
    public void removeParameterContextAdvice(ProceedingJoinPoint proceedingJoinPoint, String parameterContextId, ParameterContextDAO parameterContextDAO) throws Throwable {
        ParameterContext parameterContext = parameterContextDAO.getParameterContext(parameterContextId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(parameterContext, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    private Action generateAuditRecord(ParameterContext parameterContext, Operation operation) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(parameterContext.getIdentifier());
            action.setSourceName(parameterContext.getName());
            action.setSourceType(Component.ParameterContext);
        }
        return action;
    }

    private Map<String, String> extractConfiguredParameterContextValues(ParameterContext parameterContext, ParameterContextDTO parameterContextDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (parameterContextDTO.getDescription() != null) {
            values.put("Name", parameterContext.getName());
        }
        if (parameterContextDTO.getDescription() != null) {
            values.put("Description", parameterContext.getDescription());
        }
        if (parameterContextDTO.getParameters() != null) {
            parameterContextDTO.getParameters().forEach(parameterEntity -> {
                ParameterDTO parameterDTO = parameterEntity.getParameter();
                Parameter parameter = parameterContext.getParameter(parameterDTO.getName()).orElse(null);
                if (parameter == null) {
                    values.put(parameterDTO.getName(), null);
                } else {
                    values.put(parameterDTO.getName(), parameter.getValue());
                }
            });
        }
        if (!parameterContext.getInheritedParameterContexts().isEmpty()) {
            values.put("Inherited Parameter Contexts", parameterContext.getInheritedParameterContexts().stream().map(pc -> pc.getIdentifier()).collect(Collectors.joining(", ")));
        }
        if (parameterContext.getParameterProvider() != null) {
            values.put("Sensitive Parameter Provider", parameterContext.getParameterProvider().getIdentifier());
        }
        return values;
    }
}

