/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ParameterProviderResource;
import org.apache.nifi.web.api.ProcessGroupResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.TemplateResource;
import org.apache.nifi.web.api.dto.AboutDTO;
import org.apache.nifi.web.api.dto.BannerDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinQueryDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ClusterSummaryDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.HistoryQueryDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.search.NodeSearchResultDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.entity.AboutEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.BannerEntity;
import org.apache.nifi.web.api.entity.BulletinBoardEntity;
import org.apache.nifi.web.api.entity.ClusteSummaryEntity;
import org.apache.nifi.web.api.entity.ClusterSearchResultsEntity;
import org.apache.nifi.web.api.entity.ComponentHistoryEntity;
import org.apache.nifi.web.api.entity.ConnectionStatisticsEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceTypesEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.ControllerStatusEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBucketEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBucketsEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;
import org.apache.nifi.web.api.entity.ParameterProviderTypesEntity;
import org.apache.nifi.web.api.entity.ParameterProvidersEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.PrioritizerTypesEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorTypesEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTaskTypesEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;
import org.apache.nifi.web.api.entity.RuntimeManifestEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.SearchResultsEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.TemplatesEntity;
import org.apache.nifi.web.api.entity.VersionedFlowEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;
import org.apache.nifi.web.api.entity.VersionedFlowsEntity;
import org.apache.nifi.web.api.metrics.JsonFormatPrometheusMetricsWriter;
import org.apache.nifi.web.api.metrics.TextFormatPrometheusMetricsWriter;
import org.apache.nifi.web.api.request.BulletinBoardPatternParameter;
import org.apache.nifi.web.api.request.DateTimeParameter;
import org.apache.nifi.web.api.request.FlowMetricsProducer;
import org.apache.nifi.web.api.request.FlowMetricsRegistry;
import org.apache.nifi.web.api.request.IntegerParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/flow")
@Api(value="/flow", description="Endpoint for accessing the flow structure and component status.")
public class FlowResource
extends ApplicationResource {
    private static final String NIFI_REGISTRY_TYPE = "org.apache.nifi.registry.flow.NifiRegistryFlowRegistryClient";
    private static final String RECURSIVE = "false";
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private TemplateResource templateResource;
    private ProcessGroupResource processGroupResource;
    private ControllerServiceResource controllerServiceResource;
    private ReportingTaskResource reportingTaskResource;
    private ParameterProviderResource parameterProviderResource;

    private void populateRemainingFlowContent(ProcessGroupFlowDTO flow) {
        FlowDTO flowStructure = flow.getFlow();
        if (flowStructure != null) {
            this.populateRemainingFlowStructure(flowStructure);
        }
        flow.setUri(this.generateResourceUri(new String[]{"flow", "process-groups", flow.getId()}));
    }

    private void populateRemainingFlowStructure(FlowDTO flowStructure) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flowStructure.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flowStructure.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flowStructure.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flowStructure.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flowStructure.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flowStructure.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flowStructure.getLabels());
        this.processGroupResource.populateRemainingProcessGroupEntitiesContent(flowStructure.getProcessGroups());
        for (ProcessGroupEntity processGroupEntity : flowStructure.getProcessGroups()) {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            if (processGroup == null) continue;
            processGroup.setContents(null);
        }
    }

    private void authorizeFlow() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable flow = lookup.getFlow();
            flow.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="client-id")
    @ApiOperation(value="Generates a client id.", response=String.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response generateClientId() {
        this.authorizeFlow();
        return this.generateOkResponse((Object)this.generateUuid()).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi flow", response=FlowConfigurationEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlowConfig() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowConfigurationEntity entity = this.serviceFacade.getFlowConfiguration();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="current-user")
    @ApiOperation(value="Retrieves the user identity of the user making the request", response=CurrentUserEntity.class, authorizations={@Authorization(value="Read - /flow")})
    public Response getCurrentUser() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        CurrentUserEntity entity = this.serviceFacade.getCurrentUser();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Gets a process group", response=ProcessGroupFlowEntity.class, authorizations={@Authorization(value="Read - /flow")}, notes="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlow(@ApiParam(value="The process group id.") @PathParam(value="id") String groupId, @QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessGroupFlowEntity entity = this.serviceFacade.getProcessGroupFlow(groupId, uiOnly);
        this.populateRemainingFlowContent(entity.getProcessGroupFlow());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="metrics/{producer}")
    @ApiOperation(value="Gets all metrics for the flow from a particular node", response=StreamingOutput.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlowMetrics(@ApiParam(value="The producer for flow file metrics. Each producer may have its own output format.", required=true, allowableValues="prometheus") @PathParam(value="producer") String producer, @ApiParam(value="Set of included metrics registries", allowableValues="NIFI,JVM,BULLETIN,CONNECTION") @QueryParam(value="includedRegistries") Set<FlowMetricsRegistry> includedRegistries, @ApiParam(value="Regular Expression Pattern to be applied against the sample name field") @QueryParam(value="sampleName") String sampleName, @ApiParam(value="Regular Expression Pattern to be applied against the sample label value field") @QueryParam(value="sampleLabelValue") String sampleLabelValue, @ApiParam(value="Name of the first field of JSON object. Applicable for JSON producer only.") @QueryParam(value="rootFieldName") String rootFieldName) {
        this.authorizeFlow();
        Set<Object> selectedRegistries = includedRegistries == null ? Collections.emptySet() : includedRegistries;
        Collection registries = this.serviceFacade.generateFlowMetrics(selectedRegistries);
        if (FlowMetricsProducer.PROMETHEUS.getProducer().equalsIgnoreCase(producer)) {
            StreamingOutput response = outputStream -> {
                TextFormatPrometheusMetricsWriter prometheusMetricsWriter = new TextFormatPrometheusMetricsWriter(sampleName, sampleLabelValue);
                prometheusMetricsWriter.write(registries, outputStream);
            };
            return this.generateOkResponse((Object)response).type("text/plain; version=0.0.4; charset=utf-8").build();
        }
        if (FlowMetricsProducer.JSON.getProducer().equals(producer)) {
            StreamingOutput output = outputStream -> {
                JsonFormatPrometheusMetricsWriter jsonPrometheusMetricsWriter = new JsonFormatPrometheusMetricsWriter(sampleName, sampleLabelValue, rootFieldName);
                jsonPrometheusMetricsWriter.write(registries, outputStream);
            };
            return this.generateOkResponse((Object)output).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new ResourceNotFoundException("The specified producer is missing or invalid.");
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/controller-services")
    @ApiOperation(value="Gets controller services for reporting tasks", response=ControllerServicesEntity.class, authorizations={@Authorization(value="Read - /flow")}, notes="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServicesFromController(@QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(null, false, false);
        if (uiOnly) {
            controllerServices.forEach(arg_0 -> ((FlowResource)this).stripNonUiRelevantFields(arg_0));
        }
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/controller-services")
    @ApiOperation(value="Gets all controller services", response=ControllerServicesEntity.class, authorizations={@Authorization(value="Read - /flow")}, notes="If the uiOnly query parameter is provided with a value of true, the returned entity may only contain fields that are necessary for rendering the NiFi User Interface. As such, the selected fields may change at any time, even during incremental releases, without warning. As a result, this parameter should not be provided by any client other than the UI.")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServicesFromGroup(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="Whether or not to include parent/ancestory process groups") @QueryParam(value="includeAncestorGroups") @DefaultValue(value="true") boolean includeAncestorGroups, @ApiParam(value="Whether or not to include descendant process groups") @QueryParam(value="includeDescendantGroups") @DefaultValue(value="false") boolean includeDescendantGroups, @QueryParam(value="uiOnly") @DefaultValue(value="false") boolean uiOnly) {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(groupId, includeAncestorGroups, includeDescendantGroups);
        if (uiOnly) {
            controllerServices.forEach(arg_0 -> ((FlowResource)this).stripNonUiRelevantFields(arg_0));
        }
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-providers")
    @ApiOperation(value="Gets all parameter providers", response=ParameterProvidersEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getParameterProviders() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set parameterProviders = this.serviceFacade.getParameterProviders();
        this.parameterProviderResource.populateRemainingParameterProviderEntitiesContent(parameterProviders);
        ParameterProvidersEntity entity = new ParameterProvidersEntity();
        entity.setParameterProviders(parameterProviders);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @ApiOperation(value="Gets all reporting tasks", response=ReportingTasksEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getReportingTasks() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set reportingTasks = this.serviceFacade.getReportingTasks();
        this.reportingTaskResource.populateRemainingReportingTaskEntitiesContent(reportingTasks);
        ReportingTasksEntity entity = new ReportingTasksEntity();
        entity.setReportingTasks(reportingTasks);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Schedule or unschedule components in the specified Process Group.", response=ScheduleComponentsEntity.class, authorizations={@Authorization(value="Read - /flow"), @Authorization(value="Write - /{component-type}/{uuid} or /operation/{component-type}/{uuid} - For every component being scheduled/unscheduled")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response scheduleComponents(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.", required=true) ScheduleComponentsEntity requestScheduleComponentsEntity) {
        ScheduledState state;
        if (requestScheduleComponentsEntity == null) {
            throw new IllegalArgumentException("Schedule Component must be specified.");
        }
        if (!id.equals(requestScheduleComponentsEntity.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestScheduleComponentsEntity.getId(), id));
        }
        if (requestScheduleComponentsEntity.getState() == null) {
            throw new IllegalArgumentException("The scheduled state must be specified.");
        }
        if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
            state = ScheduledState.STOPPED;
        } else {
            try {
                state = ScheduledState.valueOf((String)requestScheduleComponentsEntity.getState());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join((Object[])new Object[]{Stream.of(ScheduledState.RUNNING, ScheduledState.STOPPED, "ENABLED", ScheduledState.DISABLED), ", "})));
            }
        }
        if (ScheduledState.STARTING.equals((Object)state) || ScheduledState.STOPPING.equals((Object)state)) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join((Object[])new Object[]{Stream.of(ScheduledState.RUNNING, ScheduledState.STOPPED, "ENABLED", ScheduledState.DISABLED), ", "})));
        }
        if (requestScheduleComponentsEntity.getComponents() == null) {
            Supplier<Predicate> getProcessorFilter = () -> {
                if (ScheduledState.RUNNING.equals((Object)state)) {
                    return ProcessGroup.START_PROCESSORS_FILTER;
                }
                if (ScheduledState.STOPPED.equals((Object)state)) {
                    if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
                        return ProcessGroup.ENABLE_PROCESSORS_FILTER;
                    }
                    return ProcessGroup.STOP_PROCESSORS_FILTER;
                }
                return ProcessGroup.DISABLE_PROCESSORS_FILTER;
            };
            Supplier<Predicate> getPortFilter = () -> {
                if (ScheduledState.RUNNING.equals((Object)state)) {
                    return ProcessGroup.START_PORTS_FILTER;
                }
                if (ScheduledState.STOPPED.equals((Object)state)) {
                    if (requestScheduleComponentsEntity.getState().equals("ENABLED")) {
                        return ProcessGroup.ENABLE_PORTS_FILTER;
                    }
                    return ProcessGroup.STOP_PORTS_FILTER;
                }
                return ProcessGroup.DISABLE_PORTS_FILTER;
            };
            Set revisions2 = this.serviceFacade.getRevisionsFromGroup(id, group -> {
                HashSet componentIds = new HashSet();
                group.findAllProcessors().stream().filter((Predicate)getProcessorFilter.get()).filter(processor -> OperationAuthorizable.isOperationAuthorized((Authorizable)processor, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(processor -> componentIds.add(processor.getIdentifier()));
                group.findAllInputPorts().stream().filter((Predicate)getPortFilter.get()).filter(inputPort -> OperationAuthorizable.isOperationAuthorized((Authorizable)inputPort, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(inputPort -> componentIds.add(inputPort.getIdentifier()));
                group.findAllOutputPorts().stream().filter((Predicate)getPortFilter.get()).filter(outputPort -> OperationAuthorizable.isOperationAuthorized((Authorizable)outputPort, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(outputPort -> componentIds.add(outputPort.getIdentifier()));
                return componentIds;
            });
            HashMap componentsToSchedule = new HashMap();
            revisions2.forEach(revision -> {
                RevisionDTO dto = new RevisionDTO();
                dto.setClientId(revision.getClientId());
                dto.setVersion(revision.getVersion());
                componentsToSchedule.put(revision.getComponentId(), dto);
            });
            requestScheduleComponentsEntity.setComponents(componentsToSchedule);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestScheduleComponentsEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestScheduleComponentsEntity.isDisconnectedNodeAcknowledged());
        }
        Map requestComponentsToSchedule = requestScheduleComponentsEntity.getComponents();
        Map<String, Revision> requestComponentRevisions = requestComponentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestComponentRevisions.values());
        return this.withWriteLock(this.serviceFacade, (Entity)requestScheduleComponentsEntity, requestRevisions, lookup -> {
            this.authorizeFlow();
            requestComponentsToSchedule.keySet().forEach(componentId -> {
                Authorizable connectable = lookup.getLocalConnectable(componentId);
                OperationAuthorizable.authorizeOperation((Authorizable)connectable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
            });
        }, () -> {
            if ("ENABLED".equals(requestScheduleComponentsEntity.getState()) || "DISABLED".equals(requestScheduleComponentsEntity.getState())) {
                this.serviceFacade.verifyEnableComponents(id, state, requestComponentRevisions.keySet());
            } else {
                this.serviceFacade.verifyScheduleComponents(id, state, requestComponentRevisions.keySet());
            }
        }, (revisions, scheduleComponentsEntity) -> {
            ScheduledState scheduledState = "ENABLED".equals(scheduleComponentsEntity.getState()) ? ScheduledState.STOPPED : ScheduledState.valueOf((String)scheduleComponentsEntity.getState());
            Map componentsToSchedule = scheduleComponentsEntity.getComponents();
            Map<String, Revision> componentRevisions = componentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
            ScheduleComponentsEntity entity = "ENABLED".equals(scheduleComponentsEntity.getState()) || "DISABLED".equals(scheduleComponentsEntity.getState()) ? this.serviceFacade.enableComponents(id, scheduledState, componentRevisions) : this.serviceFacade.scheduleComponents(id, scheduledState, componentRevisions);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/controller-services")
    @ApiOperation(value="Enable or disable Controller Services in the specified Process Group.", response=ActivateControllerServicesEntity.class, authorizations={@Authorization(value="Read - /flow"), @Authorization(value="Write - /{component-type}/{uuid} or /operation/{component-type}/{uuid} - For every service being enabled/disabled")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response activateControllerServices(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.", required=true) ActivateControllerServicesEntity requestEntity) {
        ControllerServiceState desiredState;
        if (requestEntity == null) {
            throw new IllegalArgumentException("Controller service must be specified.");
        }
        if (!id.equals(requestEntity.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestEntity.getId(), id));
        }
        if (requestEntity.getState() == null) {
            throw new IllegalArgumentException("The controller service state must be specified.");
        }
        try {
            desiredState = ControllerServiceState.valueOf((String)requestEntity.getState());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format("The controller service state must be one of [%s].", StringUtils.join(EnumSet.of(ControllerServiceState.ENABLED, ControllerServiceState.DISABLED), (String)", ")));
        }
        if (ControllerServiceState.DISABLING.equals((Object)desiredState) || ControllerServiceState.ENABLING.equals((Object)desiredState)) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join(EnumSet.of(ControllerServiceState.ENABLED, ControllerServiceState.DISABLED), (String)", ")));
        }
        if (requestEntity.getComponents() == null) {
            Set revisions2 = this.serviceFacade.getRevisionsFromGroup(id, group -> {
                HashSet componentIds = new HashSet();
                Predicate<ControllerServiceNode> filter = ControllerServiceState.ENABLED.equals((Object)desiredState) ? service -> !service.isActive() : ControllerServiceNode::isActive;
                group.findAllControllerServices().stream().filter(filter).filter(service -> OperationAuthorizable.isOperationAuthorized((Authorizable)service, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).forEach(service -> componentIds.add(service.getIdentifier()));
                return componentIds;
            });
            HashMap componentsToSchedule = new HashMap();
            revisions2.forEach(revision -> {
                RevisionDTO dto = new RevisionDTO();
                dto.setClientId(revision.getClientId());
                dto.setVersion(revision.getVersion());
                componentsToSchedule.put(revision.getComponentId(), dto);
            });
            requestEntity.setComponents(componentsToSchedule);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Map requestComponentsToSchedule = requestEntity.getComponents();
        Map<String, Revision> requestComponentRevisions = requestComponentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestComponentRevisions.values());
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevisions, lookup -> {
            this.authorizeFlow();
            requestComponentsToSchedule.keySet().forEach(componentId -> {
                Authorizable authorizable = lookup.getControllerService(componentId).getAuthorizable();
                OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
            });
        }, () -> this.serviceFacade.verifyActivateControllerServices(id, desiredState, requestComponentRevisions.keySet()), (revisions, scheduleComponentsEntity) -> {
            ControllerServiceState serviceState = ControllerServiceState.valueOf((String)scheduleComponentsEntity.getState());
            Map componentsToSchedule = scheduleComponentsEntity.getComponents();
            Map<String, Revision> componentRevisions = componentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
            ActivateControllerServicesEntity entity = this.serviceFacade.activateControllerServices(id, serviceState, componentRevisions);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="search-results")
    @ApiOperation(value="Performs a search against this NiFi using the specified search term", notes="Only search results from authorized components will be returned.", response=SearchResultsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response searchFlow(@QueryParam(value="q") @DefaultValue(value="") String value, @QueryParam(value="a") @DefaultValue(value="") String activeGroupId) {
        this.authorizeFlow();
        SearchResultsDTO results = this.serviceFacade.searchController(value, activeGroupId);
        SearchResultsEntity entity = new SearchResultsEntity();
        entity.setSearchResultsDTO(results);
        return this.noCache(Response.ok((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="status")
    @ApiOperation(value="Gets the current status of this NiFi", response=ControllerStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerStatus() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerStatusDTO controllerStatus = this.serviceFacade.getControllerStatus();
        ControllerStatusEntity entity = new ControllerStatusEntity();
        entity.setControllerStatus(controllerStatus);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/summary")
    @ApiOperation(value="The cluster summary for this NiFi", response=ClusteSummaryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getClusterSummary() {
        this.authorizeFlow();
        ClusterSummaryDTO clusterConfiguration = new ClusterSummaryDTO();
        ClusterCoordinator clusterCoordinator = this.getClusterCoordinator();
        if (clusterCoordinator != null && clusterCoordinator.isConnected()) {
            Map stateMap = clusterCoordinator.getConnectionStates();
            int totalNodeCount = 0;
            for (List nodeList : stateMap.values()) {
                totalNodeCount += nodeList.size();
            }
            List connectedNodeIds = (List)stateMap.get(NodeConnectionState.CONNECTED);
            int connectedNodeCount = connectedNodeIds == null ? 0 : connectedNodeIds.size();
            clusterConfiguration.setConnectedNodeCount(Integer.valueOf(connectedNodeCount));
            clusterConfiguration.setTotalNodeCount(Integer.valueOf(totalNodeCount));
            clusterConfiguration.setConnectedNodes(connectedNodeCount + " / " + totalNodeCount);
        }
        clusterConfiguration.setClustered(Boolean.valueOf(this.isClustered()));
        clusterConfiguration.setConnectedToCluster(Boolean.valueOf(this.isConnectedToCluster()));
        ClusteSummaryEntity entity = new ClusteSummaryEntity();
        entity.setClusterSummary(clusterConfiguration);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/bulletins")
    @ApiOperation(value="Retrieves Controller level bulletins", response=ControllerBulletinsEntity.class, authorizations={@Authorization(value="Read - /flow"), @Authorization(value="Read - /controller - For controller bulletins"), @Authorization(value="Read - /controller-services/{uuid} - For controller service bulletins"), @Authorization(value="Read - /reporting-tasks/{uuid} - For reporting task bulletins")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBulletins() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerBulletinsEntity entity = this.serviceFacade.getControllerBulletins();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="banners")
    @ApiOperation(value="Retrieves the banners for this NiFi", response=BannerEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBanners() {
        this.authorizeFlow();
        String bannerText = this.getProperties().getBannerText();
        BannerDTO bannerDTO = new BannerDTO();
        bannerDTO.setHeaderText(bannerText);
        bannerDTO.setFooterText(bannerText);
        BannerEntity entity = new BannerEntity();
        entity.setBanners(bannerDTO);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processor-types")
    @ApiOperation(value="Retrieves the types of processors that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ProcessorTypesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorTypes(@ApiParam(value="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessorTypesEntity entity = new ProcessorTypesEntity();
        entity.setProcessorTypes(this.serviceFacade.getProcessorTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller-service-types")
    @ApiOperation(value="Retrieves the types of controller services that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ControllerServiceTypesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServiceTypes(@ApiParam(value="If specified, will only return controller services that are compatible with this type of service.") @QueryParam(value="serviceType") String serviceType, @ApiParam(value="If serviceType specified, is the bundle group of the serviceType.") @QueryParam(value="serviceBundleGroup") String serviceBundleGroup, @ApiParam(value="If serviceType specified, is the bundle artifact of the serviceType.") @QueryParam(value="serviceBundleArtifact") String serviceBundleArtifact, @ApiParam(value="If serviceType specified, is the bundle version of the serviceType.") @QueryParam(value="serviceBundleVersion") String serviceBundleVersion, @ApiParam(value="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="typeFilter") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (serviceType != null && (serviceBundleGroup == null || serviceBundleArtifact == null || serviceBundleVersion == null)) {
            throw new IllegalArgumentException("When specifying the serviceType the serviceBundleGroup, serviceBundleArtifact, and serviceBundleVersion must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerServiceTypesEntity entity = new ControllerServiceTypesEntity();
        entity.setControllerServiceTypes(this.serviceFacade.getControllerServiceTypes(serviceType, serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion, bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-task-types")
    @ApiOperation(value="Retrieves the types of reporting tasks that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ReportingTaskTypesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getReportingTaskTypes(@ApiParam(value="If specified, will only return types that are a member of this bundle group.") @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.") @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.") @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ReportingTaskTypesEntity entity = new ReportingTaskTypesEntity();
        entity.setReportingTaskTypes(this.serviceFacade.getReportingTaskTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="runtime-manifest")
    @ApiOperation(value="Retrieves the runtime manifest for this NiFi instance.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RuntimeManifestEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRuntimeManifest() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        RuntimeManifestEntity entity = new RuntimeManifestEntity();
        entity.setRuntimeManifest(this.serviceFacade.getRuntimeManifest());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-provider-types")
    @ApiOperation(value="Retrieves the types of parameter providers that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ParameterProviderTypesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getParameterProviderTypes(@ApiParam(value="If specified, will only return types that are a member of this bundle group.", required=false) @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.", required=false) @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.", required=false) @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ParameterProviderTypesEntity entity = new ParameterProviderTypesEntity();
        entity.setParameterProviderTypes(this.serviceFacade.getParameterProviderTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="prioritizers")
    @ApiOperation(value="Retrieves the types of prioritizers that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=PrioritizerTypesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPrioritizers() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        PrioritizerTypesEntity entity = new PrioritizerTypesEntity();
        entity.setPrioritizerTypes(this.serviceFacade.getWorkQueuePrioritizerTypes());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="about")
    @ApiOperation(value="Retrieves details about this NiFi to put in the About dialog", response=AboutEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAboutInfo() {
        this.authorizeFlow();
        AboutDTO aboutDTO = new AboutDTO();
        aboutDTO.setTitle("NiFi");
        aboutDTO.setUri(this.generateResourceUri(new String[0]));
        aboutDTO.setTimezone(new Date());
        NiFiProperties properties = this.getProperties();
        aboutDTO.setContentViewerUrl(properties.getProperty("nifi.content.viewer.url"));
        Bundle frameworkBundle = NarClassLoadersHolder.getInstance().getFrameworkBundle();
        if (frameworkBundle != null) {
            BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
            aboutDTO.setVersion(frameworkDetails.getCoordinate().getVersion());
            aboutDTO.setBuildTag(frameworkDetails.getBuildTag());
            aboutDTO.setBuildRevision(frameworkDetails.getBuildRevision());
            aboutDTO.setBuildBranch(frameworkDetails.getBuildBranch());
            aboutDTO.setBuildTimestamp(frameworkDetails.getBuildTimestampDate());
        }
        AboutEntity entity = new AboutEntity();
        entity.setAbout(aboutDTO);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries")
    @ApiOperation(value="Gets the listing of available flow registry clients", response=FlowRegistryClientsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRegistryClients() {
        this.authorizeFlow();
        Set registryClients = this.serviceFacade.getRegistryClientsForUser();
        FlowRegistryClientsEntity registryClientEntities = new FlowRegistryClientsEntity();
        registryClientEntities.setRegistries(registryClients);
        return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(registryClientEntities)).build();
    }

    private FlowRegistryClientEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientEntity flowRegistryClientEntity) {
        flowRegistryClientEntity.setUri(this.generateResourceUri(new String[]{"controller", "registry-clients", flowRegistryClientEntity.getId()}));
        if (flowRegistryClientEntity.getComponent().getType().equals(NIFI_REGISTRY_TYPE)) {
            flowRegistryClientEntity.getComponent().setUri((String)flowRegistryClientEntity.getComponent().getProperties().get("url"));
        }
        return flowRegistryClientEntity;
    }

    private FlowRegistryClientsEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientsEntity flowRegistryClientsEntity) {
        for (FlowRegistryClientEntity entity : flowRegistryClientsEntity.getRegistries()) {
            this.populateRemainingRegistryClientEntityContent(entity);
        }
        return flowRegistryClientsEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{id}/buckets")
    @ApiOperation(value="Gets the buckets from the specified registry for the current user", response=FlowRegistryBucketsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBuckets(@ApiParam(value="The registry id.", required=true) @PathParam(value="id") String id) throws NiFiRegistryException {
        this.authorizeFlow();
        Set buckets = this.serviceFacade.getBucketsForUser(id);
        SortedSet sortedBuckets = this.sortBuckets(buckets);
        FlowRegistryBucketsEntity flowRegistryBucketsEntity = new FlowRegistryBucketsEntity();
        flowRegistryBucketsEntity.setBuckets((Set)sortedBuckets);
        return this.generateOkResponse((Object)flowRegistryBucketsEntity).build();
    }

    private SortedSet<FlowRegistryBucketEntity> sortBuckets(Set<FlowRegistryBucketEntity> buckets) {
        TreeSet<FlowRegistryBucketEntity> sortedBuckets = new TreeSet<FlowRegistryBucketEntity>((entity1, entity2) -> Collator.getInstance().compare(this.getBucketName(entity1), this.getBucketName(entity2)));
        sortedBuckets.addAll(buckets);
        return sortedBuckets;
    }

    private String getBucketName(FlowRegistryBucketEntity entity) {
        return entity.getBucket() == null ? null : entity.getBucket().getName();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows")
    @ApiOperation(value="Gets the flows from the specified registry and bucket for the current user", response=VersionedFlowsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlows(@ApiParam(value="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @ApiParam(value="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId) {
        this.authorizeFlow();
        Set registeredFlows = this.serviceFacade.getFlowsForUser(registryId, bucketId);
        SortedSet sortedFlows = this.sortFlows(registeredFlows);
        VersionedFlowsEntity versionedFlowsEntity = new VersionedFlowsEntity();
        versionedFlowsEntity.setVersionedFlows((Set)sortedFlows);
        return this.generateOkResponse((Object)versionedFlowsEntity).build();
    }

    private SortedSet<VersionedFlowEntity> sortFlows(Set<VersionedFlowEntity> versionedFlows) {
        TreeSet<VersionedFlowEntity> sortedFlows = new TreeSet<VersionedFlowEntity>((entity1, entity2) -> Collator.getInstance().compare(this.getFlowName(entity1), this.getFlowName(entity2)));
        sortedFlows.addAll(versionedFlows);
        return sortedFlows;
    }

    private String getFlowName(VersionedFlowEntity flowEntity) {
        return flowEntity.getVersionedFlow() == null ? "" : flowEntity.getVersionedFlow().getFlowName();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows/{flow-id}/details")
    @ApiOperation(value="Gets the details of a flow from the specified registry and bucket for the specified flow for the current user", response=VersionedFlowEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getDetails(@ApiParam(value="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @ApiParam(value="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId, @ApiParam(value="The flow id.", required=true) @PathParam(value="flow-id") String flowId) {
        this.authorizeFlow();
        VersionedFlowEntity flowDetails = this.serviceFacade.getFlowForUser(registryId, bucketId, flowId);
        return this.generateOkResponse((Object)flowDetails).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registries/{registry-id}/buckets/{bucket-id}/flows/{flow-id}/versions")
    @ApiOperation(value="Gets the flow versions from the specified registry and bucket for the specified flow for the current user", response=VersionedFlowSnapshotMetadataSetEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getVersions(@ApiParam(value="The registry client id.", required=true) @PathParam(value="registry-id") String registryId, @ApiParam(value="The bucket id.", required=true) @PathParam(value="bucket-id") String bucketId, @ApiParam(value="The flow id.", required=true) @PathParam(value="flow-id") String flowId) {
        this.authorizeFlow();
        Set registeredFlowSnapshotMetadataSet = this.serviceFacade.getFlowVersionsForUser(registryId, bucketId, flowId);
        VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity = new VersionedFlowSnapshotMetadataSetEntity();
        versionedFlowSnapshotMetadataSetEntity.setVersionedFlowSnapshotMetadataSet(registeredFlowSnapshotMetadataSet);
        return this.generateOkResponse((Object)versionedFlowSnapshotMetadataSetEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="bulletin-board")
    @ApiOperation(value="Gets current bulletins", response=BulletinBoardEntity.class, authorizations={@Authorization(value="Read - /flow"), @Authorization(value="Read - /{component-type}/{uuid} - For component specific bulletins")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBulletinBoard(@ApiParam(value="Includes bulletins with an id after this value.") @QueryParam(value="after") LongParameter after, @ApiParam(value="Includes bulletins originating from this sources whose name match this regular expression.") @QueryParam(value="sourceName") BulletinBoardPatternParameter sourceName, @ApiParam(value="Includes bulletins whose message that match this regular expression.") @QueryParam(value="message") BulletinBoardPatternParameter message, @ApiParam(value="Includes bulletins originating from this sources whose id match this regular expression.") @QueryParam(value="sourceId") BulletinBoardPatternParameter sourceId, @ApiParam(value="Includes bulletins originating from this sources whose group id match this regular expression.") @QueryParam(value="groupId") BulletinBoardPatternParameter groupId, @ApiParam(value="The number of bulletins to limit the response to.") @QueryParam(value="limit") IntegerParameter limit) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        BulletinQueryDTO query = new BulletinQueryDTO();
        if (sourceId != null) {
            query.setSourceId(sourceId.getRawPattern());
        }
        if (groupId != null) {
            query.setGroupId(groupId.getRawPattern());
        }
        if (sourceName != null) {
            query.setName(sourceName.getRawPattern());
        }
        if (message != null) {
            query.setMessage(message.getRawPattern());
        }
        if (after != null) {
            query.setAfter(after.getLong());
        }
        if (limit != null) {
            query.setLimit(limit.getInteger());
        }
        BulletinBoardDTO bulletinBoard = this.serviceFacade.getBulletinBoard(query);
        BulletinBoardEntity entity = new BulletinBoardEntity();
        entity.setBulletinBoard(bulletinBoard);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status")
    @ApiOperation(value="Gets status for a processor", response=ProcessorStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessorStatusEntity entity = (ProcessorStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessorStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessorStatusEntity entity = this.serviceFacade.getProcessorStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="input-ports/{id}/status")
    @ApiOperation(value="Gets status for an input port", response=PortStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputPortStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The input port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getInputPortStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="output-ports/{id}/status")
    @ApiOperation(value="Gets status for an output port", response=PortStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputPortStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The output port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getOutputPortStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status")
    @ApiOperation(value="Gets status for a remote process group", response=RemoteProcessGroupStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroupStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The remote process group id.") @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                RemoteProcessGroupStatusEntity entity = (RemoteProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getRemoteProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        RemoteProcessGroupStatusEntity entity = this.serviceFacade.getRemoteProcessGroupStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status")
    @ApiOperation(value="Gets the status for a process group", notes="The status for a process group includes status for all descendent components. When invoked on the root group with recursive set to true, it will return the current status of every component in the flow.", response=ProcessGroupStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroupStatus(@ApiParam(value="Whether all descendant groups and the status of their content will be included. Optional, defaults to false") @QueryParam(value="recursive") @DefaultValue(value="false") Boolean recursive, @ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessGroupStatusEntity entity = (ProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessGroupStatusEntity entity = this.serviceFacade.getProcessGroupStatus(groupId, recursive.booleanValue());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status")
    @ApiOperation(value="Gets status for a connection", response=ConnectionStatusEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnectionStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ConnectionStatusEntity entity = (ConnectionStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getConnectionStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ConnectionStatusEntity entity = this.serviceFacade.getConnectionStatus(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/statistics")
    @ApiOperation(value="Gets statistics for a connection", response=ConnectionStatisticsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnectionStatistics(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false") @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the statistics.") @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ConnectionStatisticsEntity entity = (ConnectionStatisticsEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getConnectionStatistics().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ConnectionStatisticsEntity entity = this.serviceFacade.getConnectionStatistics(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status/history")
    @ApiOperation(value="Gets status history for a processor", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorStatusHistory(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessorStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status/history")
    @ApiOperation(value="Gets status history for a remote process group", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroupStatusHistory(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessGroupStatusHistory(groupId);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status/history")
    @ApiOperation(value="Gets the status history", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroupStatusHistory(@ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getRemoteProcessGroupStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status/history")
    @ApiOperation(value="Gets the status history for a connection", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnectionStatusHistory(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getConnectionStatusHistory(id);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="parameter-contexts")
    @ApiOperation(value="Gets all Parameter Contexts", response=ParameterContextsEntity.class, authorizations={@Authorization(value="Read - /parameter-contexts/{id} for each Parameter Context")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getParameterContexts() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set parameterContexts = this.serviceFacade.getParameterContexts();
        ParameterContextsEntity entity = new ParameterContextsEntity();
        entity.setParameterContexts(parameterContexts);
        entity.setCurrentTime(new Date());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @ApiOperation(value="Gets configuration history", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=HistoryEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response queryHistory(@ApiParam(value="The offset into the result set.", required=true) @QueryParam(value="offset") IntegerParameter offset, @ApiParam(value="The number of actions to return.", required=true) @QueryParam(value="count") IntegerParameter count, @ApiParam(value="The field to sort on.") @QueryParam(value="sortColumn") String sortColumn, @ApiParam(value="The direction to sort.") @QueryParam(value="sortOrder") String sortOrder, @ApiParam(value="Include actions after this date.") @QueryParam(value="startDate") DateTimeParameter startDate, @ApiParam(value="Include actions before this date.") @QueryParam(value="endDate") DateTimeParameter endDate, @ApiParam(value="Include actions performed by this user.") @QueryParam(value="userIdentity") String userIdentity, @ApiParam(value="Include actions on this component.") @QueryParam(value="sourceId") String sourceId) {
        this.authorizeFlow();
        if (offset == null) {
            throw new IllegalArgumentException("The desired offset must be specified.");
        }
        if (offset.getInteger() < 0) {
            throw new IllegalArgumentException("The desired offset must be an integer value greater than or equal to 0.");
        }
        if (count == null) {
            throw new IllegalArgumentException("The desired row count must be specified.");
        }
        if (count.getInteger() < 1) {
            throw new IllegalArgumentException("The desired row count must be an integer value greater than 0.");
        }
        if (sortOrder != null && !sortOrder.equalsIgnoreCase("asc") && !sortOrder.equalsIgnoreCase("desc")) {
            throw new IllegalArgumentException("The sort order must be 'asc' or 'desc'.");
        }
        if (endDate != null && startDate != null && endDate.getDateTime().before(startDate.getDateTime())) {
            throw new IllegalArgumentException("The start date/time must come before the end date/time.");
        }
        HistoryQueryDTO query = new HistoryQueryDTO();
        query.setSortColumn(sortColumn);
        query.setSortOrder(sortOrder);
        query.setOffset(offset.getInteger());
        query.setCount(count.getInteger());
        if (startDate != null) {
            query.setStartDate(startDate.getDateTime());
        }
        if (endDate != null) {
            query.setEndDate(endDate.getDateTime());
        }
        if (userIdentity != null) {
            query.setUserIdentity(userIdentity);
        }
        if (sourceId != null) {
            query.setSourceId(sourceId);
        }
        HistoryDTO history = this.serviceFacade.getActions(query);
        HistoryEntity entity = new HistoryEntity();
        entity.setHistory(history);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/{id}")
    @ApiOperation(value="Gets an action", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ActionEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAction(@ApiParam(value="The action id.", required=true) @PathParam(value="id") IntegerParameter id) {
        this.authorizeFlow();
        if (id == null) {
            throw new IllegalArgumentException("The action id must be specified.");
        }
        ActionEntity entity = this.serviceFacade.getAction(id.getInteger());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/components/{componentId}")
    @ApiOperation(value="Gets configuration history for a component", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ComponentHistoryEntity.class, authorizations={@Authorization(value="Read - /flow"), @Authorization(value="Read underlying component - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getComponentHistory(@ApiParam(value="The component id.", required=true) @PathParam(value="componentId") String componentId) {
        this.serviceFacade.authorizeAccess(lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            this.authorizeFlow();
            try {
                Authorizable authorizable = lookup.getProcessor(componentId).getAuthorizable();
                authorizable.authorize(this.authorizer, RequestAction.READ, user);
                return;
            }
            catch (ResourceNotFoundException authorizable) {
                try {
                    Authorizable authorizable2 = lookup.getControllerService(componentId).getAuthorizable();
                    authorizable2.authorize(this.authorizer, RequestAction.READ, user);
                    return;
                }
                catch (ResourceNotFoundException authorizable2) {
                    try {
                        Authorizable authorizable3 = lookup.getReportingTask(componentId).getAuthorizable();
                        authorizable3.authorize(this.authorizer, RequestAction.READ, user);
                        return;
                    }
                    catch (ResourceNotFoundException authorizable3) {
                        try {
                            Authorizable authorizable4 = lookup.getParameterProvider(componentId).getAuthorizable();
                            authorizable4.authorize(this.authorizer, RequestAction.READ, user);
                            return;
                        }
                        catch (ResourceNotFoundException authorizable4) {
                            Authorizable controller = lookup.getController();
                            controller.authorize(this.authorizer, RequestAction.READ, user);
                            return;
                        }
                    }
                }
            }
        });
        ComponentHistoryEntity entity = new ComponentHistoryEntity();
        entity.setComponentHistory(this.serviceFacade.getComponentHistory(componentId));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="templates")
    @ApiOperation(value="Gets all templates", response=TemplatesEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getTemplates() {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeFlow();
        Set templates = this.serviceFacade.getTemplates();
        this.templateResource.populateRemainingTemplateEntitiesContent(templates);
        TemplatesEntity entity = new TemplatesEntity();
        entity.setTemplates(templates);
        entity.setGenerated(new Date());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/search-results")
    @ApiOperation(value="Searches the cluster for a node with the specified address", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ClusterSearchResultsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response searchCluster(@ApiParam(value="Node address to search for.", required=true) @QueryParam(value="q") @DefaultValue(value="") String value) {
        this.authorizeFlow();
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        ArrayList<NodeSearchResultDTO> nodeMatches = new ArrayList<NodeSearchResultDTO>();
        ClusterDTO cluster = this.serviceFacade.getCluster();
        for (NodeDTO node : cluster.getNodes()) {
            if (!NodeConnectionState.CONNECTED.name().equals(node.getStatus())) continue;
            String address = node.getAddress() + ":" + node.getApiPort();
            if (!StringUtils.isBlank((CharSequence)value) && !StringUtils.containsIgnoreCase((CharSequence)address, (CharSequence)value)) continue;
            NodeSearchResultDTO nodeMatch = new NodeSearchResultDTO();
            nodeMatch.setId(node.getNodeId());
            nodeMatch.setAddress(address);
            nodeMatches.add(nodeMatch);
        }
        ClusterSearchResultsEntity results = new ClusterSearchResultsEntity();
        results.setNodeResults(nodeMatches);
        return this.noCache(Response.ok((Object)results)).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    public void setProcessGroupResource(ProcessGroupResource processGroupResource) {
        this.processGroupResource = processGroupResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    public void setParameterProviderResource(ParameterProviderResource parameterProviderResource) {
        this.parameterProviderResource = parameterProviderResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

