/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.mapr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class MapRComponentsUtils {
    public static final String DEFAULT_MAPR_HOME = "/opt/mapr";

    public static Path getComponentFolder(String componentName) throws IOException {
        return MapRComponentsUtils.getComponentFolder(componentName, DEFAULT_MAPR_HOME);
    }

    public static Path getComponentFolder(String componentName, String homeFolder) throws IOException {
        String version;
        String component = componentName.toLowerCase();
        try {
            version = MapRComponentsUtils.getComponentVersion(component, homeFolder);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not get version file for %s: %s", componentName, e.getMessage()), e);
        }
        Path path = Paths.get(homeFolder, component, String.format("%s-%s", component, version));
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s folder does not exists in: %s", componentName, path));
        }
        return path;
    }

    private static String getComponentVersion(String component, String homeFolder) throws IOException {
        Path versionPath = Paths.get(homeFolder, component, component + "version");
        try {
            return Files.readAllLines(versionPath).get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Version file is empty " + versionPath, e);
        }
    }
}

