/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.stream.io.util.AbstractDemarcator;

public class StreamDemarcator
extends AbstractDemarcator {
    private final byte[] delimiterBytes;

    public StreamDemarcator(InputStream is, byte[] delimiterBytes, int maxDataSize) {
        this(is, delimiterBytes, maxDataSize, 8192);
    }

    public StreamDemarcator(InputStream is, byte[] delimiterBytes, int maxDataSize, int initialBufferSize) {
        super(is, maxDataSize, initialBufferSize);
        this.validate(delimiterBytes);
        this.delimiterBytes = delimiterBytes;
    }

    public byte[] nextToken() throws IOException {
        byte[] token = null;
        int j = 0;
        block0: while (token == null && this.availableBytesLength != -1) {
            if (this.index >= this.availableBytesLength) {
                this.fill();
            }
            if (this.availableBytesLength != -1) {
                int i;
                for (i = this.index; i < this.availableBytesLength; ++i) {
                    byte byteVal = this.buffer[i];
                    boolean delimiterFound = false;
                    if (this.delimiterBytes != null && this.delimiterBytes[j] == byteVal) {
                        if (++j == this.delimiterBytes.length) {
                            delimiterFound = true;
                        }
                    } else {
                        j = 0;
                    }
                    if (!delimiterFound) continue;
                    this.index = i + 1;
                    int size = this.index - this.mark - this.delimiterBytes.length;
                    token = this.extractDataToken(size);
                    this.mark = this.index;
                    j = 0;
                    if (token != null) break block0;
                }
                this.index = i;
                continue;
            }
            token = this.extractDataToken(this.index - this.mark);
        }
        return token;
    }

    private void validate(byte[] delimiterBytes) {
        if (delimiterBytes != null && delimiterBytes.length == 0) {
            throw new IllegalArgumentException("'delimiterBytes' is an optional argument, but when provided its length must be > 0");
        }
    }
}

