/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.update.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;

public class Criteria {
    private Map<String, Rule> rules;
    private FlowFilePolicy flowFilePolicy;

    public Criteria() {
        this(FlowFilePolicy.USE_CLONE, null);
    }

    public Criteria(FlowFilePolicy flowFilePolicy, List<Rule> ruleList) {
        this.flowFilePolicy = flowFilePolicy;
        this.rules = new LinkedHashMap<String, Rule>();
        if (ruleList != null) {
            for (Rule rule : ruleList) {
                this.rules.put(rule.getId(), rule);
            }
        }
    }

    public void addRule(Rule rule) {
        this.rules.put(rule.getId(), rule);
    }

    public Rule getRule(String ruleId) {
        return this.rules.get(ruleId);
    }

    public void deleteRule(Rule rule) {
        this.rules.remove(rule.getId());
    }

    public List<String> getRuleOrder() {
        return Collections.unmodifiableList(new ArrayList<String>(this.rules.keySet()));
    }

    public void reorder(List<String> newRuleOrder) {
        if (newRuleOrder.size() != this.rules.size() || !newRuleOrder.containsAll(this.rules.keySet())) {
            throw new IllegalArgumentException("New rule order does not account for all known rules or contains unknown rules.");
        }
        LinkedHashMap<String, Rule> newRuleLookup = new LinkedHashMap<String, Rule>();
        for (String ruleId : newRuleOrder) {
            newRuleLookup.put(ruleId, this.rules.get(ruleId));
        }
        this.rules = newRuleLookup;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(new ArrayList<Rule>(this.rules.values()));
    }

    public void setFlowFilePolicy(FlowFilePolicy flowFilePolicy) {
        this.flowFilePolicy = flowFilePolicy;
    }

    public FlowFilePolicy getFlowFilePolicy() {
        return this.flowFilePolicy;
    }
}

