/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog.parsers;

import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import com.github.palindromicity.syslog.SyslogParserBuilder;
import org.apache.nifi.syslog.events.Syslog5424Event;
import org.apache.nifi.syslog.utils.NifiStructuredDataPolicy;
import org.apache.nifi.syslog.utils.NilHandlingPolicy;

public class StrictSyslog5424Parser {
    private final SyslogParser parser;

    public StrictSyslog5424Parser(NilHandlingPolicy nilPolicy, NifiStructuredDataPolicy structuredDataPolicy, KeyProvider keyProvider) {
        this.parser = new SyslogParserBuilder().withNilPolicy(NilPolicy.valueOf((String)nilPolicy.name())).withStructuredDataPolicy(StructuredDataPolicy.valueOf((String)structuredDataPolicy.name())).withKeyProvider(keyProvider).build();
    }

    public Syslog5424Event parseEvent(String line) {
        Syslog5424Event.Builder builder = new Syslog5424Event.Builder().valid(false).fullMessage(line);
        try {
            this.parser.parseLine(line, builder::fieldMap);
            builder.valid(true);
        }
        catch (Exception e) {
            builder.valid(false);
            builder.exception(e);
        }
        return builder.build();
    }
}

