/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.ContentRepositoryContext;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class ByteArrayContentRepository
implements ContentRepository {
    private ResourceClaimManager resourceClaimManager;

    public void initialize(ContentRepositoryContext context) {
        this.resourceClaimManager = context.getResourceClaimManager();
    }

    public void shutdown() {
    }

    public Set<String> getContainerNames() {
        return Collections.singleton("container");
    }

    public long getContainerCapacity(String containerName) {
        return 0L;
    }

    public long getContainerUsableSpace(String containerName) {
        return 0L;
    }

    public String getContainerFileStoreName(String containerName) {
        return "container";
    }

    public ContentClaim create(boolean lossTolerant) {
        ByteArrayContentClaim contentClaim = new ByteArrayContentClaim();
        this.resourceClaimManager.incrementClaimantCount(contentClaim.getResourceClaim());
        return contentClaim;
    }

    public int incrementClaimaintCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        return this.resourceClaimManager.incrementClaimantCount(claim.getResourceClaim());
    }

    public int getClaimantCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        return this.resourceClaimManager.getClaimantCount(claim.getResourceClaim());
    }

    public int decrementClaimantCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        return this.resourceClaimManager.decrementClaimantCount(claim.getResourceClaim());
    }

    public boolean remove(ContentClaim claim) {
        return true;
    }

    public ContentClaim clone(ContentClaim original, boolean lossTolerant) throws IOException {
        ContentClaim clone = this.create(lossTolerant);
        try (InputStream in = this.read(original);
             OutputStream out = this.write(clone);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        return clone;
    }

    public long merge(Collection<ContentClaim> claims, ContentClaim destination, byte[] header, byte[] footer, byte[] demarcator) throws IOException {
        if (claims.contains(destination)) {
            throw new IllegalArgumentException("destination cannot be within claims");
        }
        try (ByteCountingOutputStream out = new ByteCountingOutputStream(this.write(destination));){
            if (header != null) {
                out.write(header);
            }
            int i = 0;
            for (ContentClaim claim : claims) {
                try (InputStream in = this.read(claim);){
                    StreamUtils.copy((InputStream)in, (OutputStream)out);
                }
                if (++i >= claims.size() || demarcator == null) continue;
                out.write(demarcator);
            }
            if (footer != null) {
                out.write(footer);
            }
            long l = out.getBytesWritten();
            return l;
        }
    }

    public long importFrom(Path content, ContentClaim claim) throws IOException {
        try (InputStream in = Files.newInputStream(content, StandardOpenOption.READ);){
            long l = this.importFrom(in, claim);
            return l;
        }
    }

    public long importFrom(InputStream content, ContentClaim claim) throws IOException {
        try (OutputStream out = this.write(claim);){
            long l = StreamUtils.copy((InputStream)content, (OutputStream)out);
            return l;
        }
    }

    public long exportTo(ContentClaim claim, Path destination, boolean append) throws IOException {
        OpenOption[] openOptionArray;
        if (append) {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[2];
            standardOpenOptionArray[0] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[1] = StandardOpenOption.APPEND;
        } else {
            OpenOption[] openOptionArray2 = new StandardOpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.CREATE;
        }
        OpenOption[] openOptions = openOptionArray;
        try (OutputStream out = Files.newOutputStream(destination, openOptions);){
            long l = this.exportTo(claim, out);
            return l;
        }
    }

    public long exportTo(ContentClaim claim, Path destination, boolean append, long offset, long length) throws IOException {
        OpenOption[] openOptionArray;
        if (append) {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[2];
            standardOpenOptionArray[0] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[1] = StandardOpenOption.APPEND;
        } else {
            OpenOption[] openOptionArray2 = new StandardOpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.CREATE;
        }
        OpenOption[] openOptions = openOptionArray;
        try (OutputStream out = Files.newOutputStream(destination, openOptions);){
            long l = this.exportTo(claim, out, offset, length);
            return l;
        }
    }

    public long exportTo(ContentClaim claim, OutputStream destination) throws IOException {
        try (InputStream in = this.read(claim);){
            long l = StreamUtils.copy((InputStream)in, (OutputStream)destination);
            return l;
        }
    }

    public long exportTo(ContentClaim claim, OutputStream destination, long offset, long length) throws IOException {
        try (InputStream in = this.read(claim);){
            StreamUtils.skip((InputStream)in, (long)offset);
            StreamUtils.copy((InputStream)in, (OutputStream)destination, (long)length);
        }
        return length;
    }

    public long size(ContentClaim claim) {
        return claim.getLength();
    }

    public long size(ResourceClaim claim) throws IOException {
        return 0L;
    }

    public InputStream read(ContentClaim claim) {
        if (claim == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayContentClaim byteArrayContentClaim = this.verifyClaim(claim);
        return byteArrayContentClaim.read();
    }

    public InputStream read(ResourceClaim claim) {
        if (claim == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (!(claim instanceof ByteArrayResourceClaim)) {
            throw new IllegalArgumentException("Cannot access Resource Claim " + claim + " because the Resource Claim does not belong to this Content Repository");
        }
        ByteArrayResourceClaim byteArrayResourceClaim = (ByteArrayResourceClaim)claim;
        return byteArrayResourceClaim.read();
    }

    public OutputStream write(ContentClaim claim) {
        ByteArrayContentClaim byteArrayContentClaim = this.verifyClaim(claim);
        return byteArrayContentClaim.writeTo();
    }

    private ByteArrayContentClaim verifyClaim(ContentClaim claim) {
        Objects.requireNonNull(claim);
        if (!(claim instanceof ByteArrayContentClaim)) {
            throw new IllegalArgumentException("Cannot access Content Claim " + claim + " because the Content Claim does not belong to this Content Repository");
        }
        return (ByteArrayContentClaim)claim;
    }

    public void purge() {
    }

    public void cleanup() {
    }

    public byte[] getBytes(ContentClaim contentClaim) {
        ResourceClaim resourceClaim = contentClaim.getResourceClaim();
        if (!(resourceClaim instanceof ByteArrayResourceClaim)) {
            throw new IllegalArgumentException("Given ContentClaim was not created by this Repository");
        }
        return ((ByteArrayResourceClaim)resourceClaim).contents;
    }

    public boolean isAccessible(ContentClaim contentClaim) {
        return false;
    }

    private static class ByteArrayContentClaim
    implements ContentClaim {
        private final ByteArrayResourceClaim resourceClaim = new ByteArrayResourceClaim();

        private ByteArrayContentClaim() {
        }

        public ResourceClaim getResourceClaim() {
            return this.resourceClaim;
        }

        public long getOffset() {
            return 0L;
        }

        public long getLength() {
            return this.resourceClaim.getLength();
        }

        public int compareTo(ContentClaim o) {
            return this.resourceClaim.compareTo(o.getResourceClaim());
        }

        public OutputStream writeTo() {
            return this.resourceClaim.writeTo();
        }

        public InputStream read() {
            return this.resourceClaim.read();
        }

        public int hashCode() {
            return this.resourceClaim.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private static class ByteArrayResourceClaim
    implements ResourceClaim {
        private static final AtomicLong idCounter = new AtomicLong(0L);
        private final String id = String.valueOf(idCounter.getAndIncrement());
        private byte[] contents;

        private ByteArrayResourceClaim() {
        }

        public String getId() {
            return this.id;
        }

        public String getContainer() {
            return "container";
        }

        public String getSection() {
            return "section";
        }

        public boolean isLossTolerant() {
            return true;
        }

        public boolean isWritable() {
            return this.contents == null;
        }

        public boolean isInUse() {
            return true;
        }

        public long getLength() {
            return this.contents == null ? 0L : (long)this.contents.length;
        }

        public OutputStream writeTo() {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    contents = this.toByteArray();
                }
            };
        }

        public InputStream read() {
            if (this.contents == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(this.contents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArrayResourceClaim that = (ByteArrayResourceClaim)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

