/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;

public class StatelessFlowFileRepository
implements FlowFileRepository {
    private final AtomicLong sequenceCounter = new AtomicLong(0L);
    private ResourceClaimManager claimManager;
    private volatile long maxId = 0L;

    public void initialize(ResourceClaimManager claimManager) {
        this.claimManager = claimManager;
    }

    public long getStorageCapacity() {
        return 0L;
    }

    public long getUsableStorageSpace() {
        return 0L;
    }

    public String getFileStoreName() {
        return null;
    }

    public void updateRepository(Collection<RepositoryRecord> records) {
        records.forEach(this::updateClaimCounts);
    }

    private void updateClaimCounts(RepositoryRecord record) {
        ContentClaim currentClaim = record.getCurrentClaim();
        ContentClaim originalClaim = record.getOriginalClaim();
        if (record.getType() == RepositoryRecordType.DELETE || record.getType() == RepositoryRecordType.CONTENTMISSING) {
            this.decrementClaimCount(currentClaim);
        }
        if (record.isContentModified()) {
            this.decrementClaimCount(originalClaim);
        }
    }

    private void decrementClaimCount(ContentClaim claim) {
        if (claim == null) {
            return;
        }
        this.claimManager.decrementClaimantCount(claim.getResourceClaim());
    }

    public long loadFlowFiles(QueueProvider queueProvider) {
        return 0L;
    }

    public Set<String> findQueuesWithFlowFiles(FlowFileSwapManager flowFileSwapManager) {
        throw new UnsupportedOperationException("Finding Queues that contain FlowFiles is not supported in Stateless NiFi");
    }

    public boolean isVolatile() {
        return true;
    }

    public long getNextFlowFileSequence() {
        return this.sequenceCounter.getAndIncrement();
    }

    public long getMaxFlowFileIdentifier() {
        return this.maxId;
    }

    public void updateMaxFlowFileIdentifier(long maxId) {
        this.maxId = maxId;
    }

    public void swapFlowFilesOut(List<FlowFileRecord> swappedOut, FlowFileQueue flowFileQueue, String swapLocation) {
        throw new UnsupportedOperationException("Swapping is not supported");
    }

    public void swapFlowFilesIn(String swapLocation, List<FlowFileRecord> flowFileRecords, FlowFileQueue flowFileQueue) {
        throw new UnsupportedOperationException("Swapping is not supported");
    }

    public boolean isValidSwapLocationSuffix(String swapLocationSuffix) {
        return false;
    }

    public void close() {
    }
}

