/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.controller.state.StandardStateMap;

public class HashMapStateProvider
implements StateProvider {
    private static final int UNKNOWN_STATE_VERSION = -1;
    private final Map<String, StateMap> committedStates = new HashMap<String, StateMap>();
    private final Map<String, StateMap> activeStates = new HashMap<String, StateMap>();

    public void initialize(StateProviderInitializationContext context) {
    }

    public void shutdown() {
    }

    public synchronized void rollback() {
        this.activeStates.clear();
    }

    public synchronized void commit() {
        this.committedStates.putAll(this.activeStates);
    }

    public synchronized Map<String, StateMap> getAllComponentsState() {
        HashMap<String, StateMap> allComponents = new HashMap<String, StateMap>(this.committedStates);
        allComponents.putAll(this.activeStates);
        return allComponents;
    }

    public synchronized void updateAllComponentsStates(Map<String, StateMap> componentStates) {
        if (componentStates == null) {
            return;
        }
        this.activeStates.putAll(componentStates);
    }

    public synchronized void setState(Map<String, String> state, String componentId) {
        StateMap existing = this.getState(componentId);
        long version = existing == null ? -1L : existing.getVersion();
        StandardStateMap updated = new StandardStateMap(state, version + 1L);
        this.activeStates.put(componentId, (StateMap)updated);
    }

    public synchronized StateMap getState(String componentId) {
        StateMap existing = this.activeStates.get(componentId);
        if (existing == null) {
            existing = this.committedStates.get(componentId);
        }
        return existing == null ? new StandardStateMap(Collections.emptyMap(), -1L) : existing;
    }

    public synchronized boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId) {
        StateMap existing = this.getState(componentId);
        if (oldValue.getVersion() == existing.getVersion() && oldValue.toMap().equals(existing.toMap())) {
            this.setState(newValue, componentId);
            return true;
        }
        return false;
    }

    public synchronized void clear(String componentId) {
        this.activeStates.remove(componentId);
        this.committedStates.remove(componentId);
    }

    public void onComponentRemoved(String componentId) {
        this.clear(componentId);
    }

    public void enable() {
    }

    public void disable() {
    }

    public boolean isEnabled() {
        return true;
    }

    public Scope[] getSupportedScopes() {
        return new Scope[]{Scope.CLUSTER, Scope.LOCAL};
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.emptyList();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return new PropertyDescriptor.Builder().name(name).addValidator(Validator.VALID).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return "stateless-state-provider";
    }
}

