/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util.jolt;

import com.bazaarvoice.jolt.CardinalityTransform;
import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.Defaultr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.Modifier;
import com.bazaarvoice.jolt.Removr;
import com.bazaarvoice.jolt.Shiftr;
import com.bazaarvoice.jolt.Sortr;
import com.bazaarvoice.jolt.SpecDriven;
import com.bazaarvoice.jolt.chainr.spec.ChainrEntry;
import com.bazaarvoice.jolt.exception.SpecException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransformFactory {
    public static JoltTransform getTransform(ClassLoader classLoader, String transformType, Object specJson) throws Exception {
        if (transformType.equals("jolt-transform-default")) {
            return new Defaultr(specJson);
        }
        if (transformType.equals("jolt-transform-shift")) {
            return new Shiftr(specJson);
        }
        if (transformType.equals("jolt-transform-remove")) {
            return new Removr(specJson);
        }
        if (transformType.equals("jolt-transform-card")) {
            return new CardinalityTransform(specJson);
        }
        if (transformType.equals("jolt-transform-sort")) {
            return new Sortr();
        }
        if (transformType.equals("jolt-transform-modify-default")) {
            return new Modifier.Defaultr(specJson);
        }
        if (transformType.equals("jolt-transform-modify-overwrite")) {
            return new Modifier.Overwritr(specJson);
        }
        if (transformType.equals("jolt-transform-modify-define")) {
            return new Modifier.Definr(specJson);
        }
        return new Chainr(TransformFactory.getChainrJoltTransformations(classLoader, specJson));
    }

    public static JoltTransform getCustomTransform(ClassLoader classLoader, String customTransformType, Object specJson) throws Exception {
        Class<?> clazz = classLoader.loadClass(customTransformType);
        if (SpecDriven.class.isAssignableFrom(clazz)) {
            Constructor<?> constructor = clazz.getConstructor(Object.class);
            return (JoltTransform)constructor.newInstance(specJson);
        }
        return (JoltTransform)clazz.newInstance();
    }

    protected static List<JoltTransform> getChainrJoltTransformations(ClassLoader classLoader, Object specJson) throws Exception {
        if (!(specJson instanceof List)) {
            throw new SpecException("JOLT Chainr expects a JSON array of objects - Malformed spec.");
        }
        List operations = (List)specJson;
        if (operations.isEmpty()) {
            throw new SpecException("JOLT Chainr passed an empty JSON array.");
        }
        ArrayList<JoltTransform> entries = new ArrayList<JoltTransform>(operations.size());
        for (Object chainrEntryObj : operations) {
            if (!(chainrEntryObj instanceof Map)) {
                throw new SpecException("JOLT ChainrEntry expects a JSON map - Malformed spec");
            }
            Map chainrEntryMap = (Map)chainrEntryObj;
            String opString = (String)chainrEntryMap.get("operation");
            if (opString == null) {
                throw new SpecException("JOLT Chainr 'operation' must implement Transform or ContextualTransform");
            }
            String operationClassName = ChainrEntry.STOCK_TRANSFORMS.containsKey(opString) ? (String)ChainrEntry.STOCK_TRANSFORMS.get(opString) : opString;
            entries.add(TransformFactory.getCustomTransform(classLoader, operationClassName, chainrEntryMap.get("spec")));
        }
        return entries;
    }
}

