/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.util.FormatUtils;

@Tags(value={"disk", "storage", "warning", "monitoring", "repo"})
@CapabilityDescription(value="Checks the amount of storage space available for the specified directory and warns (via a log message and a System-Level Bulletin) if the partition on which it lives exceeds some configurable threshold of storage space")
public class MonitorDiskUsage
extends AbstractReportingTask {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("(\\d+{1,2})%");
    public static final PropertyDescriptor DIR_THRESHOLD = new PropertyDescriptor.Builder().name("Threshold").description("The threshold at which a bulletin will be generated to indicate that the disk usage of the partition on which the directory found is of concern").required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)PERCENT_PATTERN)).defaultValue("80%").build();
    public static final PropertyDescriptor DIR_LOCATION = new PropertyDescriptor.Builder().name("Directory Location").description("The directory path of the partition to be monitored.").required(true).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)false)).build();
    public static final PropertyDescriptor DIR_DISPLAY_NAME = new PropertyDescriptor.Builder().name("Directory Display Name").description("The name to display for the directory in alerts.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("Un-Named").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(2);
        descriptors.add(DIR_THRESHOLD);
        descriptors.add(DIR_LOCATION);
        descriptors.add(DIR_DISPLAY_NAME);
        return descriptors;
    }

    public void onTrigger(ReportingContext context) {
        String thresholdValue = context.getProperty(DIR_THRESHOLD).getValue();
        Matcher thresholdMatcher = PERCENT_PATTERN.matcher(thresholdValue.trim());
        thresholdMatcher.find();
        String thresholdPercentageVal = thresholdMatcher.group(1);
        int contentRepoThreshold = Integer.parseInt(thresholdPercentageVal);
        File dir = new File(context.getProperty(DIR_LOCATION).getValue());
        String dirName = context.getProperty(DIR_DISPLAY_NAME).getValue();
        MonitorDiskUsage.checkThreshold(dirName, dir.toPath(), contentRepoThreshold, this.getLogger());
    }

    static void checkThreshold(String pathName, Path path, int threshold, ComponentLog logger) {
        long freeBytes;
        File file = path.toFile();
        long totalBytes = file.getTotalSpace();
        long usedBytes = totalBytes - (freeBytes = file.getFreeSpace());
        double usedPercent = (double)usedBytes / (double)totalBytes * 100.0;
        if (usedPercent >= (double)threshold) {
            String usedSpace = FormatUtils.formatDataSize((double)usedBytes);
            String totalSpace = FormatUtils.formatDataSize((double)totalBytes);
            String freeSpace = FormatUtils.formatDataSize((double)freeBytes);
            double freePercent = (double)freeBytes / (double)totalBytes * 100.0;
            String message = String.format("%1$s exceeds configured threshold of %2$s%%, having %3$s / %4$s (%5$.2f%%) used and %6$s (%7$.2f%%) free", pathName, threshold, usedSpace, totalSpace, usedPercent, freeSpace, freePercent);
            logger.warn(message);
        }
    }
}

