/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.nifi.processors.standard.calcite.RecordPathFunction;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.StandardFieldValue;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class RecordPathFunctions {
    public static SchemaPlus createRootSchema(CalciteConnection calciteConnection) {
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("RPATH", (Function)ScalarFunctionImpl.create(ObjectRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_STRING", (Function)ScalarFunctionImpl.create(StringRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_INT", (Function)ScalarFunctionImpl.create(IntegerRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_LONG", (Function)ScalarFunctionImpl.create(LongRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_DATE", (Function)ScalarFunctionImpl.create(DateRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_DOUBLE", (Function)ScalarFunctionImpl.create(DoubleRecordPath.class, (String)"eval"));
        rootSchema.add("RPATH_FLOAT", (Function)ScalarFunctionImpl.create(FloatRecordPath.class, (String)"eval"));
        return rootSchema;
    }

    public static class ObjectRecordPath
    extends RecordPathFunction {
        private static final RecordField ROOT_RECORD_FIELD = new RecordField("root", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));
        private static final RecordSchema ROOT_RECORD_SCHEMA = new SimpleRecordSchema(Collections.singletonList(ROOT_RECORD_FIELD));
        private static final RecordField PARENT_RECORD_FIELD = new RecordField("root", RecordFieldType.RECORD.getRecordDataType(ROOT_RECORD_SCHEMA));

        public Object eval(Object record, String recordPath) {
            if (record == null) {
                return null;
            }
            if (record instanceof Record) {
                return this.eval((Record)record, recordPath);
            }
            if (record instanceof Record[]) {
                return this.eval((Record[])record, recordPath);
            }
            if (record instanceof Iterable) {
                return this.eval((Iterable)record, recordPath);
            }
            if (record instanceof Map) {
                return this.eval((Map)record, recordPath);
            }
            throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " against given argument because the argument is of type " + record.getClass() + " instead of Record");
        }

        private Object eval(Map<?, ?> map, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            MapRecord record = new MapRecord(ROOT_RECORD_SCHEMA, Collections.singletonMap("root", map));
            StandardFieldValue parentFieldValue = new StandardFieldValue((Object)record, PARENT_RECORD_FIELD, null);
            StandardFieldValue fieldValue = new StandardFieldValue(map, ROOT_RECORD_FIELD, (FieldValue)parentFieldValue);
            RecordPathResult result = compiled.evaluate((Record)record, (FieldValue)fieldValue);
            List<FieldValue> selectedFields = result.getSelectedFields().collect(Collectors.toList());
            return this.evalResults(selectedFields);
        }

        private Object eval(Record record, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            RecordPathResult result = compiled.evaluate(record);
            List<FieldValue> selectedFields = result.getSelectedFields().collect(Collectors.toList());
            return this.evalResults(selectedFields);
        }

        private Object eval(Iterable<Record> records, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            ArrayList<FieldValue> selectedFields = new ArrayList<FieldValue>();
            for (Record record : records) {
                RecordPathResult result = compiled.evaluate(record);
                result.getSelectedFields().forEach(selectedFields::add);
            }
            return this.evalResults(selectedFields);
        }

        private Object eval(Record[] records, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            ArrayList<FieldValue> selectedFields = new ArrayList<FieldValue>();
            for (Record record : records) {
                RecordPathResult result = compiled.evaluate(record);
                result.getSelectedFields().forEach(selectedFields::add);
            }
            return this.evalResults(selectedFields);
        }

        private Object evalResults(List<FieldValue> selectedFields) {
            if (selectedFields.isEmpty()) {
                return null;
            }
            if (selectedFields.size() == 1) {
                return selectedFields.get(0).getValue();
            }
            return selectedFields.stream().map(FieldValue::getValue).toArray();
        }
    }

    public static class StringRecordPath
    extends RecordPathFunction {
        public String eval(Object record, String recordPath) {
            return this.eval(record, recordPath, Object::toString);
        }
    }

    public static class IntegerRecordPath
    extends RecordPathFunction {
        public Integer eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).intValue();
                }
                if (val instanceof String) {
                    return Integer.parseInt((String)val);
                }
                if (val instanceof Date) {
                    return (int)((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Integer against " + record + " because the value returned is of type " + val.getClass());
            });
        }
    }

    public static class LongRecordPath
    extends RecordPathFunction {
        public Long eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                if (val instanceof String) {
                    return Long.parseLong((String)val);
                }
                if (val instanceof Date) {
                    return ((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Long against " + record + " because the value returned is of type " + val.getClass());
            });
        }
    }

    public static class DateRecordPath
    extends RecordPathFunction {
        public Long eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                if (val instanceof String) {
                    throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Date against " + record + " because the value returned is of type String. To parse a String value as a Date, please use the toDate function. For example, SELECT RPATH_DATE( record, 'toDate( /event/timestamp, \"yyyy-MM-dd\" )' ) AS eventDate FROM FLOWFILE");
                }
                if (val instanceof Date) {
                    return ((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Date against " + record + " because the value returned is of type " + val.getClass());
            });
        }
    }

    public static class DoubleRecordPath
    extends RecordPathFunction {
        public Double eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).doubleValue();
                }
                if (val instanceof String) {
                    return Double.parseDouble((String)val);
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Double against " + record + " because the value returned is of type " + val.getClass());
            });
        }
    }

    public static class FloatRecordPath
    extends RecordPathFunction {
        public Float eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return Float.valueOf(((Number)val).floatValue());
                }
                if (val instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)val));
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Float against " + record + " because the value returned is of type " + val.getClass());
            });
        }
    }
}

