/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class SSHTestServer {
    private static SshServer sshd;
    private String virtualFileSystemPath = "target/ssh_vfs/";
    private final String host = "127.0.0.1";
    private String username = "nifiuser";
    private String password = "nifipassword";

    public int getSSHPort() {
        return sshd.getPort();
    }

    public String getVirtualFileSystemPath() {
        return this.virtualFileSystemPath;
    }

    public void setVirtualFileSystemPath(String virtualFileSystemPath) {
        this.virtualFileSystemPath = virtualFileSystemPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return "127.0.0.1";
    }

    public void startServer() throws IOException {
        sshd = SshServer.setUpDefaultServer();
        sshd.setHost("127.0.0.1");
        sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        sshd.setPublickeyAuthenticator((s, publicKey, serverSession) -> true);
        sshd.setPasswordAuthenticator((username, password, serverSession) -> this.username.equals(username) && this.password.equals(password));
        Path dir = Paths.get(this.getVirtualFileSystemPath(), new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(dir.toAbsolutePath()));
        ArrayList<SftpSubsystemFactory> sftpCommandFactory = new ArrayList<SftpSubsystemFactory>();
        sftpCommandFactory.add(new SftpSubsystemFactory());
        sshd.setSubsystemFactories(sftpCommandFactory);
        sshd.start();
    }

    public void stopServer() throws IOException {
        if (sshd == null) {
            return;
        }
        sshd.stop(true);
        Path dir = Paths.get(this.getVirtualFileSystemPath(), new String[0]);
        FileUtils.deleteDirectory((File)dir.toFile());
    }
}

