/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.standard.ListFile;
import org.apache.nifi.processors.standard.ListSFTP;
import org.apache.nifi.processors.standard.MockCacheService;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.processors.standard.util.SSHTestServer;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestListSFTP {
    private static final String REMOTE_DIRECTORY = "/";
    private static final int TEMPORARY_FILES = 3;
    private static final byte[] FILE_CONTENTS = String.class.getName().getBytes(StandardCharsets.UTF_8);
    private TestRunner runner;
    private SSHTestServer sshServer;

    @BeforeEach
    public void startServer() throws Exception {
        this.sshServer = new SSHTestServer();
        this.sshServer.startServer();
        this.writeTempFile();
        this.runner = TestRunners.newTestRunner(ListSFTP.class);
        this.runner.setProperty(SFTPTransfer.HOSTNAME, this.sshServer.getHost());
        this.runner.setProperty(SFTPTransfer.USERNAME, this.sshServer.getUsername());
        this.runner.setProperty(SFTPTransfer.PASSWORD, this.sshServer.getPassword());
        this.runner.setProperty(SFTPTransfer.PORT, Integer.toString(this.sshServer.getSSHPort()));
        this.runner.setProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT, Boolean.FALSE.toString());
        this.runner.setProperty(ListSFTP.REMOTE_PATH, REMOTE_DIRECTORY);
        this.runner.setProperty(ListFile.TARGET_SYSTEM_TIMESTAMP_PRECISION, ListFile.PRECISION_MILLIS);
        this.runner.assertValid();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.sshServer.stopServer();
        Files.deleteIfExists(Paths.get(this.sshServer.getVirtualFileSystemPath(), new String[0]));
    }

    @Test
    public void testRunFileFound() {
        this.runner.run(1);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 3);
        this.runner.assertAllFlowFilesContainAttribute("sftp.remote.host");
        this.runner.assertAllFlowFilesContainAttribute("sftp.remote.port");
        this.runner.assertAllFlowFilesContainAttribute("sftp.listing.user");
        this.runner.assertAllFlowFilesContainAttribute("file.owner");
        this.runner.assertAllFlowFilesContainAttribute("file.group");
        this.runner.assertAllFlowFilesContainAttribute("file.permissions");
        this.runner.assertAllFlowFilesContainAttribute("file.size");
        this.runner.assertAllFlowFilesContainAttribute("file.lastModifiedTime");
        this.runner.assertAllFlowFilesContainAttribute("filename");
        MockFlowFile retrievedFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ListSFTP.REL_SUCCESS).get(0);
        retrievedFile.assertAttributeEquals("sftp.listing.user", this.sshServer.getUsername());
    }

    @Test
    public void testRunWithRecordWriter() throws InitializationException {
        RecordSetWriterFactory recordWriter = this.getCsvRecordWriter();
        this.runner.addControllerService("csv-record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(AbstractListProcessor.RECORD_WRITER, "csv-record-writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.assertValid((ControllerService)recordWriter);
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 1);
        this.runner.assertAllFlowFilesContainAttribute(CoreAttributes.MIME_TYPE.key());
    }

    @Test
    public void testRunWithRecordWriterNoTracking() throws InitializationException {
        RecordSetWriterFactory recordWriter = this.getCsvRecordWriter();
        this.runner.addControllerService("csv-record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(AbstractListProcessor.RECORD_WRITER, "csv-record-writer");
        this.runner.setProperty(AbstractListProcessor.LISTING_STRATEGY, AbstractListProcessor.NO_TRACKING);
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.assertValid((ControllerService)recordWriter);
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 2);
    }

    @Test
    public void testRunWithRecordWriterByTimestamps() throws InitializationException {
        RecordSetWriterFactory recordWriter = this.getCsvRecordWriter();
        this.runner.addControllerService("csv-record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(AbstractListProcessor.RECORD_WRITER, "csv-record-writer");
        this.runner.setProperty(AbstractListProcessor.LISTING_STRATEGY, AbstractListProcessor.BY_TIMESTAMPS);
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.assertValid((ControllerService)recordWriter);
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 1);
    }

    @Test
    public void testRunWithRecordWriterByEntities() throws InitializationException {
        RecordSetWriterFactory recordWriter = this.getCsvRecordWriter();
        this.runner.addControllerService("csv-record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(AbstractListProcessor.RECORD_WRITER, "csv-record-writer");
        this.runner.setProperty(AbstractListProcessor.LISTING_STRATEGY, AbstractListProcessor.BY_ENTITIES);
        this.runner.enableControllerService((ControllerService)recordWriter);
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(ListedEntityTracker.TRACKING_STATE_CACHE, "dmc");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid((ControllerService)dmc);
        this.runner.assertValid((ControllerService)recordWriter);
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 1);
    }

    @Test
    public void testFilesWithRestart() throws InitializationException {
        RecordSetWriterFactory recordWriter = this.getCsvRecordWriter();
        this.runner.addControllerService("csv-record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(AbstractListProcessor.RECORD_WRITER, "csv-record-writer");
        this.runner.setProperty(AbstractListProcessor.LISTING_STRATEGY, AbstractListProcessor.BY_ENTITIES);
        this.runner.enableControllerService((ControllerService)recordWriter);
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(ListedEntityTracker.TRACKING_STATE_CACHE, "dmc");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 1);
    }

    @Test
    public void testRunFileNotFoundMinSizeFiltered() {
        this.runner.setProperty(ListFile.MIN_SIZE, "1KB");
        this.runner.run(2);
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 0);
    }

    @Test
    public void testRemotePollBatchSizeEnforced() {
        this.runner.setProperty(AbstractListProcessor.LISTING_STRATEGY, AbstractListProcessor.NO_TRACKING);
        this.runner.setProperty(SFTPTransfer.REMOTE_POLL_BATCH_SIZE, "1");
        this.runner.run();
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 1);
        this.runner.setProperty(SFTPTransfer.REMOTE_POLL_BATCH_SIZE, "2");
        this.runner.run();
        this.runner.assertTransferCount(ListSFTP.REL_SUCCESS, 3);
    }

    @Test
    public void testVerificationSuccessful() {
        List results = ((VerifiableProcessor)this.runner.getProcessor()).verify(this.runner.getProcessContext(), (ComponentLog)this.runner.getLogger(), Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)results.size());
        ConfigVerificationResult result = (ConfigVerificationResult)results.get(0);
        Assertions.assertEquals((Object)ConfigVerificationResult.Outcome.SUCCESSFUL, (Object)result.getOutcome());
    }

    private void writeTempFile() {
        for (int i = 0; i < 3; ++i) {
            File file = new File(this.sshServer.getVirtualFileSystemPath(), String.format("%s-%s", this.getClass().getSimpleName(), UUID.randomUUID()));
            try {
                Files.write(file.toPath(), FILE_CONTENTS, new OpenOption[0]);
                file.setLastModified(0L);
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private RecordSetWriterFactory getCsvRecordWriter() {
        return new MockRecordWriter("name, age");
    }
}

