/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListProcessorTestWatcher;
import org.apache.nifi.processors.standard.ListFile;
import org.apache.nifi.processors.standard.util.FileInfo;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test only runs on *nix")
public class TestListFile {
    private static boolean isMillisecondSupported = false;
    private final String TESTDIR = "target/test/data/in";
    private final File testDir = new File("target/test/data/in");
    private ListFile processor;
    private TestRunner runner;
    private ProcessContext context;
    private Long syncTime = TestListFile.getTestModifiedTime();
    private Long time0millis;
    private Long time1millis;
    private Long time2millis;
    private Long time3millis;
    private Long time4millis;
    private Long time5millis;
    private String age0;
    private String age2;
    private String age4;
    private String age5;
    @RegisterExtension
    private final ListProcessorTestWatcher dumpState = new ListProcessorTestWatcher(() -> {
        try {
            return this.runner.getStateManager().getState(Scope.LOCAL).toMap();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve state", e);
        }
    }, () -> this.listFiles(this.testDir).stream().map(f -> new FileInfo.Builder().filename(f.getName()).lastModifiedTime(f.lastModified()).build()).collect(Collectors.toList()), () -> this.runner.getFlowFilesForRelationship(AbstractListProcessor.REL_SUCCESS).stream().map(m -> m).collect(Collectors.toList()));

    @BeforeAll
    public static void setupClass() throws Exception {
        File file = Files.createTempFile(Paths.get("target/", new String[0]), "TestListFile", null, new FileAttribute[0]).toFile();
        file.setLastModified(325990917351L);
        isMillisecondSupported = file.lastModified() % 1000L > 0L;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.processor = new ListFile();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.setProperty(AbstractListProcessor.TARGET_SYSTEM_TIMESTAMP_PRECISION, AbstractListProcessor.PRECISION_SECONDS.getValue());
        this.context = this.runner.getProcessContext();
        this.deleteDirectory(this.testDir);
        Assertions.assertTrue((this.testDir.exists() || this.testDir.mkdirs() ? 1 : 0) != 0, (String)("Unable to create test data directory " + this.testDir.getAbsolutePath()));
        this.resetAges();
    }

    public void tearDown() throws Exception {
        File[] stateFiles;
        this.deleteDirectory(this.testDir);
        File tempFile = this.processor.getPersistenceFile();
        if (tempFile.exists() && (stateFiles = tempFile.getParentFile().listFiles()) != null) {
            for (File stateFile : stateFiles) {
                Assertions.assertTrue((boolean)stateFile.delete());
            }
        }
    }

    private List<File> listFiles(File file) {
        if (file.isDirectory()) {
            ArrayList<File> result = new ArrayList<File>();
            Optional.ofNullable(file.listFiles()).ifPresent(files -> Arrays.stream(files).forEach(f -> result.addAll(this.listFiles((File)f))));
            return result;
        }
        return Collections.singletonList(file);
    }

    private void runNext() throws InterruptedException {
        this.runner.clearTransferState();
        List<File> files = this.listFiles(this.testDir);
        Long lagMillis = isMillisecondSupported ? (Long)AbstractListProcessor.LISTING_LAG_MILLIS.get((Object)TimeUnit.MILLISECONDS) : (Long)AbstractListProcessor.LISTING_LAG_MILLIS.get((Object)TimeUnit.SECONDS);
        Thread.sleep(lagMillis * 2L);
        long startedAtMillis = System.currentTimeMillis();
        this.runner.run();
        this.dumpState.dumpState(startedAtMillis);
    }

    @Test
    public void testGetPath() {
        this.runner.setProperty(ListFile.DIRECTORY, "/dir/test1");
        Assertions.assertEquals((Object)"/dir/test1", (Object)this.processor.getPath(this.context));
        this.runner.setProperty(ListFile.DIRECTORY, "${literal(\"/DIR/TEST2\"):toLower()}");
        Assertions.assertEquals((Object)"/dir/test2", (Object)this.processor.getPath(this.context));
    }

    @Test
    public void testPerformListing() throws Exception {
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runNext();
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 0);
        File file1 = new File("target/test/data/in/listing1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(this.time4millis));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 1 matches the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles1.size());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 1 matches the filter.");
        File file2 = new File("target/test/data/in/listing2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(this.time2millis));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 2 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles2.size());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 2 objects.  Of those, 2 match the filter.");
        File file3 = new File("target/test/data/in/listing3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(this.time4millis));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles3 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)0, (int)successFiles3.size());
        this.runner.removeProperty(ListFile.DIRECTORY);
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles4 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)successFiles4.size());
        this.runNext();
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 0);
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
    }

    @Test
    public void testPathFilterOnlyPicksUpMatchingFiles() throws IOException {
        File aaa = new File("target/test/data/in", "aaa");
        Assertions.assertTrue((aaa.mkdirs() || aaa.exists() ? 1 : 0) != 0);
        File bbb = new File("target/test/data/in", "bbb");
        Assertions.assertTrue((bbb.mkdirs() || bbb.exists() ? 1 : 0) != 0);
        File file1 = new File(aaa, "1.txt");
        File file2 = new File(bbb, "2.txt");
        File file3 = new File("target/test/data/in", "3.txt");
        long tenSecondsAgo = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(10L);
        for (File file : Arrays.asList(file1, file2, file3)) {
            Assertions.assertTrue((file.createNewFile() || file.exists() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)file.setLastModified(tenSecondsAgo));
        }
        this.runner.setProperty(ListFile.DIRECTORY, "target/test/data/in");
        this.runner.setProperty(ListFile.PATH_FILTER, ".+");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS, 2);
    }

    @Test
    public void testFilterAge() throws Exception {
        File file0 = new File("target/test/data/in/age0.txt");
        Assertions.assertTrue((boolean)file0.createNewFile());
        File file2 = new File("target/test/data/in/age2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        File file4 = new File("target/test/data/in/age4.txt");
        Assertions.assertTrue((boolean)file4.createNewFile());
        Function<Boolean, Object> runNext = resetAges -> {
            if (resetAges.booleanValue()) {
                this.resetAges();
                Assertions.assertTrue((boolean)file0.setLastModified(this.time0millis));
                Assertions.assertTrue((boolean)file2.setLastModified(this.time2millis));
                Assertions.assertTrue((boolean)file4.setLastModified(this.time4millis));
            }
            Assertions.assertTrue((file0.lastModified() > this.time3millis && file0.lastModified() <= this.time0millis ? 1 : 0) != 0);
            Assertions.assertTrue((file2.lastModified() > this.time3millis && file2.lastModified() < this.time1millis ? 1 : 0) != 0);
            Assertions.assertTrue((file4.lastModified() < this.time3millis ? 1 : 0) != 0);
            try {
                this.runNext();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return null;
        };
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        runNext.apply(true);
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 3);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)successFiles1.size());
        Assertions.assertEquals((Object)file4.getName(), (Object)((MockFlowFile)successFiles1.get(0)).getAttribute("filename"));
        Assertions.assertEquals((Object)file2.getName(), (Object)((MockFlowFile)successFiles1.get(1)).getAttribute("filename"));
        Assertions.assertEquals((Object)file0.getName(), (Object)((MockFlowFile)successFiles1.get(2)).getAttribute("filename"));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        runNext.apply(false);
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 0);
        this.runner.setProperty(ListFile.MIN_AGE, this.age0);
        this.runner.setProperty(ListFile.MAX_AGE, this.age4);
        runNext.apply(true);
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles2.size());
        Assertions.assertEquals((Object)file2.getName(), (Object)((MockFlowFile)successFiles2.get(0)).getAttribute("filename"));
        Assertions.assertEquals((Object)file0.getName(), (Object)((MockFlowFile)successFiles2.get(1)).getAttribute("filename"));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 2 match the filter.");
        this.runner.setProperty(ListFile.MIN_AGE, this.age2);
        this.runner.setProperty(ListFile.MAX_AGE, this.age5);
        runNext.apply(true);
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles3 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles3.size());
        Assertions.assertEquals((Object)file4.getName(), (Object)((MockFlowFile)successFiles3.get(0)).getAttribute("filename"));
        Assertions.assertEquals((Object)file2.getName(), (Object)((MockFlowFile)successFiles3.get(1)).getAttribute("filename"));
        this.runner.setProperty(ListFile.MIN_AGE, this.age2);
        this.runner.setProperty(ListFile.MAX_AGE, this.age4);
        runNext.apply(true);
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles4 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles4.size());
        Assertions.assertEquals((Object)file2.getName(), (Object)((MockFlowFile)successFiles4.get(0)).getAttribute("filename"));
    }

    @Test
    public void testFilterSize() throws Exception {
        byte[] bytes1000 = new byte[1000];
        byte[] bytes5000 = new byte[5000];
        byte[] bytes10000 = new byte[10000];
        File file1 = new File("target/test/data/in/size1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        FileOutputStream fos = new FileOutputStream(file1);
        fos.write(bytes10000);
        fos.close();
        File file2 = new File("target/test/data/in/size2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        fos = new FileOutputStream(file2);
        fos.write(bytes5000);
        fos.close();
        File file3 = new File("target/test/data/in/size3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        fos = new FileOutputStream(file3);
        fos.write(bytes1000);
        fos.close();
        long now = TestListFile.getTestModifiedTime();
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)successFiles1.size());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runner.removeProperty(ListFile.MIN_AGE);
        this.runner.removeProperty(ListFile.MAX_AGE);
        this.runner.setProperty(ListFile.MIN_SIZE, "0 b");
        this.runner.setProperty(ListFile.MAX_SIZE, "7500 b");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles2.size());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 2 match the filter.");
        this.runner.removeProperty(ListFile.MIN_AGE);
        this.runner.removeProperty(ListFile.MAX_AGE);
        this.runner.setProperty(ListFile.MIN_SIZE, "2500 b");
        this.runner.removeProperty(ListFile.MAX_SIZE);
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles3 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles3.size());
        this.runner.removeProperty(ListFile.MIN_AGE);
        this.runner.removeProperty(ListFile.MAX_AGE);
        this.runner.setProperty(ListFile.MIN_SIZE, "2500 b");
        this.runner.setProperty(ListFile.MAX_SIZE, "7500 b");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 1 matches the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles4 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles4.size());
    }

    @Test
    public void testFilterHidden() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File file1 = new File("target/test/data/in/hidden1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        FileOutputStream fos = new FileOutputStream(file1);
        fos.close();
        File file2 = new File("target/test/data/in/.hidden2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        fos = new FileOutputStream(file2);
        fos.close();
        FileStore store = Files.getFileStore(file2.toPath());
        if (store.supportsFileAttributeView("dos")) {
            Files.setAttribute(file2.toPath(), "dos:hidden", true, new LinkOption[0]);
        }
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, ".*");
        this.runner.removeProperty(ListFile.MIN_AGE);
        this.runner.removeProperty(ListFile.MAX_AGE);
        this.runner.removeProperty(ListFile.MIN_SIZE);
        this.runner.removeProperty(ListFile.MAX_SIZE);
        this.runner.setProperty(ListFile.IGNORE_HIDDEN_FILES, "false");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 2 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles1.size());
        this.runner.setProperty(ListFile.IGNORE_HIDDEN_FILES, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 2 objects.  Of those, 1 matches the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles2.size());
    }

    @Test
    public void testListWithUnreadableFiles() throws Exception {
        File file1 = new File("target/test/data/in/unreadable.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setReadable(false));
        File file2 = new File("target/test/data/in/readable.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        long now = TestListFile.getTestModifiedTime();
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, ".*");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 2 objects.  Of those, 1 matches the filter.");
        this.runNext();
        List successFiles = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListWithinUnreadableDirectory() throws Exception {
        File subdir = new File("target/test/data/in/subdir");
        Assertions.assertTrue((boolean)subdir.mkdir());
        Assertions.assertTrue((boolean)subdir.setReadable(false));
        try {
            File file1 = new File("target/test/data/in/subdir/unreadable.txt");
            Assertions.assertTrue((boolean)file1.createNewFile());
            Assertions.assertTrue((boolean)file1.setReadable(false));
            File file2 = new File("target/test/data/in/subdir/readable.txt");
            Assertions.assertTrue((boolean)file2.createNewFile());
            File file3 = new File("target/test/data/in/secondReadable.txt");
            Assertions.assertTrue((boolean)file3.createNewFile());
            long now = TestListFile.getTestModifiedTime();
            Assertions.assertTrue((boolean)file1.setLastModified(now));
            Assertions.assertTrue((boolean)file2.setLastModified(now));
            Assertions.assertTrue((boolean)file3.setLastModified(now));
            this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
            this.runner.setProperty(ListFile.FILE_FILTER, ".*");
            this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 1 matches the filter.");
            this.runNext();
            List successFiles = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
            Assertions.assertEquals((int)1, (int)successFiles.size());
            Assertions.assertEquals((Object)"secondReadable.txt", (Object)((MockFlowFile)successFiles.get(0)).getAttribute("filename"));
        }
        finally {
            subdir.setReadable(true);
        }
    }

    @Test
    public void testListingNeedsSufficientPrivilegesAndFittingFilter() throws Exception {
        File file = new File("target/test/data/in/file.txt");
        Assertions.assertTrue((boolean)file.createNewFile());
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, "willBeFilteredOut");
        Assertions.assertTrue((boolean)file.setLastModified(TestListFile.getTestModifiedTime()));
        this.runNext();
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)0, (int)successFiles1.size());
        this.runner.setProperty(ListFile.FILE_FILTER, "file.*");
        Assertions.assertTrue((boolean)file.setLastModified(TestListFile.getTestModifiedTime()));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 1 matches the filter.");
        this.runNext();
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles2.size());
        Assertions.assertTrue((boolean)file.setReadable(false));
        Assertions.assertTrue((boolean)file.setLastModified(TestListFile.getTestModifiedTime()));
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 0 match the filter.");
        this.runNext();
        List successFiles3 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)0, (int)successFiles3.size());
    }

    @Test
    public void testFilterFilePattern() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File file1 = new File("target/test/data/in/file1-abc-apple.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        File file2 = new File("target/test/data/in/file2-xyz-apple.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        File file3 = new File("target/test/data/in/file3-xyz-banana.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        File file4 = new File("target/test/data/in/file4-pdq-banana.txt");
        Assertions.assertTrue((boolean)file4.createNewFile());
        Assertions.assertTrue((boolean)file4.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, ListFile.FILE_FILTER.getDefaultValue());
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 4 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)4, (int)successFiles1.size());
        this.runner.setProperty(ListFile.FILE_FILTER, ".*-xyz-.*");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS, 2);
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 0);
    }

    @Test
    public void testFilterPathPattern() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File subdir1 = new File("target/test/data/in/subdir1");
        Assertions.assertTrue((boolean)subdir1.mkdirs());
        File subdir2 = new File("target/test/data/in/subdir1/subdir2");
        Assertions.assertTrue((boolean)subdir2.mkdirs());
        File file1 = new File("target/test/data/in/file1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        File file2 = new File("target/test/data/in/subdir1/file2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        File file3 = new File("target/test/data/in/subdir1/subdir2/file3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        File file4 = new File("target/test/data/in/subdir1/file4.txt");
        Assertions.assertTrue((boolean)file4.createNewFile());
        Assertions.assertTrue((boolean)file4.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, ListFile.FILE_FILTER.getDefaultValue());
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 4 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)4, (int)successFiles1.size());
        this.runner.setProperty(ListFile.PATH_FILTER, "subdir1.*");
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)successFiles2.size());
        this.runner.setProperty(ListFile.PATH_FILTER, ".*/subdir2");
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 4 objects.  Of those, 1 matches the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles3 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles3.size());
    }

    @Test
    public void testFilterPathPatternNegative() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File subdirA = new File("target/test/data/in/AAA");
        Assertions.assertTrue((boolean)subdirA.mkdirs());
        File subdirL = new File("target/test/data/in/LOG");
        Assertions.assertTrue((boolean)subdirL.mkdirs());
        File file1 = new File("target/test/data/in/file1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        File file2 = new File("target/test/data/in/AAA/file2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        File file3 = new File("target/test/data/in/LOG/file3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.FILE_FILTER, ListFile.FILE_FILTER.getDefaultValue());
        this.runner.setProperty(ListFile.PATH_FILTER, "^((?!LOG).)*$");
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 2 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)2, (int)successFiles1.size());
    }

    @Test
    public void testRecurse() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File subdir1 = new File("target/test/data/in/subdir1");
        Assertions.assertTrue((boolean)subdir1.mkdirs());
        File subdir2 = new File("target/test/data/in/subdir1/subdir2");
        Assertions.assertTrue((boolean)subdir2.mkdirs());
        File file1 = new File("target/test/data/in/file1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        File file2 = new File("target/test/data/in/subdir1/file2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        File file3 = new File("target/test/data/in/subdir1/subdir2/file3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS, 3);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        for (MockFlowFile mff : successFiles1) {
            String filename = mff.getAttribute(CoreAttributes.FILENAME.key());
            String path = mff.getAttribute(CoreAttributes.PATH.key());
            switch (filename) {
                case "file1.txt": {
                    Assertions.assertEquals((Object)("." + File.separator), (Object)path);
                    mff.assertAttributeEquals(CoreAttributes.ABSOLUTE_PATH.key(), file1.getParentFile().getAbsolutePath() + File.separator);
                    break;
                }
                case "file2.txt": {
                    Assertions.assertEquals((Object)("subdir1" + File.separator), (Object)path);
                    mff.assertAttributeEquals(CoreAttributes.ABSOLUTE_PATH.key(), file2.getParentFile().getAbsolutePath() + File.separator);
                    break;
                }
                case "file3.txt": {
                    Assertions.assertEquals((Object)("subdir1" + File.separator + "subdir2" + File.separator), (Object)path);
                    mff.assertAttributeEquals(CoreAttributes.ABSOLUTE_PATH.key(), file3.getParentFile().getAbsolutePath() + File.separator);
                }
            }
        }
        Assertions.assertEquals((int)3, (int)successFiles1.size());
        this.runner.setProperty(ListFile.RECURSE, "false");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 1 object.  Of that, 1 matches the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles2 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles2.size());
    }

    @Test
    public void testReadable() throws Exception {
        long now = TestListFile.getTestModifiedTime();
        File file1 = new File("target/test/data/in/file1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        Assertions.assertTrue((boolean)file1.setLastModified(now));
        File file2 = new File("target/test/data/in/file2.txt");
        Assertions.assertTrue((boolean)file2.createNewFile());
        Assertions.assertTrue((boolean)file2.setLastModified(now));
        File file3 = new File("target/test/data/in/file3.txt");
        Assertions.assertTrue((boolean)file3.createNewFile());
        Assertions.assertTrue((boolean)file3.setLastModified(now));
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runner.setProperty(ListFile.RECURSE, "true");
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 3);
    }

    @Test
    public void testAttributesSet() throws Exception {
        File file1 = new File("target/test/data/in/file1.txt");
        Assertions.assertTrue((boolean)file1.createNewFile());
        FileOutputStream fos = new FileOutputStream(file1);
        fos.write(new byte[1234]);
        fos.close();
        Assertions.assertTrue((boolean)file1.setLastModified(this.time3millis));
        Long time3rounded = this.time3millis - this.time3millis % 1000L;
        String userName = System.getProperty("user.name");
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        List successFiles1 = this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFiles1.size());
        Path file1Path = file1.toPath();
        Path directoryPath = new File("target/test/data/in").toPath();
        Path relativePath = directoryPath.relativize(file1.toPath().getParent());
        Object relativePathString = relativePath.toString();
        relativePathString = ((String)relativePathString).isEmpty() ? "." + File.separator : (String)relativePathString + File.separator;
        Path absolutePath = file1.toPath().toAbsolutePath();
        String absolutePathString = absolutePath.getParent().toString() + File.separator;
        FileStore store = Files.getFileStore(file1Path);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        String time3Formatted = formatter.format(Instant.ofEpochMilli(time3rounded).atZone(ZoneId.systemDefault()));
        MockFlowFile mock1 = (MockFlowFile)successFiles1.get(0);
        Assertions.assertEquals((Object)relativePathString, (Object)mock1.getAttribute(CoreAttributes.PATH.key()));
        Assertions.assertEquals((Object)"file1.txt", (Object)mock1.getAttribute(CoreAttributes.FILENAME.key()));
        Assertions.assertEquals((Object)absolutePathString, (Object)mock1.getAttribute(CoreAttributes.ABSOLUTE_PATH.key()));
        Assertions.assertEquals((Object)"1234", (Object)mock1.getAttribute("file.size"));
        if (store.supportsFileAttributeView("basic")) {
            Assertions.assertEquals((Object)time3Formatted, (Object)mock1.getAttribute("file.lastModifiedTime"));
            Assertions.assertNotNull((Object)mock1.getAttribute("file.creationTime"));
            Assertions.assertNotNull((Object)mock1.getAttribute("file.lastAccessTime"));
        }
        if (store.supportsFileAttributeView("owner")) {
            Assertions.assertTrue((boolean)mock1.getAttribute("file.owner").contains(userName));
        }
        if (store.supportsFileAttributeView("posix")) {
            Assertions.assertNotNull((Object)mock1.getAttribute("file.group"), (String)"Group name should be set");
            Assertions.assertNotNull((Object)mock1.getAttribute("file.permissions"), (String)"File permissions should be set");
        }
    }

    @Test
    public void testIsListingResetNecessary() throws Exception {
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.DIRECTORY));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.RECURSE));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.FILE_FILTER));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.PATH_FILTER));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.MIN_AGE));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.MAX_AGE));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.MIN_SIZE));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.MAX_SIZE));
        Assertions.assertTrue((boolean)this.processor.isListingResetNecessary(ListFile.IGNORE_HIDDEN_FILES));
        Assertions.assertFalse((boolean)this.processor.isListingResetNecessary(new PropertyDescriptor.Builder().name("x").build()));
    }

    private void makeTestFile(String name, long millis, Map<String, Long> fileTimes) throws IOException {
        File file = new File("target/test/data/in" + name);
        Assertions.assertTrue((boolean)file.createNewFile());
        Assertions.assertTrue((boolean)file.setLastModified(millis));
        fileTimes.put(file.getName(), file.lastModified());
    }

    @Test
    public void testFilterRunMidFileWrites() throws Exception {
        HashMap<String, Long> fileTimes = new HashMap<String, Long>();
        this.runner.setProperty(ListFile.DIRECTORY, this.testDir.getAbsolutePath());
        this.makeTestFile("/batch1-age3.txt", this.time3millis, fileTimes);
        this.makeTestFile("/batch1-age4.txt", this.time4millis, fileTimes);
        this.makeTestFile("/batch1-age5.txt", this.time5millis, fileTimes);
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 3 objects.  Of those, 3 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 3);
        Assertions.assertEquals((int)3, (int)this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS).size());
        this.makeTestFile("/batch2-age2.txt", this.time2millis, fileTimes);
        this.makeTestFile("/batch2-age3.txt", this.time3millis, fileTimes);
        this.makeTestFile("/batch2-age4.txt", this.time4millis, fileTimes);
        this.assertVerificationOutcome(ConfigVerificationResult.Outcome.SUCCESSFUL, "Successfully listed .* Found 6 objects.  Of those, 6 match the filter.");
        this.runNext();
        this.runner.assertAllFlowFilesTransferred(ListFile.REL_SUCCESS);
        this.runner.assertTransferCount(ListFile.REL_SUCCESS, 2);
        Assertions.assertEquals((int)2, (int)this.runner.getFlowFilesForRelationship(ListFile.REL_SUCCESS).size());
    }

    private static long getTestModifiedTime() {
        long nowMillis = System.currentTimeMillis();
        long nowSeconds = TimeUnit.SECONDS.convert(nowMillis, TimeUnit.MILLISECONDS) - 1L;
        return TimeUnit.MILLISECONDS.convert(nowSeconds, TimeUnit.SECONDS);
    }

    private void resetAges() {
        this.syncTime = TestListFile.getTestModifiedTime();
        long age0millis = 0L;
        long age1millis = 20000L;
        long age2millis = 40000L;
        long age3millis = 60000L;
        long age4millis = 80000L;
        long age5millis = 200000L;
        this.time0millis = this.syncTime - 0L;
        this.time1millis = this.syncTime - 20000L;
        this.time2millis = this.syncTime - 40000L;
        this.time3millis = this.syncTime - 60000L;
        this.time4millis = this.syncTime - 80000L;
        this.time5millis = this.syncTime - 200000L;
        this.age0 = Long.toString(0L) + " millis";
        this.age2 = Long.toString(40000L) + " millis";
        this.age4 = Long.toString(80000L) + " millis";
        this.age5 = Long.toString(200000L) + " millis";
    }

    private void deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                }
                Assertions.assertTrue((boolean)file.delete(), (String)("Could not delete " + file.getAbsolutePath()));
            }
        }
    }

    private void assertVerificationOutcome(ConfigVerificationResult.Outcome expectedOutcome, String expectedExplanationRegex) {
        List results = this.processor.verify(this.runner.getProcessContext(), (ComponentLog)this.runner.getLogger(), Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)results.size());
        ConfigVerificationResult result = (ConfigVerificationResult)results.get(0);
        Assertions.assertEquals((Object)expectedOutcome, (Object)result.getOutcome());
        Assertions.assertTrue((boolean)result.getExplanation().matches(expectedExplanationRegex), (String)String.format("Expected verification result to match pattern [%s].  Actual explanation was: %s", expectedExplanationRegex, result.getExplanation()));
    }
}

