/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.IdentifyMimeType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIdentifyMimeType {
    @Test
    public void testFiles() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new IdentifyMimeType());
        File dir = new File("src/test/resources/TestIdentifyMimeType");
        File[] files = dir.listFiles((ldir, name) -> name != null && !name.startsWith("."));
        int fileCount = 0;
        for (File file : files) {
            if (file.isDirectory()) continue;
            runner.enqueue(file.toPath());
            ++fileCount;
        }
        runner.setThreadCount(1);
        runner.run(fileCount);
        runner.assertAllFlowFilesTransferred(IdentifyMimeType.REL_SUCCESS, fileCount);
        HashMap<String, String> expectedMimeTypes = new HashMap<String, String>();
        expectedMimeTypes.put("1.7z", "application/x-7z-compressed");
        expectedMimeTypes.put("1.mdb", "application/x-msaccess");
        expectedMimeTypes.put("1.txt", "text/plain");
        expectedMimeTypes.put("1.csv", "text/csv");
        expectedMimeTypes.put("1.txt.bz2", "application/x-bzip2");
        expectedMimeTypes.put("1.txt.gz", "application/gzip");
        expectedMimeTypes.put("1.zip", "application/zip");
        expectedMimeTypes.put("bgBannerFoot.png", "image/png");
        expectedMimeTypes.put("blueBtnBg.jpg", "image/jpeg");
        expectedMimeTypes.put("1.pdf", "application/pdf");
        expectedMimeTypes.put("grid.gif", "image/gif");
        expectedMimeTypes.put("1.tar", "application/x-tar");
        expectedMimeTypes.put("1.tar.gz", "application/gzip");
        expectedMimeTypes.put("1.jar", "application/java-archive");
        expectedMimeTypes.put("1.xml", "application/xml");
        expectedMimeTypes.put("1.xhtml", "application/xhtml+xml");
        expectedMimeTypes.put("flowfilev3", StandardFlowFileMediaType.VERSION_3.getMediaType());
        expectedMimeTypes.put("flowfilev3WithXhtml", StandardFlowFileMediaType.VERSION_3.getMediaType());
        expectedMimeTypes.put("flowfilev1.tar", StandardFlowFileMediaType.VERSION_1.getMediaType());
        expectedMimeTypes.put("fake.csv", "text/csv");
        expectedMimeTypes.put("2.custom", "text/plain");
        expectedMimeTypes.put("charset-utf-8.txt", "text/plain");
        HashMap<String, String> expectedExtensions = new HashMap<String, String>();
        expectedExtensions.put("1.7z", ".7z");
        expectedExtensions.put("1.mdb", ".mdb");
        expectedExtensions.put("1.txt", ".txt");
        expectedExtensions.put("1.csv", ".csv");
        expectedExtensions.put("1.txt.bz2", ".bz2");
        expectedExtensions.put("1.txt.gz", ".gz");
        expectedExtensions.put("1.zip", ".zip");
        expectedExtensions.put("bgBannerFoot.png", ".png");
        expectedExtensions.put("blueBtnBg.jpg", ".jpg");
        expectedExtensions.put("1.pdf", ".pdf");
        expectedExtensions.put("grid.gif", ".gif");
        expectedExtensions.put("1.tar", ".tar");
        expectedExtensions.put("1.tar.gz", ".gz");
        expectedExtensions.put("1.jar", ".jar");
        expectedExtensions.put("1.xml", ".xml");
        expectedExtensions.put("1.xhtml", ".xhtml");
        expectedExtensions.put("flowfilev3", "");
        expectedExtensions.put("flowfilev3WithXhtml", "");
        expectedExtensions.put("flowfilev1.tar", "");
        expectedExtensions.put("fake.csv", ".csv");
        expectedExtensions.put("2.custom", ".txt");
        expectedExtensions.put("charset-utf-8.txt", ".txt");
        HashMap<String, String> expectedCharsets = new HashMap<String, String>();
        expectedCharsets.put("1.7z", null);
        expectedCharsets.put("1.mdb", null);
        expectedCharsets.put("1.txt", "ISO-8859-1");
        expectedCharsets.put("1.csv", "ISO-8859-1");
        expectedCharsets.put("1.txt.bz2", null);
        expectedCharsets.put("1.txt.gz", null);
        expectedCharsets.put("1.zip", null);
        expectedCharsets.put("1.pdf", null);
        expectedCharsets.put("1.tar", null);
        expectedCharsets.put("1.tar.gz", null);
        expectedCharsets.put("1.jar", null);
        expectedCharsets.put("1.xml", null);
        expectedCharsets.put("1.xhtml", null);
        expectedCharsets.put("flowfilev3", null);
        expectedCharsets.put("flowfilev3WithXhtml", null);
        expectedCharsets.put("flowfilev1.tar", null);
        expectedCharsets.put("fake.csv", "ISO-8859-1");
        expectedCharsets.put("charset-utf-8.txt", "UTF-8");
        expectedCharsets.put("bgBannerFoot.png", null);
        expectedCharsets.put("blueBtnBg.jpg", null);
        expectedCharsets.put("grid.gif", null);
        expectedCharsets.put("2.custom", "ISO-8859-1");
        expectedCharsets.put("charset-utf-8.txt", "UTF-8");
        List filesOut = runner.getFlowFilesForRelationship(IdentifyMimeType.REL_SUCCESS);
        for (MockFlowFile file : filesOut) {
            String filename = file.getAttribute(CoreAttributes.FILENAME.key());
            String mimeType = file.getAttribute(CoreAttributes.MIME_TYPE.key());
            String expected = (String)expectedMimeTypes.get(filename);
            String extension = file.getAttribute("mime.extension");
            String expectedExtension = (String)expectedExtensions.get(filename);
            String charset = file.getAttribute("mime.charset");
            String expectedCharset = (String)expectedCharsets.get(filename);
            Assertions.assertEquals((Object)expected, (Object)mimeType, (String)("Expected " + file + " to have MIME Type " + expected + ", but it was " + mimeType));
            Assertions.assertEquals((Object)expectedExtension, (Object)extension, (String)("Expected " + file + " to have extension " + expectedExtension + ", but it was " + extension));
            Assertions.assertEquals((Object)expectedCharset, (Object)charset, (String)("Expected " + file + " to have charset \"" + expectedCharset + "\", but it was \"" + charset + "\""));
        }
    }

    @Test
    public void testIgnoreFileName() throws Exception {
        TestRunner runner = TestRunners.newTestRunner((Processor)new IdentifyMimeType());
        runner.setProperty(IdentifyMimeType.USE_FILENAME_IN_DETECTION, "false");
        runner.enqueue(Paths.get("src/test/resources/TestIdentifyMimeType/fake.csv", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(IdentifyMimeType.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(IdentifyMimeType.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals("mime.extension", ".txt");
        flowFile.assertAttributeEquals("mime.type", "text/plain");
    }

    @Test
    public void testConfigBody() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new IdentifyMimeType());
        File dir = new File("src/test/resources/TestIdentifyMimeType");
        File[] files = dir.listFiles((ldir, name) -> name != null && !name.startsWith("."));
        int fileCount = 0;
        for (File file : files) {
            if (file.isDirectory()) continue;
            runner.enqueue(file.toPath());
            ++fileCount;
        }
        String configBody = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mime-info>\n  <mime-type type=\"custom/abcd\">\n    <magic priority=\"50\">\n      <match value=\"abcd\" type=\"string\" offset=\"0\"/>\n    </magic>\n    <glob pattern=\"*.abcd\" />\n  </mime-type>\n  <mime-type type=\"image/png\">\n    <acronym>PNG</acronym>\n    <_comment>Portable Network Graphics</_comment>\n    <magic priority=\"50\">\n      <match value=\"\\x89PNG\\x0d\\x0a\\x1a\\x0a\" type=\"string\" offset=\"0\"/>\n    </magic>\n    <glob pattern=\"*.customPng\"/>\n  </mime-type>\n</mime-info>";
        runner.setProperty(IdentifyMimeType.MIME_CONFIG_BODY, configBody);
        runner.setThreadCount(1);
        runner.run(fileCount);
        runner.assertAllFlowFilesTransferred(IdentifyMimeType.REL_SUCCESS, fileCount);
        HashMap<String, String> expectedMimeTypes = new HashMap<String, String>();
        expectedMimeTypes.put("1.7z", "application/octet-stream");
        expectedMimeTypes.put("1.mdb", "application/octet-stream");
        expectedMimeTypes.put("1.txt", "text/plain");
        expectedMimeTypes.put("1.csv", "text/plain");
        expectedMimeTypes.put("1.txt.bz2", "application/octet-stream");
        expectedMimeTypes.put("1.txt.gz", "application/octet-stream");
        expectedMimeTypes.put("1.zip", "application/octet-stream");
        expectedMimeTypes.put("bgBannerFoot.png", "image/png");
        expectedMimeTypes.put("blueBtnBg.jpg", "application/octet-stream");
        expectedMimeTypes.put("1.pdf", "application/octet-stream");
        expectedMimeTypes.put("grid.gif", "application/octet-stream");
        expectedMimeTypes.put("1.tar", "application/octet-stream");
        expectedMimeTypes.put("1.tar.gz", "application/octet-stream");
        expectedMimeTypes.put("1.jar", "application/octet-stream");
        expectedMimeTypes.put("1.xml", "text/plain");
        expectedMimeTypes.put("1.xhtml", "text/plain");
        expectedMimeTypes.put("flowfilev3", "application/octet-stream");
        expectedMimeTypes.put("flowfilev3WithXhtml", "application/octet-stream");
        expectedMimeTypes.put("flowfilev1.tar", "application/octet-stream");
        expectedMimeTypes.put("fake.csv", "text/plain");
        expectedMimeTypes.put("2.custom", "custom/abcd");
        expectedMimeTypes.put("charset-utf-8.txt", "text/plain");
        HashMap<String, String> expectedExtensions = new HashMap<String, String>();
        expectedExtensions.put("1.7z", "");
        expectedExtensions.put("1.mdb", "");
        expectedExtensions.put("1.txt", "");
        expectedExtensions.put("1.csv", "");
        expectedExtensions.put("1.txt.bz2", "");
        expectedExtensions.put("1.txt.gz", "");
        expectedExtensions.put("1.zip", "");
        expectedExtensions.put("bgBannerFoot.png", ".customPng");
        expectedExtensions.put("blueBtnBg.jpg", "");
        expectedExtensions.put("1.pdf", "");
        expectedExtensions.put("grid.gif", "");
        expectedExtensions.put("1.tar", "");
        expectedExtensions.put("1.tar.gz", "");
        expectedExtensions.put("1.jar", "");
        expectedExtensions.put("1.xml", "");
        expectedExtensions.put("1.xhtml", "");
        expectedExtensions.put("flowfilev3", "");
        expectedExtensions.put("flowfilev3WithXhtml", "");
        expectedExtensions.put("flowfilev1.tar", "");
        expectedExtensions.put("fake.csv", "");
        expectedExtensions.put("2.custom", ".abcd");
        expectedExtensions.put("charset-utf-8.txt", "");
        List filesOut = runner.getFlowFilesForRelationship(IdentifyMimeType.REL_SUCCESS);
        for (MockFlowFile file : filesOut) {
            String filename = file.getAttribute(CoreAttributes.FILENAME.key());
            String mimeType = file.getAttribute(CoreAttributes.MIME_TYPE.key());
            String expected = (String)expectedMimeTypes.get(filename);
            String extension = file.getAttribute("mime.extension");
            String expectedExtension = (String)expectedExtensions.get(filename);
            Assertions.assertEquals((Object)expected, (Object)mimeType, (String)("Expected " + file + " to have MIME Type " + expected + ", but it was " + mimeType));
            Assertions.assertEquals((Object)expectedExtension, (Object)extension, (String)("Expected " + file + " to have extension " + expectedExtension + ", but it was " + extension));
        }
    }

    @Test
    public void testConfigFile() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new IdentifyMimeType());
        File dir = new File("src/test/resources/TestIdentifyMimeType");
        File[] files = dir.listFiles((ldir, name) -> name != null && !name.startsWith("."));
        int fileCount = 0;
        for (File file : files) {
            if (file.isDirectory()) continue;
            runner.enqueue(file.toPath());
            ++fileCount;
        }
        String configFile = "src/test/resources/TestIdentifyMimeType/.customConfig.xml";
        runner.setProperty(IdentifyMimeType.MIME_CONFIG_FILE, configFile);
        runner.setThreadCount(1);
        runner.run(fileCount);
        runner.assertAllFlowFilesTransferred(IdentifyMimeType.REL_SUCCESS, fileCount);
        HashMap<String, String> expectedMimeTypes = new HashMap<String, String>();
        expectedMimeTypes.put("1.7z", "application/octet-stream");
        expectedMimeTypes.put("1.mdb", "application/octet-stream");
        expectedMimeTypes.put("1.txt", "text/plain");
        expectedMimeTypes.put("1.csv", "text/plain");
        expectedMimeTypes.put("1.txt.bz2", "application/octet-stream");
        expectedMimeTypes.put("1.txt.gz", "application/octet-stream");
        expectedMimeTypes.put("1.zip", "application/octet-stream");
        expectedMimeTypes.put("bgBannerFoot.png", "my/png");
        expectedMimeTypes.put("blueBtnBg.jpg", "my/jpeg");
        expectedMimeTypes.put("1.pdf", "application/octet-stream");
        expectedMimeTypes.put("grid.gif", "my/gif");
        expectedMimeTypes.put("1.tar", "application/octet-stream");
        expectedMimeTypes.put("1.tar.gz", "application/octet-stream");
        expectedMimeTypes.put("1.jar", "application/octet-stream");
        expectedMimeTypes.put("1.xml", "text/plain");
        expectedMimeTypes.put("1.xhtml", "text/plain");
        expectedMimeTypes.put("flowfilev3", "application/octet-stream");
        expectedMimeTypes.put("flowfilev3WithXhtml", "application/octet-stream");
        expectedMimeTypes.put("flowfilev1.tar", "application/octet-stream");
        expectedMimeTypes.put("fake.csv", "text/plain");
        expectedMimeTypes.put("2.custom", "text/plain");
        expectedMimeTypes.put("charset-utf-8.txt", "text/plain");
        HashMap<String, String> expectedExtensions = new HashMap<String, String>();
        expectedExtensions.put("1.7z", "");
        expectedExtensions.put("1.mdb", "");
        expectedExtensions.put("1.txt", "");
        expectedExtensions.put("1.csv", "");
        expectedExtensions.put("1.txt.bz2", "");
        expectedExtensions.put("1.txt.gz", "");
        expectedExtensions.put("1.zip", "");
        expectedExtensions.put("bgBannerFoot.png", ".mypng");
        expectedExtensions.put("blueBtnBg.jpg", ".myjpg");
        expectedExtensions.put("1.pdf", "");
        expectedExtensions.put("grid.gif", ".mygif");
        expectedExtensions.put("1.tar", "");
        expectedExtensions.put("1.tar.gz", "");
        expectedExtensions.put("1.jar", "");
        expectedExtensions.put("1.xml", "");
        expectedExtensions.put("1.xhtml", "");
        expectedExtensions.put("flowfilev3", "");
        expectedExtensions.put("flowfilev3WithXhtml", "");
        expectedExtensions.put("flowfilev1.tar", "");
        expectedExtensions.put("fake.csv", "");
        expectedExtensions.put("2.custom", "");
        expectedExtensions.put("charset-utf-8.txt", "");
        List filesOut = runner.getFlowFilesForRelationship(IdentifyMimeType.REL_SUCCESS);
        for (MockFlowFile file : filesOut) {
            String filename = file.getAttribute(CoreAttributes.FILENAME.key());
            String mimeType = file.getAttribute(CoreAttributes.MIME_TYPE.key());
            String expected = (String)expectedMimeTypes.get(filename);
            String extension = file.getAttribute("mime.extension");
            String expectedExtension = (String)expectedExtensions.get(filename);
            Assertions.assertEquals((Object)expected, (Object)mimeType, (String)("Expected " + file + " to have MIME Type " + expected + ", but it was " + mimeType));
            Assertions.assertEquals((Object)expectedExtension, (Object)extension, (String)("Expected " + file + " to have extension " + expectedExtension + ", but it was " + extension));
        }
    }

    @Test
    public void testOnlyOneCustomMimeConfigSpecified() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new IdentifyMimeType());
        String configFile = "src/test/resources/TestIdentifyMimeType/.customConfig.xml";
        runner.setProperty(IdentifyMimeType.MIME_CONFIG_FILE, configFile);
        String configBody = "foo";
        runner.setProperty(IdentifyMimeType.MIME_CONFIG_BODY, configBody);
        runner.setThreadCount(1);
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }
}

