/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroReader;
import org.apache.nifi.avro.AvroRecordSetWriter;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.GenerateRecord;
import org.apache.nifi.processors.standard.faker.FakerUtils;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGenerateRecord {
    private TestRunner testRunner;
    private GenerateRecord processor;

    @BeforeEach
    public void setup() {
        this.processor = new GenerateRecord();
        this.testRunner = TestRunners.newTestRunner((Processor)this.processor);
    }

    @Test
    public void testGenerateNoNullableFields() throws Exception {
        for (Map.Entry fakerProperty : FakerUtils.getDatatypeFunctionMap().entrySet()) {
            this.testRunner.setProperty((String)fakerProperty.getKey(), (String)fakerProperty.getKey());
        }
        Map recordFields = this.processor.getFields(this.testRunner.getProcessContext());
        RecordSchema outputSchema = this.processor.generateRecordSchema(recordFields, false);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "false");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "100");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "3");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        String output = flowFile.getContent();
        for (String line : output.split(System.lineSeparator())) {
            if (!line.endsWith(",")) continue;
            Assertions.fail((String)(line + "should not end with a value"));
        }
    }

    @Test
    public void testGenerateNullableFieldsZeroNullPercentage() throws Exception {
        for (Map.Entry fakerProperty : FakerUtils.getDatatypeFunctionMap().entrySet()) {
            this.testRunner.setProperty((String)fakerProperty.getKey(), (String)fakerProperty.getKey());
        }
        Map recordFields = this.processor.getFields(this.testRunner.getProcessContext());
        RecordSchema outputSchema = this.processor.generateRecordSchema(recordFields, true);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "true");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "0");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "3");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        String output = flowFile.getContent();
        for (String line : output.split(System.lineSeparator())) {
            if (!line.endsWith(",")) continue;
            Assertions.fail((String)(line + "should not end with a value"));
        }
    }

    @Test
    public void testGenerateNullableFieldsOneHundredNullPercentage() throws Exception {
        for (Map.Entry fakerProperty : FakerUtils.getDatatypeFunctionMap().entrySet()) {
            this.testRunner.setProperty((String)fakerProperty.getKey(), (String)fakerProperty.getKey());
        }
        Map recordFields = this.processor.getFields(this.testRunner.getProcessContext());
        RecordSchema outputSchema = this.processor.generateRecordSchema(recordFields, true);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "true");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "100");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "1");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(String.join((CharSequence)"", Collections.nCopies(FakerUtils.getDatatypeFunctionMap().size() - 1, ",")) + "\n");
    }

    @Test
    public void testFieldsReturnValue() throws Exception {
        List fieldTypeFields = Arrays.stream(GenerateRecord.class.getFields()).filter(field -> field.getName().startsWith("FT_")).collect(Collectors.toList());
        for (Field field2 : fieldTypeFields) {
            this.testRunner.setProperty(field2.getName().toLowerCase(Locale.ROOT), ((AllowableValue)field2.get(this.processor)).getValue());
        }
        Map recordFields = this.processor.getFields(this.testRunner.getProcessContext());
        RecordSchema outputSchema = this.processor.generateRecordSchema(recordFields, true);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "true");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "100");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "1");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
    }

    @Test
    public void testGenerateNoNullableFieldsSchemaText() throws Exception {
        String schemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestGenerateRecord/nested_no_nullable.avsc", new String[0])));
        Schema avroSchema = new Schema.Parser().parse(schemaText);
        RecordSchema outputSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.SCHEMA_TEXT, schemaText);
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "true");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "0");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "30");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        String output = flowFile.getContent();
        for (String line : output.split(System.lineSeparator())) {
            if (!line.contains(",,")) continue;
            Assertions.fail((String)(line + "should not contain null values"));
        }
    }

    @Test
    public void testGenerateNullableFieldsZeroNullPercentageSchemaText() throws Exception {
        String schemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestGenerateRecord/nested_nullable.avsc", new String[0])));
        AvroRecordSetWriter recordWriter = new AvroRecordSetWriter();
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.SCHEMA_TEXT, schemaText);
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "false");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "0");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "3");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        AvroReader avroReader = new AvroReader();
        this.testRunner.addControllerService("avroReader", (ControllerService)avroReader);
        this.testRunner.enableControllerService((ControllerService)avroReader);
        byte[] validFlowFileBytes = flowFile.toByteArray();
        try (ByteArrayInputStream resultContentStream = new ByteArrayInputStream(validFlowFileBytes);
             RecordReader recordReader = avroReader.createRecordReader(flowFile.getAttributes(), (InputStream)resultContentStream, (long)validFlowFileBytes.length, (ComponentLog)this.testRunner.getLogger());){
            RecordSchema resultSchema = recordReader.getSchema();
            Optional systemField = resultSchema.getField("System");
            Assertions.assertTrue((boolean)systemField.isPresent());
            Assertions.assertEquals((Object)RecordFieldType.RECORD, (Object)((RecordField)systemField.get()).getDataType().getFieldType());
            RecordDataType systemRecordType = (RecordDataType)((RecordField)systemField.get()).getDataType();
            RecordSchema systemSchema = systemRecordType.getChildSchema();
            Optional providerField = systemSchema.getField("Provider");
            Assertions.assertTrue((boolean)providerField.isPresent());
            Assertions.assertEquals((Object)RecordFieldType.RECORD, (Object)((RecordField)providerField.get()).getDataType().getFieldType());
            RecordDataType providerRecordType = (RecordDataType)((RecordField)providerField.get()).getDataType();
            RecordSchema providerSchema = providerRecordType.getChildSchema();
            Optional guidField = providerSchema.getField("Guid");
            Assertions.assertTrue((boolean)guidField.isPresent());
            Assertions.assertEquals((Object)RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType()), (Object)((RecordField)guidField.get()).getDataType());
            Record record = recordReader.nextRecord();
            Assertions.assertNotNull((Object)record);
            Object systemObject = record.getValue("System");
            Assertions.assertNotNull((Object)systemObject);
            Assertions.assertTrue((boolean)(systemObject instanceof Record));
            Record systemRecord = (Record)systemObject;
            Object providerObject = systemRecord.getValue("Provider");
            Assertions.assertNotNull((Object)providerObject);
            Assertions.assertTrue((boolean)(providerObject instanceof Record));
            Record providerRecord = (Record)providerObject;
            Object guidObject = providerRecord.getValue("Guid");
            Assertions.assertNotNull((Object)guidObject);
            Assertions.assertTrue((boolean)(guidObject instanceof Object[]));
            Object[] guidArray = (Object[])guidObject;
            if (guidArray.length > 0) {
                Assertions.assertTrue((boolean)(guidArray[0] instanceof Byte));
            }
        }
    }

    @Test
    public void testGenerateNullableFieldsOneHundredNullPercentageSchemaText() throws Exception {
        String schemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestGenerateRecord/nested_nullable.avsc", new String[0])));
        Schema avroSchema = new Schema.Parser().parse(schemaText);
        RecordSchema outputSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1, false, outputSchema);
        this.testRunner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.testRunner.enableControllerService((ControllerService)recordWriter);
        this.testRunner.setProperty(GenerateRecord.RECORD_WRITER, "record-writer");
        this.testRunner.setProperty(GenerateRecord.SCHEMA_TEXT, schemaText);
        this.testRunner.setProperty(GenerateRecord.NULLABLE_FIELDS, "false");
        this.testRunner.setProperty(GenerateRecord.NULL_PERCENTAGE, "100");
        this.testRunner.setProperty(GenerateRecord.NUM_RECORDS, "1");
        this.testRunner.run();
        this.testRunner.assertTransferCount(GenerateRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(GenerateRecord.REL_SUCCESS).get(0);
        flowFile.assertContentEquals(",\n");
    }
}

