/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.InvokeHTTP;
import org.apache.nifi.processors.standard.http.ContentEncodingStrategy;
import org.apache.nifi.processors.standard.http.CookieStrategy;
import org.apache.nifi.processors.standard.http.FlowFileNamingStrategy;
import org.apache.nifi.processors.standard.http.HttpHeader;
import org.apache.nifi.processors.standard.http.HttpMethod;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TemporaryKeyStoreBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.LogMessage;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.UriUtils;
import org.apache.nifi.web.util.ssl.SslContextUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class InvokeHTTPTest {
    private static final String HTTP_LOCALHOST_URL = "http://localhost";
    private static final String LOCALHOST = "localhost";
    private static final String BASE_PATH = "/";
    private static final String POST_FORM_PARAMETER_KEY = "post:form:parameter";
    private static final String DATE_HEADER = "Date";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String LOCATION_HEADER = "Location";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String COOKIE_HEADER = "Cookie";
    private static final String COOKIE_1 = "a=apple";
    private static final String COOKIE_2 = "b=banana";
    private static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String REPEATED_HEADER = "Repeated";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String FLOW_FILE_CONTENT = String.class.getName();
    private static final String FLOW_FILE_INITIAL_FILENAME = Double.class.getName();
    private static final int TAKE_REQUEST_COMPLETED_TIMEOUT = 1;
    private static final String TLS_CONNECTION_TIMEOUT = "60 s";
    private static TlsConfiguration generatedTlsConfiguration;
    private static TlsConfiguration truststoreTlsConfiguration;
    private MockWebServer mockWebServer;
    private TestRunner runner;

    @BeforeAll
    public static void setStores() {
        generatedTlsConfiguration = new TemporaryKeyStoreBuilder().build();
        truststoreTlsConfiguration = new StandardTlsConfiguration(null, null, null, generatedTlsConfiguration.getTruststorePath(), generatedTlsConfiguration.getTruststorePassword(), generatedTlsConfiguration.getTruststoreType());
    }

    @BeforeEach
    public void setRunner() {
        this.mockWebServer = new MockWebServer();
        this.runner = TestRunners.newTestRunner((Processor)new InvokeHTTP());
        this.runner.setProperty(InvokeHTTP.SOCKET_IDLE_CONNECTIONS, Integer.toString(0));
    }

    @AfterEach
    public void shutdownServer() throws IOException {
        this.mockWebServer.shutdown();
    }

    @Test
    public void testNotValidWithDefaultProperties() {
        this.runner.assertNotValid();
    }

    @Test
    public void testNotValidWithProxyHostWithoutProxyPort() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.setProperty(InvokeHTTP.PROXY_HOST, String.class.getSimpleName());
        this.runner.assertNotValid();
    }

    @Test
    public void testNotValidWithProxyUserWithoutProxyPassword() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.setProperty(InvokeHTTP.PROXY_USERNAME, String.class.getSimpleName());
        this.runner.assertNotValid();
    }

    @Test
    public void testNotValidWithProxyUserAndPasswordWithoutProxyHost() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.setProperty(InvokeHTTP.PROXY_USERNAME, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.PROXY_PASSWORD, String.class.getSimpleName());
        this.runner.assertNotValid();
    }

    @Test
    public void testNotValidWithPostFormPropertyWithoutFormBodyFormName() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.setProperty(POST_FORM_PARAMETER_KEY, String.class.getSimpleName());
        this.runner.assertNotValid();
    }

    @Test
    public void testNotValidWithPostFormPropertyAndFormBodyFormNameWithoutRequestBodyEnabled() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.setProperty(POST_FORM_PARAMETER_KEY, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.REQUEST_FORM_DATA_NAME, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.REQUEST_BODY_ENABLED, Boolean.FALSE.toString());
        this.runner.assertNotValid();
    }

    @Test
    public void testValidWithMinimumProperties() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, HTTP_LOCALHOST_URL);
        this.runner.assertValid();
    }

    @Test
    public void testRunNoIncomingConnectionsWithNonLoopConnections() {
        this.runner.setIncomingConnection(false);
        this.runner.setNonLoopConnection(true);
        this.setUrlProperty();
        this.runner.run();
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testRunNoIncomingConnectionsPostMethod() {
        this.runner.setIncomingConnection(false);
        this.runner.setNonLoopConnection(false);
        this.setUrlProperty();
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.POST.name());
        this.runner.run();
        this.runner.assertQueueEmpty();
    }

    @Test
    public void testRunGetMalformedUrlExceptionFailureNoIncomingConnections() {
        this.runner.setIncomingConnection(false);
        this.runner.setNonLoopConnection(false);
        this.runner.setProperty(InvokeHTTP.HTTP_URL, "${file.name}");
        this.runner.run();
        List errorMessages = this.runner.getLogger().getErrorMessages();
        Assertions.assertFalse((boolean)errorMessages.isEmpty());
    }

    @Test
    public void testRunGetMalformedUrlExceptionFailure() {
        String urlAttributeKey = "request.url";
        this.runner.setProperty(InvokeHTTP.HTTP_URL, String.format("${%s}", "request.url"));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("request.url", String.class.getSimpleName());
        this.runner.enqueue(FLOW_FILE_CONTENT, attributes);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(InvokeHTTP.FAILURE);
        this.runner.assertPenalizeCount(1);
        MockFlowFile flowFile = this.getFailureFlowFile();
        flowFile.assertAttributeEquals("invokehttp.java.exception.class", IllegalArgumentException.class.getName());
        flowFile.assertAttributeExists("invokehttp.java.exception.message");
    }

    @Test
    public void testRunGetMethodIllegalArgumentExceptionFailure() {
        this.setUrlProperty();
        String methodAttributeKey = "request.method";
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, String.format("${%s}", "request.method"));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("request.method", null);
        this.runner.enqueue(FLOW_FILE_CONTENT, attributes);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(InvokeHTTP.FAILURE);
        this.runner.assertPenalizeCount(1);
        MockFlowFile flowFile = this.getFailureFlowFile();
        flowFile.assertAttributeEquals("invokehttp.java.exception.class", IllegalArgumentException.class.getName());
        flowFile.assertAttributeExists("invokehttp.java.exception.message");
    }

    @Test
    public void testRunGetHttp200Success() throws InterruptedException {
        this.assertRequestMethodSuccess(HttpMethod.GET);
    }

    @Test
    public void testRunGetHttp200SuccessResponseBodyIgnoredEnabled() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.RESPONSE_BODY_IGNORED, Boolean.TRUE.toString());
        this.assertRequestMethodSuccess(HttpMethod.GET);
        MockFlowFile responseFlowFile = this.getResponseFlowFile();
        Assertions.assertEquals((Object)"", (Object)responseFlowFile.getContent());
    }

    @Test
    public void testRunGetHttp200SuccessResponseBodyAttributeName() {
        String outputAttributeKey = String.class.getSimpleName();
        this.runner.setProperty(InvokeHTTP.RESPONSE_BODY_ATTRIBUTE_NAME, outputAttributeKey);
        this.setUrlProperty();
        String body = String.class.getName();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200).setBody(body));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.ORIGINAL, 200);
        MockFlowFile flowFile = this.getRequestFlowFile();
        flowFile.assertAttributeEquals(outputAttributeKey, body);
    }

    @Test
    public void testRunGetHttp200SuccessResponseBodyAttributeNameNoIncomingConnections() {
        String outputAttributeKey = String.class.getSimpleName();
        this.runner.setProperty(InvokeHTTP.RESPONSE_BODY_ATTRIBUTE_NAME, outputAttributeKey);
        this.setUrlProperty();
        this.runner.setIncomingConnection(false);
        this.runner.setNonLoopConnection(false);
        String body = String.class.getName();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200).setBody(body));
        this.runner.run();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.ORIGINAL, 200);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.ORIGINAL).iterator().next();
        flowFile.assertAttributeEquals(outputAttributeKey, body);
    }

    @Test
    public void testRunGetHttp200SuccessNoIncomingConnections() {
        this.runner.setIncomingConnection(false);
        this.runner.setNonLoopConnection(false);
        this.setUrlProperty();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.run();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
    }

    @Test
    public void testRunGetHttp200SuccessProxyHostPortConfigured() throws InterruptedException {
        String mockWebServerUrl = this.getMockWebServerUrl();
        URI uri = URI.create(mockWebServerUrl);
        this.runner.setProperty(InvokeHTTP.HTTP_URL, mockWebServerUrl);
        this.runner.setProperty(InvokeHTTP.PROXY_HOST, uri.getHost());
        this.runner.setProperty(InvokeHTTP.PROXY_PORT, Integer.toString(uri.getPort()));
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String requestLine = request.getRequestLine();
        String proxyRequestLine = String.format("%s %s HTTP/1.1", HttpMethod.GET.name(), mockWebServerUrl);
        Assertions.assertEquals((Object)proxyRequestLine, (Object)requestLine);
    }

    @Test
    public void testRunGetHttp200SuccessProxyHostPortUserPasswordConfigured() throws InterruptedException {
        String mockWebServerUrl = this.getMockWebServerUrl();
        URI uri = URI.create(mockWebServerUrl);
        this.runner.setProperty(InvokeHTTP.HTTP_URL, mockWebServerUrl);
        this.runner.setProperty(InvokeHTTP.PROXY_HOST, uri.getHost());
        this.runner.setProperty(InvokeHTTP.PROXY_PORT, Integer.toString(uri.getPort()));
        this.runner.setProperty(InvokeHTTP.PROXY_USERNAME, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.PROXY_PASSWORD, String.class.getName());
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String requestLine = request.getRequestLine();
        String proxyRequestLine = String.format("%s %s HTTP/1.1", HttpMethod.GET.name(), mockWebServerUrl);
        Assertions.assertEquals((Object)proxyRequestLine, (Object)requestLine);
    }

    @Test
    public void testRunGetHttp200SuccessContentTypeHeaderMimeType() {
        MockResponse response = new MockResponse().setResponseCode(200).setHeader(CONTENT_TYPE_HEADER, (Object)TEXT_PLAIN);
        this.mockWebServer.enqueue(response);
        this.setUrlProperty();
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        MockFlowFile responseFlowFile = this.getResponseFlowFile();
        responseFlowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), TEXT_PLAIN);
    }

    @Test
    public void testRunGetHttp200SuccessRequestDateHeader() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.REQUEST_DATE_HEADER_ENABLED, StringUtils.capitalize((String)Boolean.TRUE.toString()));
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String dateHeader = request.getHeader(DATE_HEADER);
        Assertions.assertNotNull((Object)dateHeader, (String)"Request Date not found");
        Pattern rfcDatePattern = Pattern.compile("^.+? \\d{4} \\d{2}:\\d{2}:\\d{2} GMT$");
        Assertions.assertTrue((boolean)rfcDatePattern.matcher(dateHeader).matches(), (String)"Request Date RFC 2616 not matched");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateHeader, DateTimeFormatter.RFC_1123_DATE_TIME);
        Assertions.assertNotNull((Object)zonedDateTime, (String)"Request Date Parsing Failed");
    }

    @Test
    public void testRunGetHttp200SuccessRequestHeaderAttributesAndDynamicProperties() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.REQUEST_HEADER_ATTRIBUTES_PATTERN, String.format("^%s$", ACCEPT_HEADER));
        String defaultContentTypeHeader = "Default-Content-Type";
        this.runner.setProperty("Default-Content-Type", "application/octet-stream");
        this.setUrlProperty();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ACCEPT_HEADER, TEXT_PLAIN);
        this.runner.enqueue(FLOW_FILE_CONTENT, attributes);
        this.runner.run();
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String acceptHeader = request.getHeader(ACCEPT_HEADER);
        Assertions.assertEquals((Object)TEXT_PLAIN, (Object)acceptHeader);
        String contentType = request.getHeader("Default-Content-Type");
        Assertions.assertEquals((Object)"application/octet-stream", (Object)contentType);
        this.runner.removeProperty(InvokeHTTP.REQUEST_HEADER_ATTRIBUTES_PATTERN);
        this.runner.removeProperty("Default-Content-Type");
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.enqueue(FLOW_FILE_CONTENT, attributes);
        this.runner.run();
        RecordedRequest secondRequest = this.takeRequestCompleted();
        Assertions.assertNull((Object)secondRequest.getHeader(ACCEPT_HEADER), (String)"Accept Header found");
        Assertions.assertNull((Object)secondRequest.getHeader("Default-Content-Type"), (String)"Default-Content-Type Header found");
    }

    @Test
    public void testRunGetHttp200SuccessResponseHeaderRequestAttributes() {
        this.setUrlProperty();
        this.runner.setProperty(InvokeHTTP.RESPONSE_HEADER_REQUEST_ATTRIBUTES_ENABLED, Boolean.TRUE.toString());
        String firstHeader = String.class.getSimpleName();
        String secondHeader = Integer.class.getSimpleName();
        MockResponse response = new MockResponse().setResponseCode(200).addHeader(REPEATED_HEADER, (Object)firstHeader).addHeader(REPEATED_HEADER, (Object)secondHeader);
        this.mockWebServer.enqueue(response);
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        MockFlowFile requestFlowFile = this.getRequestFlowFile();
        requestFlowFile.assertAttributeEquals(CONTENT_LENGTH_HEADER, Integer.toString(0));
        String repeatedHeaders = String.format("%s, %s", firstHeader, secondHeader);
        requestFlowFile.assertAttributeEquals(REPEATED_HEADER, repeatedHeaders);
    }

    @Test
    public void testRunGetHttp200SuccessResponseCacheEnabled() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.RESPONSE_CACHE_ENABLED, Boolean.TRUE.toString());
        this.assertRequestMethodSuccess(HttpMethod.GET);
    }

    @Test
    public void testRunGetHttp200SuccessBasicAuthentication() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.REQUEST_USERNAME, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.REQUEST_PASSWORD, String.class.getName());
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String authorization = request.getHeader(AUTHORIZATION_HEADER);
        Assertions.assertNotNull((Object)authorization, (String)"Authorization Header not found");
        Pattern basicAuthPattern = Pattern.compile("^Basic \\S+$");
        Assertions.assertTrue((boolean)basicAuthPattern.matcher(authorization).matches(), (String)"Basic Authentication not matched");
    }

    @Test
    public void testRunGetHttp200SuccessDigestAuthentication() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.REQUEST_USERNAME, String.class.getSimpleName());
        this.runner.setProperty(InvokeHTTP.REQUEST_PASSWORD, String.class.getName());
        this.runner.setProperty(InvokeHTTP.REQUEST_DIGEST_AUTHENTICATION_ENABLED, Boolean.TRUE.toString());
        String realm = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        String digestHeader = String.format("Digest realm=\"%s\", nonce=\"%s\"", realm, nonce);
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(401).setHeader(AUTHENTICATE_HEADER, (Object)digestHeader));
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        Assertions.assertNull((Object)request.getHeader(AUTHORIZATION_HEADER), (String)"Authorization Header found");
        RecordedRequest authenticatedRequest = this.takeRequestCompleted();
        String authorization = authenticatedRequest.getHeader(AUTHORIZATION_HEADER);
        Assertions.assertNotNull((Object)authorization, (String)"Authorization Header not found");
        Assertions.assertTrue((boolean)authorization.contains(realm), (String)"Digest Realm not found");
        Assertions.assertTrue((boolean)authorization.contains(nonce), (String)"Digest Nonce not found");
    }

    @Test
    public void testRunGetHttp200SuccessSslContextServiceServerTrusted() throws InitializationException, GeneralSecurityException {
        this.assertResponseSuccessSslContextConfigured(generatedTlsConfiguration, truststoreTlsConfiguration);
    }

    @Test
    public void testRunGetHttp200SuccessSslContextServiceMutualTrusted() throws InitializationException, GeneralSecurityException {
        this.assertResponseSuccessSslContextConfigured(generatedTlsConfiguration, generatedTlsConfiguration);
    }

    @Test
    public void testRunGetSslContextServiceMutualTrustedClientCertificateMissing() throws InitializationException, GeneralSecurityException {
        this.runner.setProperty(InvokeHTTP.HTTP2_DISABLED, StringUtils.capitalize((String)Boolean.TRUE.toString()));
        this.setSslContextConfiguration(generatedTlsConfiguration, truststoreTlsConfiguration);
        this.mockWebServer.requireClientAuth();
        this.setUrlProperty();
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(InvokeHTTP.FAILURE);
        MockFlowFile flowFile = this.getFailureFlowFile();
        flowFile.assertAttributeExists("invokehttp.java.exception.class");
        flowFile.assertAttributeExists("invokehttp.java.exception.message");
    }

    @Test
    public void testRunGetHttp200SuccessUserAgentConfigured() throws InterruptedException {
        String userAgent = UUID.randomUUID().toString();
        this.runner.setProperty(InvokeHTTP.REQUEST_USER_AGENT, userAgent);
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String userAgentHeader = request.getHeader(USER_AGENT_HEADER);
        Assertions.assertEquals((Object)userAgent, (Object)userAgentHeader);
    }

    @Test
    void testRunGetHttp200SuccessWithEncodableUrl() throws Exception {
        String partialEncodableUrl = "/gitlab/ftp%2Fstage%2F15m%2FsomeFile.yaml/raw?ref=main";
        String nonEncodedUrl = this.mockWebServer.url("/gitlab/ftp%2Fstage%2F15m%2FsomeFile.yaml/raw?ref=main").newBuilder().host(LOCALHOST).build().toString();
        String encodedUrl = UriUtils.create((String)nonEncodedUrl).toURL().toExternalForm();
        this.runner.setProperty(InvokeHTTP.HTTP_URL, nonEncodedUrl);
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        MockFlowFile flowFile = this.getResponseFlowFile();
        String actualUrl = flowFile.getAttribute("invokehttp.request.url");
        Assertions.assertNotEquals((Object)encodedUrl, (Object)actualUrl);
        Assertions.assertTrue((boolean)actualUrl.endsWith("/gitlab/ftp%2Fstage%2F15m%2FsomeFile.yaml/raw?ref=main"));
        ProvenanceEventRecord event = this.runner.getProvenanceEvents().stream().filter(record -> record.getEventType() == ProvenanceEventType.FETCH).findFirst().orElse(null);
        Assertions.assertNotNull((Object)event);
        String transitUri = event.getTransitUri();
        Assertions.assertNotEquals((Object)encodedUrl, (Object)transitUri);
        Assertions.assertTrue((boolean)transitUri.endsWith("/gitlab/ftp%2Fstage%2F15m%2FsomeFile.yaml/raw?ref=main"));
    }

    @Test
    public void testRunGetHttp302NoRetryResponseRedirectsDefaultEnabled() {
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(302).setHeader(LOCATION_HEADER, (Object)this.getMockWebServerUrl()));
        this.enqueueResponseCodeAndRun(200);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.NO_RETRY, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
    }

    @Test
    public void testRunGetHttp302NoRetryResponseRedirectsDisabled() {
        this.runner.setProperty(InvokeHTTP.RESPONSE_REDIRECTS_ENABLED, StringUtils.capitalize((String)Boolean.FALSE.toString()));
        this.enqueueResponseCodeAndRun(302);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.RESPONSE, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.NO_RETRY, 302);
    }

    @Test
    public void testRunGetHttp302CookieStrategyAcceptAll() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.RESPONSE_COOKIE_STRATEGY, CookieStrategy.ACCEPT_ALL.name());
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(302).addHeader(SET_COOKIE_HEADER, (Object)COOKIE_1).addHeader(SET_COOKIE_HEADER, (Object)COOKIE_2).addHeader(LOCATION_HEADER, (Object)this.getMockWebServerUrl()));
        this.enqueueResponseCodeAndRun(200);
        RecordedRequest request1 = this.mockWebServer.takeRequest();
        Assertions.assertNull((Object)request1.getHeader(COOKIE_HEADER));
        RecordedRequest request2 = this.mockWebServer.takeRequest();
        String expectedHeader = String.format("%s; %s", COOKIE_1, COOKIE_2);
        Assertions.assertEquals((Object)expectedHeader, (Object)request2.getHeader(COOKIE_HEADER));
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.NO_RETRY, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
    }

    @Test
    public void testRunGetHttp302CookieStrategyDefaultDisabled() throws InterruptedException {
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(302).addHeader(SET_COOKIE_HEADER, (Object)COOKIE_1).addHeader(SET_COOKIE_HEADER, (Object)COOKIE_2).addHeader(LOCATION_HEADER, (Object)this.getMockWebServerUrl()));
        this.enqueueResponseCodeAndRun(200);
        RecordedRequest request1 = this.mockWebServer.takeRequest();
        Assertions.assertNull((Object)request1.getHeader(COOKIE_HEADER));
        RecordedRequest request2 = this.mockWebServer.takeRequest();
        Assertions.assertNull((Object)request2.getHeader(COOKIE_HEADER));
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.NO_RETRY, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
    }

    @Test
    public void testRunGetHttp400NoRetryMinimumProperties() {
        this.enqueueResponseCodeAndRun(400);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.RESPONSE, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.NO_RETRY, 400);
    }

    @Test
    public void testRunGetHttp400NoRetryPenalizeNoRetry() {
        this.runner.setProperty(InvokeHTTP.REQUEST_FAILURE_PENALIZATION_ENABLED, Boolean.TRUE.toString());
        this.enqueueResponseCodeAndRun(400);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.RESPONSE, 0);
        this.runner.assertPenalizeCount(1);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.NO_RETRY, 400);
    }

    @Test
    public void testRunGetHttp500RetryMinimumProperties() {
        this.enqueueResponseCodeAndRun(500);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.runner.assertTransferCount(InvokeHTTP.RESPONSE, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RETRY, 500);
    }

    @Test
    public void testRunGetHttp500RetryResponseGeneratedRequired() {
        this.runner.setProperty(InvokeHTTP.RESPONSE_GENERATION_REQUIRED, Boolean.TRUE.toString());
        this.enqueueResponseCodeAndRun(500);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RETRY, 500);
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 500);
    }

    @Test
    public void testRunDeleteHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.DELETE.name());
        this.assertRequestMethodSuccess(HttpMethod.DELETE);
    }

    @Test
    public void testRunHeadHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.HEAD.name());
        this.assertRequestMethodSuccess(HttpMethod.HEAD);
    }

    @Test
    public void testRunOptionsHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.OPTIONS.name());
        this.assertRequestMethodSuccess(HttpMethod.OPTIONS);
    }

    @Test
    public void testRunPatchHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.PATCH.name());
        this.assertRequestMethodSuccess(HttpMethod.PATCH);
    }

    @Test
    public void testRunPostHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.POST.name());
        this.assertRequestMethodSuccess(HttpMethod.POST);
    }

    @Test
    public void testRunPostHttp200SuccessContentEncodingGzip() throws InterruptedException, IOException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.POST.name());
        this.runner.setProperty(InvokeHTTP.REQUEST_CONTENT_ENCODING, ContentEncodingStrategy.GZIP.getValue());
        this.runner.setProperty(InvokeHTTP.REQUEST_BODY_ENABLED, Boolean.TRUE.toString());
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String contentLength = request.getHeader(CONTENT_LENGTH_HEADER);
        Assertions.assertNull((Object)contentLength, (String)"Content-Length Request Header found");
        String contentEncoding = request.getHeader(CONTENT_ENCODING_HEADER);
        Assertions.assertEquals((Object)ContentEncodingStrategy.GZIP.getValue().toLowerCase(), (Object)contentEncoding);
        Buffer body = request.getBody();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(body.inputStream());){
            String decompressed = IOUtils.toString((InputStream)gzipInputStream, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)FLOW_FILE_CONTENT, (Object)decompressed);
        }
    }

    @Test
    public void testRunPostHttp200SuccessChunkedEncoding() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.POST.name());
        this.runner.setProperty(InvokeHTTP.REQUEST_CHUNKED_TRANSFER_ENCODING_ENABLED, Boolean.TRUE.toString());
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String contentLength = request.getHeader(CONTENT_LENGTH_HEADER);
        Assertions.assertNull((Object)contentLength, (String)"Content-Length Request Header found");
        String transferEncoding = request.getHeader(TRANSFER_ENCODING_HEADER);
        Assertions.assertEquals((Object)"chunked", (Object)transferEncoding);
    }

    @Test
    public void testRunPostHttp200SuccessFormData() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.POST.name());
        String formName = "multipart-form";
        this.runner.setProperty(InvokeHTTP.REQUEST_FORM_DATA_NAME, "multipart-form");
        String formDataParameter = String.class.getName();
        String formDataParameterName = "label";
        String formDataPropertyName = String.format("%s:%s", "post:form", "label");
        this.runner.setProperty(formDataPropertyName, formDataParameter);
        this.setUrlProperty();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        String contentType = request.getHeader(CONTENT_TYPE_HEADER);
        Assertions.assertNotNull((Object)contentType, (String)"Content Type not found");
        Pattern multipartPattern = Pattern.compile("^multipart/form-data.+$");
        Assertions.assertTrue((boolean)multipartPattern.matcher(contentType).matches(), (String)"Content Type not matched");
        String body = request.getBody().readUtf8();
        Assertions.assertTrue((boolean)body.contains(formDataParameter), (String)"Form Data Parameter not found");
    }

    @Test
    public void testRunPutHttp200Success() throws InterruptedException {
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, HttpMethod.PUT.name());
        this.assertRequestMethodSuccess(HttpMethod.PUT);
    }

    @ParameterizedTest(name="{index} => When {0} http://baseUrl/{1}, filename of the response FlowFile should be {2}")
    @MethodSource
    public void testResponseFlowFileFilenameExtractedFromRemoteUrl(String httpMethod, String relativePath, String expectedFileName) {
        String targetUrl = String.format("http://%s:%d/%s", this.mockWebServer.getHostName(), this.mockWebServer.getPort(), relativePath);
        this.runner.setProperty(InvokeHTTP.HTTP_METHOD, httpMethod);
        this.runner.setProperty(InvokeHTTP.HTTP_URL, targetUrl);
        this.runner.setProperty(InvokeHTTP.RESPONSE_FLOW_FILE_NAMING_STRATEGY, FlowFileNamingStrategy.URL_PATH.name());
        HashMap<String, String> ffAttributes = new HashMap<String, String>();
        ffAttributes.put(CoreAttributes.FILENAME.key(), FLOW_FILE_INITIAL_FILENAME);
        this.runner.enqueue(FLOW_FILE_CONTENT, ffAttributes);
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200));
        this.runner.run();
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.RESPONSE).iterator().next();
        flowFile.assertAttributeEquals(CoreAttributes.FILENAME.key(), expectedFileName);
    }

    private static Stream<Arguments> testResponseFlowFileFilenameExtractedFromRemoteUrl() {
        return Stream.of(Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "file", "file"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "file/", "file"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "file.txt", "file.txt"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "file.txt/", "file.txt"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "f%69%6Cle.txt", "f%2569%256Cle.txt"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "path/to/file.txt", "file.txt"}), Arguments.of((Object[])new Object[]{HttpMethod.GET.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.POST.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.POST.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.PUT.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.PUT.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.PATCH.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.PATCH.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.DELETE.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.DELETE.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.HEAD.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.HEAD.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.OPTIONS.name(), "", FLOW_FILE_INITIAL_FILENAME}), Arguments.of((Object[])new Object[]{HttpMethod.OPTIONS.name(), "has/path", FLOW_FILE_INITIAL_FILENAME}));
    }

    @Test
    public void testValidWhenOAuth2Set() throws Exception {
        String oauth2AccessTokenProviderId = "oauth2AccessTokenProviderId";
        OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)Mockito.mock(OAuth2AccessTokenProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)oauth2AccessTokenProvider.getIdentifier()).thenReturn((Object)oauth2AccessTokenProviderId);
        this.runner.addControllerService(oauth2AccessTokenProviderId, (ControllerService)oauth2AccessTokenProvider);
        this.runner.enableControllerService((ControllerService)oauth2AccessTokenProvider);
        this.setUrlProperty();
        this.runner.setProperty(InvokeHTTP.REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER, oauth2AccessTokenProviderId);
        this.runner.assertValid();
    }

    @Test
    public void testInvalidWhenOAuth2AndUserNameSet() throws Exception {
        String oauth2AccessTokenProviderId = "oauth2AccessTokenProviderId";
        OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)Mockito.mock(OAuth2AccessTokenProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)oauth2AccessTokenProvider.getIdentifier()).thenReturn((Object)oauth2AccessTokenProviderId);
        this.runner.addControllerService(oauth2AccessTokenProviderId, (ControllerService)oauth2AccessTokenProvider);
        this.runner.enableControllerService((ControllerService)oauth2AccessTokenProvider);
        this.setUrlProperty();
        this.runner.setProperty(InvokeHTTP.REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER, oauth2AccessTokenProviderId);
        this.runner.setProperty(InvokeHTTP.REQUEST_USERNAME, "userName");
        this.runner.assertNotValid();
    }

    @Test
    public void testInvalidWhenOAuth2AndPasswordSet() throws Exception {
        String oauth2AccessTokenProviderId = "oauth2AccessTokenProviderId";
        OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)Mockito.mock(OAuth2AccessTokenProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)oauth2AccessTokenProvider.getIdentifier()).thenReturn((Object)oauth2AccessTokenProviderId);
        this.runner.addControllerService(oauth2AccessTokenProviderId, (ControllerService)oauth2AccessTokenProvider);
        this.runner.enableControllerService((ControllerService)oauth2AccessTokenProvider);
        this.setUrlProperty();
        this.runner.setProperty(InvokeHTTP.REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER, oauth2AccessTokenProviderId);
        this.runner.setProperty(InvokeHTTP.REQUEST_PASSWORD, "password");
        this.runner.assertNotValid();
    }

    @Test
    public void testOAuth2AuthorizationHeader() throws Exception {
        String accessToken = "access_token";
        String oauth2AccessTokenProviderId = "oauth2AccessTokenProviderId";
        OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)Mockito.mock(OAuth2AccessTokenProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)oauth2AccessTokenProvider.getIdentifier()).thenReturn((Object)oauth2AccessTokenProviderId);
        Mockito.when((Object)oauth2AccessTokenProvider.getAccessDetails().getAccessToken()).thenReturn((Object)accessToken);
        this.runner.addControllerService(oauth2AccessTokenProviderId, (ControllerService)oauth2AccessTokenProvider);
        this.runner.enableControllerService((ControllerService)oauth2AccessTokenProvider);
        this.setUrlProperty();
        this.mockWebServer.enqueue(new MockResponse());
        this.runner.setProperty(InvokeHTTP.REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER, oauth2AccessTokenProviderId);
        this.runner.enqueue("unimportant");
        this.runner.run();
        RecordedRequest recordedRequest = this.mockWebServer.takeRequest();
        String actualAuthorizationHeader = recordedRequest.getHeader(HttpHeader.AUTHORIZATION.getHeader());
        Assertions.assertEquals((Object)("Bearer " + accessToken), (Object)actualAuthorizationHeader);
    }

    private void setUrlProperty() {
        this.runner.setProperty(InvokeHTTP.HTTP_URL, this.getMockWebServerUrl());
    }

    private String getMockWebServerUrl() {
        return this.mockWebServer.url(BASE_PATH).newBuilder().host(LOCALHOST).build().toString();
    }

    private void enqueueResponseCodeAndRun(int responseCode) {
        this.setUrlProperty();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(responseCode));
        this.runner.enqueue(FLOW_FILE_CONTENT);
        this.runner.run();
    }

    private RecordedRequest takeRequestCompleted() throws InterruptedException {
        RecordedRequest request = this.mockWebServer.takeRequest(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)request, (String)"Request not found");
        return request;
    }

    private MockFlowFile getFailureFlowFile() {
        return (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.FAILURE).iterator().next();
    }

    private MockFlowFile getRequestFlowFile() {
        return (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.ORIGINAL).iterator().next();
    }

    private MockFlowFile getResponseFlowFile() {
        return (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.RESPONSE).iterator().next();
    }

    private void assertRequestMethodSuccess(HttpMethod httpMethod) throws InterruptedException {
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        RecordedRequest request = this.takeRequestCompleted();
        Assertions.assertEquals((Object)httpMethod.name(), (Object)request.getMethod());
    }

    private void assertRelationshipStatusCodeEquals(Relationship relationship, int statusCode) {
        List responseFlowFiles = this.runner.getFlowFilesForRelationship(relationship);
        String message = String.format("FlowFiles not found for Relationship [%s]", relationship);
        Assertions.assertFalse((boolean)responseFlowFiles.isEmpty(), (String)message);
        MockFlowFile responseFlowFile = (MockFlowFile)responseFlowFiles.iterator().next();
        this.assertStatusCodeEquals(responseFlowFile, statusCode);
    }

    private void assertStatusCodeEquals(MockFlowFile flowFile, int statusCode) {
        flowFile.assertAttributeEquals("invokehttp.status.code", Integer.toString(statusCode));
        flowFile.assertAttributeExists("invokehttp.status.message");
        flowFile.assertAttributeExists("invokehttp.tx.id");
        flowFile.assertAttributeExists("invokehttp.request.url");
        flowFile.assertAttributeExists("invokehttp.request.duration");
        flowFile.assertAttributeExists("invokehttp.response.url");
    }

    private void assertResponseSuccessRelationships() {
        List errorMessages = this.runner.getLogger().getErrorMessages();
        Optional errorMessage = errorMessages.stream().findFirst();
        if (errorMessage.isPresent()) {
            String message = String.format("Error Message Logged: %s", ((LogMessage)errorMessage.get()).getMsg());
            Assertions.assertFalse((boolean)errorMessages.isEmpty(), (String)message);
        }
        this.runner.assertTransferCount(InvokeHTTP.RESPONSE, 1);
        this.runner.assertTransferCount(InvokeHTTP.ORIGINAL, 1);
        this.runner.assertTransferCount(InvokeHTTP.RETRY, 0);
        this.runner.assertTransferCount(InvokeHTTP.NO_RETRY, 0);
        this.runner.assertTransferCount(InvokeHTTP.FAILURE, 0);
    }

    private void assertResponseSuccessSslContextConfigured(TlsConfiguration serverTlsConfiguration, TlsConfiguration clientTlsConfiguration) throws InitializationException, TlsException {
        this.setSslContextConfiguration(serverTlsConfiguration, clientTlsConfiguration);
        this.enqueueResponseCodeAndRun(200);
        this.assertResponseSuccessRelationships();
        this.assertRelationshipStatusCodeEquals(InvokeHTTP.RESPONSE, 200);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(InvokeHTTP.RESPONSE).iterator().next();
        flowFile.assertAttributeExists("invokehttp.remote.dn");
    }

    private void setSslContextConfiguration(TlsConfiguration serverTlsConfiguration, TlsConfiguration clientTlsConfiguration) throws InitializationException, TlsException {
        SSLContextService sslContextService = this.setSslContextService();
        SSLContext serverSslContext = SslContextUtils.createSslContext(serverTlsConfiguration);
        this.setMockWebServerSslSocketFactory(serverSslContext);
        SSLContext clientSslContext = SslContextUtils.createSslContext(clientTlsConfiguration);
        Mockito.when((Object)sslContextService.createContext()).thenReturn((Object)clientSslContext);
        Mockito.when((Object)sslContextService.createTlsConfiguration()).thenReturn((Object)clientTlsConfiguration);
    }

    private SSLContextService setSslContextService() throws InitializationException {
        String serviceIdentifier = SSLContextService.class.getName();
        SSLContextService sslContextService = (SSLContextService)Mockito.mock(SSLContextService.class);
        Mockito.when((Object)sslContextService.getIdentifier()).thenReturn((Object)serviceIdentifier);
        this.runner.addControllerService(serviceIdentifier, (ControllerService)sslContextService);
        this.runner.enableControllerService((ControllerService)sslContextService);
        this.runner.setProperty(InvokeHTTP.SSL_CONTEXT_SERVICE, serviceIdentifier);
        this.runner.setProperty(InvokeHTTP.SOCKET_READ_TIMEOUT, TLS_CONNECTION_TIMEOUT);
        this.runner.setProperty(InvokeHTTP.SOCKET_CONNECT_TIMEOUT, TLS_CONNECTION_TIMEOUT);
        return sslContextService;
    }

    private void setMockWebServerSslSocketFactory(SSLContext sslContext) {
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        if (sslSocketFactory == null) {
            throw new IllegalArgumentException("Socket Factory not found");
        }
        this.mockWebServer.useHttps(sslSocketFactory, false);
    }
}

