/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.nifi.processors.standard.relp.frame.RELPDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRELPDecoder {
    public static final String OPEN_FRAME_DATA = "relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog";
    public static final String OPEN_FRAME = "1 open 85 relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog\n";
    public static final String SYSLOG_FRAME_DATA = "this is a syslog message here";
    public static final String SYSLOG_FRAME = "2 syslog 29 this is a syslog message here\n";
    public static final String CLOSE_FRAME = "3 close 0\n";
    private RELPDecoder decoder;

    @BeforeEach
    public void setup() {
        this.decoder = new RELPDecoder(StandardCharsets.UTF_8);
    }

    @Test
    public void testDecodeSingleFrame() throws RELPFrameException {
        byte[] input = OPEN_FRAME.getBytes(StandardCharsets.UTF_8);
        RELPFrame frame = null;
        for (byte b : input) {
            if (!this.decoder.process(b)) continue;
            frame = this.decoder.getFrame();
            break;
        }
        Assertions.assertNotNull(frame);
        Assertions.assertEquals((long)1L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"open", (Object)frame.getCommand());
        Assertions.assertEquals((int)85, (int)frame.getDataLength());
        Assertions.assertNotNull((Object)frame.getData());
        Assertions.assertEquals((Object)OPEN_FRAME_DATA, (Object)new String(frame.getData(), StandardCharsets.UTF_8));
    }

    @Test
    public void testDecodeMultipleCommands() throws RELPFrameException {
        byte[] input = "1 open 85 relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog\n2 syslog 29 this is a syslog message here\n3 close 0\n".getBytes(StandardCharsets.UTF_8);
        ArrayList<RELPFrame> frames = new ArrayList<RELPFrame>();
        for (byte b : input) {
            if (!this.decoder.process(b)) continue;
            frames.add(this.decoder.getFrame());
        }
        Assertions.assertEquals((int)3, (int)frames.size());
        RELPFrame frame1 = (RELPFrame)frames.get(0);
        Assertions.assertNotNull((Object)frame1);
        Assertions.assertEquals((long)1L, (long)frame1.getTxnr());
        Assertions.assertEquals((Object)"open", (Object)frame1.getCommand());
        Assertions.assertEquals((int)85, (int)frame1.getDataLength());
        Assertions.assertNotNull((Object)frame1.getData());
        Assertions.assertEquals((Object)OPEN_FRAME_DATA, (Object)new String(frame1.getData(), StandardCharsets.UTF_8));
        RELPFrame frame2 = (RELPFrame)frames.get(1);
        Assertions.assertNotNull((Object)frame2);
        Assertions.assertEquals((long)2L, (long)frame2.getTxnr());
        Assertions.assertEquals((Object)"syslog", (Object)frame2.getCommand());
        Assertions.assertEquals((int)29, (int)frame2.getDataLength());
        Assertions.assertNotNull((Object)frame2.getData());
        Assertions.assertEquals((Object)SYSLOG_FRAME_DATA, (Object)new String(frame2.getData(), StandardCharsets.UTF_8));
        RELPFrame frame3 = (RELPFrame)frames.get(2);
        Assertions.assertNotNull((Object)frame3);
        Assertions.assertEquals((long)3L, (long)frame3.getTxnr());
        Assertions.assertEquals((Object)"close", (Object)frame3.getCommand());
        Assertions.assertEquals((int)0, (int)frame3.getDataLength());
    }

    @Test
    public void testDecodeMultipleSyslogCommands() throws RELPFrameException {
        String msg1 = "1 syslog 20 this is message 1234\n";
        String msg2 = "2 syslog 22 this is message 456789\n";
        String msg3 = "3 syslog 21 this is message ABCDE\n";
        String msg = "1 syslog 20 this is message 1234\n2 syslog 22 this is message 456789\n3 syslog 21 this is message ABCDE\n";
        byte[] input = "1 syslog 20 this is message 1234\n2 syslog 22 this is message 456789\n3 syslog 21 this is message ABCDE\n".getBytes(StandardCharsets.UTF_8);
        ArrayList<RELPFrame> frames = new ArrayList<RELPFrame>();
        for (byte b : input) {
            if (!this.decoder.process(b)) continue;
            frames.add(this.decoder.getFrame());
        }
        Assertions.assertEquals((int)3, (int)frames.size());
    }

    @Test
    public void testBadDataShouldThrowException() {
        Assertions.assertThrows(RELPFrameException.class, () -> {
            String msg = "NAN syslog 20 this is message 1234\n";
            byte[] input = "NAN syslog 20 this is message 1234\n".getBytes(StandardCharsets.UTF_8);
            ArrayList<RELPFrame> frames = new ArrayList<RELPFrame>();
            for (byte b : input) {
                if (!this.decoder.process(b)) continue;
                frames.add(this.decoder.getFrame());
            }
        });
    }
}

