/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.JsonUtils;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.jolt.TransformFactory;
import org.apache.nifi.processors.standard.util.jolt.TransformUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"json", "jolt", "transform", "shiftr", "chainr", "defaultr", "removr", "cardinality", "sort"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttribute(attribute="mime.type", description="Always set to application/json")
@CapabilityDescription(value="Applies a list of Jolt specifications to the flowfile JSON payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the JSON transform fails, the original FlowFile is routed to the 'failure' relationship.")
@RequiresInstanceClassLoading
public class JoltTransformJSON
extends AbstractProcessor {
    public static final AllowableValue SHIFTR = new AllowableValue("jolt-transform-shift", "Shift", "Shift input JSON/data to create the output JSON.");
    public static final AllowableValue CHAINR = new AllowableValue("jolt-transform-chain", "Chain", "Execute list of Jolt transformations.");
    public static final AllowableValue DEFAULTR = new AllowableValue("jolt-transform-default", "Default", " Apply default values to the output JSON.");
    public static final AllowableValue REMOVR = new AllowableValue("jolt-transform-remove", "Remove", " Remove values from input data to create the output JSON.");
    public static final AllowableValue CARDINALITY = new AllowableValue("jolt-transform-card", "Cardinality", "Change the cardinality of input elements to create the output JSON.");
    public static final AllowableValue SORTR = new AllowableValue("jolt-transform-sort", "Sort", "Sort input json key values alphabetically. Any specification set is ignored.");
    public static final AllowableValue CUSTOMR = new AllowableValue("jolt-transform-custom", "Custom", "Custom Transformation. Requires Custom Transformation Class Name");
    public static final AllowableValue MODIFIER_DEFAULTR = new AllowableValue("jolt-transform-modify-default", "Modify - Default", "Writes when key is missing or value is null");
    public static final AllowableValue MODIFIER_OVERWRITER = new AllowableValue("jolt-transform-modify-overwrite", "Modify - Overwrite", " Always overwrite value");
    public static final AllowableValue MODIFIER_DEFINER = new AllowableValue("jolt-transform-modify-define", "Modify - Define", "Writes when key is missing");
    public static final PropertyDescriptor JOLT_TRANSFORM = new PropertyDescriptor.Builder().name("jolt-transform").displayName("Jolt Transformation DSL").description("Specifies the Jolt Transformation that should be used with the provided specification.").required(true).allowableValues(new AllowableValue[]{CARDINALITY, CHAINR, DEFAULTR, MODIFIER_DEFAULTR, MODIFIER_DEFINER, MODIFIER_OVERWRITER, REMOVR, SHIFTR, SORTR, CUSTOMR}).defaultValue(CHAINR.getValue()).build();
    public static final PropertyDescriptor JOLT_SPEC = new PropertyDescriptor.Builder().name("jolt-spec").displayName("Jolt Specification").description("Jolt Specification for transformation of JSON data. The value for this property may be the text of a Jolt specification or the path to a file containing a Jolt specification. 'Jolt Specification' must be set, or the value is ignored if the Jolt Sort Transformation is selected.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.TEXT}).required(false).build();
    public static final PropertyDescriptor CUSTOM_CLASS = new PropertyDescriptor.Builder().name("jolt-custom-class").displayName("Custom Transformation Class Name").description("Fully Qualified Class Name for Custom Transformation").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(JOLT_TRANSFORM, new AllowableValue[]{CUSTOMR}).build();
    public static final PropertyDescriptor MODULES = new PropertyDescriptor.Builder().name("jolt-custom-modules").displayName("Custom Module Directory").description("Comma-separated list of paths to files and/or directories which contain modules containing custom transformations (that are not included on NiFi's classpath).").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).dependsOn(JOLT_TRANSFORM, new AllowableValue[]{CUSTOMR}).build();
    static final PropertyDescriptor TRANSFORM_CACHE_SIZE = new PropertyDescriptor.Builder().name("Transform Cache Size").description("Compiling a Jolt Transform can be fairly expensive. Ideally, this will be done only once. However, if the Expression Language is used in the transform, we may need a new Transform for each FlowFile. This value controls how many of those Transforms we cache in memory in order to avoid having to compile the Transform each time.").expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").required(true).build();
    public static final PropertyDescriptor PRETTY_PRINT = new PropertyDescriptor.Builder().name("pretty_print").displayName("Pretty Print").description("Apply pretty print formatting to the output of the Jolt transform").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor MAX_STRING_LENGTH = new PropertyDescriptor.Builder().name("Max String Length").displayName("Max String Length").description("The maximum allowed length of a string value when parsing the JSON document").required(true).defaultValue("20 MB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON), it will be routed to this relationship").build();
    private static final List<PropertyDescriptor> properties;
    private static final Set<Relationship> relationships;
    private volatile ClassLoader customClassLoader;
    private volatile JsonUtil jsonUtil;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private Cache<Optional<String>, JoltTransform> transformCache;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String transform = validationContext.getProperty(JOLT_TRANSFORM).getValue();
        String customTransform = validationContext.getProperty(CUSTOM_CLASS).getValue();
        String modulePath = validationContext.getProperty(MODULES).isSet() ? validationContext.getProperty(MODULES).getValue() : null;
        String joltSpecBody = validationContext.getProperty(JOLT_SPEC).getValue();
        if (StringUtils.isEmpty((String)joltSpecBody) && !SORTR.getValue().equals(transform)) {
            results.add(new ValidationResult.Builder().subject(JOLT_SPEC.getDisplayName()).valid(false).explanation("'Jolt Specification' must be set, or the Transformation must be 'Sort'").build());
        } else {
            try {
                ClassLoader customClassLoader = modulePath != null && !validationContext.isExpressionLanguagePresent(modulePath) ? ClassLoaderUtils.getCustomClassLoader((String)modulePath, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : ((Object)((Object)this)).getClass().getClassLoader();
                String specValue = validationContext.getProperty(JOLT_SPEC).getValue();
                boolean elPresent = validationContext.isExpressionLanguagePresent(specValue);
                if (elPresent) {
                    String invalidExpressionMsg = validationContext.newExpressionLanguageCompiler().validateExpression(specValue, true);
                    if (!StringUtils.isEmpty((String)invalidExpressionMsg)) {
                        results.add(new ValidationResult.Builder().valid(false).subject(JOLT_SPEC.getDisplayName()).explanation("Invalid Expression Language: " + invalidExpressionMsg).build());
                    }
                } else if (validationContext.isExpressionLanguagePresent(customTransform)) {
                    String invalidExpressionMsg = validationContext.newExpressionLanguageCompiler().validateExpression(customTransform, true);
                    if (!StringUtils.isEmpty((String)invalidExpressionMsg)) {
                        results.add(new ValidationResult.Builder().valid(false).subject(CUSTOM_CLASS.getDisplayName()).explanation("Invalid Expression Language: " + invalidExpressionMsg).build());
                    }
                } else if (!SORTR.getValue().equals(transform)) {
                    String content = this.readTransform(validationContext.getProperty(JOLT_SPEC));
                    Object specJson = JsonUtils.jsonToObject((String)content.replaceAll("\\$\\{", "\\\\\\\\\\$\\{"), (String)DEFAULT_CHARSET);
                    if (CUSTOMR.getValue().equals(transform)) {
                        if (StringUtils.isEmpty((String)customTransform)) {
                            String customMessage = "A custom transformation class should be provided. ";
                            results.add(new ValidationResult.Builder().valid(false).explanation("A custom transformation class should be provided. ").build());
                        } else {
                            TransformFactory.getCustomTransform((ClassLoader)customClassLoader, (String)customTransform, (Object)specJson);
                        }
                    } else {
                        TransformFactory.getTransform((ClassLoader)customClassLoader, (String)transform, (Object)specJson);
                    }
                }
            }
            catch (Exception e) {
                String message = String.format("Specification not valid for the selected transformation: %s", e);
                results.add(new ValidationResult.Builder().valid(false).subject(JOLT_SPEC.getDisplayName()).explanation(message).build());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String jsonString;
        Object inputJson;
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        StopWatch stopWatch = new StopWatch(true);
        try (InputStream in = session.read(original);){
            inputJson = this.jsonUtil.jsonToObject(in);
        }
        catch (Exception e) {
            logger.error("JSON parsing failed for {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JoltTransform transform = this.getTransform(context, original);
            if (this.customClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.customClassLoader);
            }
            Object transformedJson = TransformUtils.transform((JoltTransform)transform, (Object)inputJson);
            jsonString = context.getProperty(PRETTY_PRINT).asBoolean() != false ? this.jsonUtil.toPrettyJsonString(transformedJson) : this.jsonUtil.toJsonString(transformedJson);
        }
        catch (Exception e) {
            logger.error("Transform failed for {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        finally {
            if (this.customClassLoader != null && originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        FlowFile transformed = session.write(original, out -> out.write(jsonString.getBytes(DEFAULT_CHARSET)));
        String transformType = context.getProperty(JOLT_TRANSFORM).getValue();
        transformed = session.putAttribute(transformed, CoreAttributes.MIME_TYPE.key(), "application/json");
        session.transfer(transformed, REL_SUCCESS);
        session.getProvenanceReporter().modifyContent(transformed, "Modified With " + transformType, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        logger.info("Transform completed for {}", new Object[]{original});
    }

    private JoltTransform getTransform(ProcessContext context, FlowFile flowFile) {
        Optional<String> specString;
        if (context.getProperty(JOLT_SPEC).isSet()) {
            specString = Optional.of(context.getProperty(JOLT_SPEC).evaluateAttributeExpressions(flowFile).getValue());
        } else if (SORTR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            specString = Optional.empty();
        } else {
            throw new IllegalArgumentException("'Jolt Specification' must be set, or the Transformation must be Sort.");
        }
        return (JoltTransform)this.transformCache.get(specString, currString -> {
            try {
                return this.createTransform(context, flowFile);
            }
            catch (Exception e) {
                this.getLogger().error("Transform creation failed", (Throwable)e);
                return null;
            }
        });
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        int maxTransformsToCache = context.getProperty(TRANSFORM_CACHE_SIZE).asInteger();
        this.transformCache = Caffeine.newBuilder().maximumSize((long)maxTransformsToCache).build();
        int maxStringLength = context.getProperty(MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(maxStringLength).build();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getFactory().setStreamReadConstraints(streamReadConstraints);
        this.jsonUtil = JsonUtils.customJsonUtil((ObjectMapper)objectMapper);
        try {
            this.customClassLoader = context.getProperty(MODULES).isSet() ? ClassLoaderUtils.getCustomClassLoader((String)context.getProperty(MODULES).evaluateAttributeExpressions().getValue(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : ((Object)((Object)this)).getClass().getClassLoader();
        }
        catch (Exception e) {
            this.getLogger().error("ClassLoader configuration failed", (Throwable)e);
        }
    }

    private JoltTransform createTransform(ProcessContext context, FlowFile flowFile) throws Exception {
        Object specJson;
        if (context.getProperty(JOLT_SPEC).isSet() && !SORTR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            String resolvedSpec = this.readTransform(context.getProperty(JOLT_SPEC), flowFile);
            specJson = JsonUtils.jsonToObject((String)resolvedSpec, (String)DEFAULT_CHARSET);
        } else {
            specJson = null;
        }
        if (CUSTOMR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            return TransformFactory.getCustomTransform((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)context.getProperty(CUSTOM_CLASS).evaluateAttributeExpressions(flowFile).getValue(), (Object)specJson);
        }
        return TransformFactory.getTransform((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)context.getProperty(JOLT_TRANSFORM).getValue(), specJson);
    }

    private String readTransform(PropertyValue propertyValue, FlowFile flowFile) {
        String transform = propertyValue.isExpressionLanguagePresent() ? propertyValue.evaluateAttributeExpressions(flowFile).getValue() : this.readTransform(propertyValue);
        return transform;
    }

    private String readTransform(PropertyValue propertyValue) {
        String string;
        ResourceReference resourceReference = propertyValue.asResource();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceReference.read()));
        try {
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read JOLT Transform failed", e);
            }
        }
        reader.close();
        return string;
    }

    protected FilenameFilter getJarFilenameFilter() {
        return (dir, name) -> name != null && name.endsWith(".jar");
    }

    static {
        ArrayList<PropertyDescriptor> _properties = new ArrayList<PropertyDescriptor>();
        _properties.add(JOLT_TRANSFORM);
        _properties.add(CUSTOM_CLASS);
        _properties.add(MODULES);
        _properties.add(JOLT_SPEC);
        _properties.add(TRANSFORM_CACHE_SIZE);
        _properties.add(PRETTY_PRINT);
        _properties.add(MAX_STRING_LENGTH);
        properties = Collections.unmodifiableList(_properties);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

