/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.OpenPGPKeyBasedEncryptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenPGPKeyBasedEncryptorTest {
    private static final String FILENAME = OpenPGPKeyBasedEncryptorTest.class.getSimpleName();
    private static final String SECRET_KEYRING_PATH = "src/test/resources/TestEncryptContent/secring.gpg";
    private static final String PUBLIC_KEYRING_PATH = "src/test/resources/TestEncryptContent/pubring.gpg";
    private static final String USER_ID = "NiFi PGP Test Key (Short test key for NiFi PGP unit tests) <alopresto.apache+test@gmail.com>";
    private static final String PASSWORD = "thisIsABadPassword";
    private static final int CIPHER = 7;
    private static final byte[] PLAINTEXT = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    @Test
    public void testEncryptDecrypt() throws Exception {
        ByteArrayInputStream plainStream = new ByteArrayInputStream(PLAINTEXT);
        OpenPGPKeyBasedEncryptor encryptor = new OpenPGPKeyBasedEncryptor(EncryptionMethod.PGP.getAlgorithm(), Integer.valueOf(7), EncryptionMethod.PGP.getProvider(), PUBLIC_KEYRING_PATH, USER_ID, new char[0], FILENAME);
        StreamCallback encryptionCallback = encryptor.getEncryptionCallback();
        OpenPGPKeyBasedEncryptor decryptor = new OpenPGPKeyBasedEncryptor(EncryptionMethod.PGP.getAlgorithm(), Integer.valueOf(7), EncryptionMethod.PGP.getProvider(), SECRET_KEYRING_PATH, USER_ID, PASSWORD.toCharArray(), FILENAME);
        StreamCallback decryptionCallback = decryptor.getDecryptionCallback();
        ByteArrayOutputStream encryptedStream = new ByteArrayOutputStream();
        encryptionCallback.process((InputStream)plainStream, (OutputStream)encryptedStream);
        ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedStream.toByteArray());
        ByteArrayOutputStream decryptedStream = new ByteArrayOutputStream();
        decryptionCallback.process((InputStream)encryptedInputStream, (OutputStream)decryptedStream);
        byte[] decryptedBytes = decryptedStream.toByteArray();
        Assertions.assertArrayEquals((byte[])PLAINTEXT, (byte[])decryptedBytes);
    }
}

