/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;
import org.apache.nifi.processors.standard.util.FlowFileAttributesSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlowFileAttributesSerializer {
    private FlowFileAttributesSerializer serializer = new FlowFileAttributesSerializer();

    @Test
    public void testBothWays() throws SerializationException, IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "1");
        attributes.put("b", "2");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.serializer.serialize(attributes, (OutputStream)output);
        output.flush();
        Map result = this.serializer.deserialize(output.toByteArray());
        Assertions.assertEquals(attributes, (Object)result);
    }

    @Test
    public void testEmptyIsNull() throws SerializationException, IOException {
        HashMap attributes = new HashMap();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.serializer.serialize(attributes, (OutputStream)output);
        output.flush();
        Map result = this.serializer.deserialize(output.toByteArray());
        Assertions.assertNull((Object)result);
    }

    @Test
    public void testEmptyIsNull2() throws SerializationException, IOException {
        Map result = this.serializer.deserialize("".getBytes());
        Assertions.assertNull((Object)result);
    }

    @Test
    public void testNullIsNull() throws SerializationException, IOException {
        Map result = this.serializer.deserialize(null);
        Assertions.assertNull((Object)result);
    }
}

