/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.nifi.processors.standard.relp.frame.RELPDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRELPEncoder {
    @Test
    public void testEncodingWithData() {
        RELPFrame frame = new RELPFrame.Builder().txnr(1L).command("rsp").dataLength(5).data("12345".getBytes(StandardCharsets.UTF_8)).build();
        RELPEncoder encoder = new RELPEncoder(StandardCharsets.UTF_8);
        byte[] result = encoder.encode(frame);
        String expected = "1 rsp 5 12345\n";
        Assertions.assertEquals((Object)"1 rsp 5 12345\n", (Object)new String(result, StandardCharsets.UTF_8));
    }

    @Test
    public void testEncodingNoData() {
        RELPFrame frame = new RELPFrame.Builder().txnr(1L).command("rsp").dataLength(0).data(new byte[0]).build();
        RELPEncoder encoder = new RELPEncoder(StandardCharsets.UTF_8);
        byte[] result = encoder.encode(frame);
        String expected = "1 rsp 0\n";
        Assertions.assertEquals((Object)"1 rsp 0\n", (Object)new String(result, StandardCharsets.UTF_8));
    }

    @Test
    public void testEncodingOpenResponse() {
        String openFrameData = "relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog";
        String openFrame = "1 open 85 relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog\n";
        System.out.println("1 open 85 relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog\n");
        RELPDecoder decoder = new RELPDecoder(StandardCharsets.UTF_8);
        RELPEncoder encoder = new RELPEncoder(StandardCharsets.UTF_8);
        RELPFrame frame = null;
        for (byte b : "1 open 85 relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog\n".getBytes(StandardCharsets.UTF_8)) {
            if (!decoder.process(b)) continue;
            frame = decoder.getFrame();
            break;
        }
        Assertions.assertNotNull(frame);
        Map offers = RELPResponse.parseOffers((byte[])frame.getData(), (Charset)StandardCharsets.UTF_8);
        RELPFrame responseFrame = RELPResponse.open((long)frame.getTxnr(), (Map)offers).toFrame(StandardCharsets.UTF_8);
        byte[] response = encoder.encode(responseFrame);
        System.out.println(new String(response, StandardCharsets.UTF_8));
    }
}

