/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.io.File;
import java.util.Collections;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.nifi.processors.standard.ftp.filesystem.DefaultVirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystemFactory;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVirtualFileSystemView {
    private FileSystemView fileSystemView;
    private static VirtualFileSystem fileSystem;

    @BeforeAll
    public static void setupVirtualFileSystem() {
        fileSystem = new DefaultVirtualFileSystem();
        fileSystem.mkdir(new VirtualPath("/Directory1"));
        fileSystem.mkdir(new VirtualPath("/Directory1/SubDirectory1"));
        fileSystem.mkdir(new VirtualPath("/Directory1/SubDirectory1/SubSubDirectory"));
        fileSystem.mkdir(new VirtualPath("/Directory1/SubDirectory2"));
        fileSystem.mkdir(new VirtualPath("/Directory2"));
        fileSystem.mkdir(new VirtualPath("/Directory2/SubDirectory3"));
        fileSystem.mkdir(new VirtualPath("/Directory2/SubDirectory4"));
    }

    @BeforeEach
    public void setup() throws FtpException {
        User user = this.createUser();
        VirtualFileSystemFactory fileSystemFactory = new VirtualFileSystemFactory(fileSystem);
        this.fileSystemView = fileSystemFactory.createFileSystemView(user);
    }

    @Test
    public void testInRootDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testTryToMakeRootDirectory() {
        boolean directoryCreated = fileSystem.mkdir(VirtualFileSystem.ROOT);
        Assertions.assertFalse((boolean)directoryCreated);
    }

    @Test
    public void testChangeToAnotherDirectory() throws FtpException {
        String expectedHomeDirectory = File.separator;
        String expectedCurrentDirectory = "/Directory1".replace('/', File.separatorChar);
        this.fileSystemView.changeWorkingDirectory("/Directory1");
        this.assertHomeDirectoryEquals(expectedHomeDirectory);
        this.assertCurrentDirectoryEquals(expectedCurrentDirectory);
    }

    @Test
    public void testChangeToRootDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        this.fileSystemView.changeWorkingDirectory("/");
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testChangeToUnspecifiedDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        this.fileSystemView.changeWorkingDirectory("");
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testChangeToSameDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        this.fileSystemView.changeWorkingDirectory(".");
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testChangeToSameDirectoryNonRoot() throws FtpException {
        String expectedHomeDirectory = File.separator;
        String expectedCurrentDirectory = "/Directory1".replace('/', File.separatorChar);
        this.fileSystemView.changeWorkingDirectory("/Directory1");
        this.fileSystemView.changeWorkingDirectory(".");
        this.assertHomeDirectoryEquals(expectedHomeDirectory);
        this.assertCurrentDirectoryEquals(expectedCurrentDirectory);
    }

    @Test
    public void testChangeToParentDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        this.fileSystemView.changeWorkingDirectory("/Directory1");
        this.fileSystemView.changeWorkingDirectory("..");
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testChangeToParentDirectoryNonRoot() throws FtpException {
        String expectedHomeDirectory = File.separator;
        String expectedCurrentDirectory = "/Directory1".replace('/', File.separatorChar);
        this.fileSystemView.changeWorkingDirectory("/Directory1");
        this.fileSystemView.changeWorkingDirectory("SubDirectory1");
        this.fileSystemView.changeWorkingDirectory("..");
        this.assertHomeDirectoryEquals(expectedHomeDirectory);
        this.assertCurrentDirectoryEquals(expectedCurrentDirectory);
    }

    @Test
    public void testChangeToNonExistentDirectory() throws FtpException {
        String expectedDirectory = File.separator;
        boolean changeDirectoryResult = this.fileSystemView.changeWorkingDirectory("/Directory2/SubDirectory3/SubSubDirectory");
        Assertions.assertFalse((boolean)changeDirectoryResult);
        this.assertHomeDirectoryEquals(expectedDirectory);
        this.assertCurrentDirectoryEquals(expectedDirectory);
    }

    @Test
    public void testGetFileAbsolute() throws FtpException {
        String expectedDirectory = "/Directory2/SubDirectory3".replace('/', File.separatorChar);
        this.fileSystemView.changeWorkingDirectory("/Directory1/SubDirectory1");
        FtpFile file = this.fileSystemView.getFile("/Directory2/SubDirectory3");
        Assertions.assertEquals((Object)expectedDirectory, (Object)file.getAbsolutePath());
    }

    @Test
    public void testGetFileNonAbsolute() throws FtpException {
        String expectedDirectory = "/Directory1/SubDirectory1/SubSubDirectory".replace('/', File.separatorChar);
        this.fileSystemView.changeWorkingDirectory("/Directory1/SubDirectory1");
        FtpFile file = this.fileSystemView.getFile("SubSubDirectory");
        Assertions.assertEquals((Object)expectedDirectory, (Object)file.getAbsolutePath());
    }

    private User createUser() {
        BaseUser user = new BaseUser();
        user.setName("Username");
        user.setPassword("Password");
        user.setHomeDirectory("/abc/def");
        user.setAuthorities(Collections.singletonList(new WritePermission()));
        return user;
    }

    private void assertHomeDirectoryEquals(String expectedHomeDirectory) throws FtpException {
        FtpFile homeDirectory = this.fileSystemView.getHomeDirectory();
        Assertions.assertEquals((Object)expectedHomeDirectory, (Object)homeDirectory.getAbsolutePath());
    }

    private void assertCurrentDirectoryEquals(String expectedCurrentDirectory) throws FtpException {
        FtpFile currentDirectory = this.fileSystemView.getWorkingDirectory();
        Assertions.assertEquals((Object)expectedCurrentDirectory, (Object)currentDirectory.getAbsolutePath());
    }
}

