/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.processors.standard.enrichment.InsertRecordFieldsJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.TestIndexCorrelatedJoinStrategy;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInsertRecordFieldsJoinStrategy
extends TestIndexCorrelatedJoinStrategy {
    @Test
    public void testSimpleInsertAtRoot() {
        RecordSchema originalSchema = this.getOriginalSchema();
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        InsertRecordFieldsJoinStrategy strategy = new InsertRecordFieldsJoinStrategy((ComponentLog)new MockComponentLogger(), "/");
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)3, (int)resultFields.size());
        ArrayList<RecordField> combinedFields = new ArrayList<RecordField>();
        combinedFields.add((RecordField)originalSchema.getFields().get(0));
        combinedFields.addAll(enrichmentSchema.getFields());
        Assertions.assertEquals(new HashSet(combinedFields), new HashSet(resultFields));
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals((int)555, (Integer)combined.getAsInt("id"));
        Assertions.assertEquals((Object)"John Doe", (Object)combined.getValue("name"));
        Assertions.assertEquals((Object)100, (Object)combined.getValue("number"));
    }

    @Test
    public void testNullEnrichment() {
        RecordSchema originalSchema = this.getOriginalSchema();
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        InsertRecordFieldsJoinStrategy strategy = new InsertRecordFieldsJoinStrategy((ComponentLog)new MockComponentLogger(), "/");
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)3, (int)resultFields.size());
        ArrayList<RecordField> combinedFields = new ArrayList<RecordField>();
        combinedFields.add((RecordField)originalSchema.getFields().get(0));
        combinedFields.addAll(enrichmentSchema.getFields());
        Assertions.assertEquals(new HashSet(combinedFields), new HashSet(resultFields));
        Record combined = strategy.combineRecords(this.createOriginalRecord(555), null, resultSchema);
        Assertions.assertEquals((int)555, (Integer)combined.getAsInt("id"));
        Assertions.assertNull((Object)combined.getValue("name"));
        Assertions.assertNull((Object)combined.getValue("number"));
    }

    @Test
    public void testNullOriginalNullEnrichment() {
        RecordSchema originalSchema = this.getOriginalSchema();
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        InsertRecordFieldsJoinStrategy strategy = new InsertRecordFieldsJoinStrategy((ComponentLog)new MockComponentLogger(), "/");
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)3, (int)resultFields.size());
        ArrayList<RecordField> combinedFields = new ArrayList<RecordField>();
        combinedFields.add((RecordField)originalSchema.getFields().get(0));
        combinedFields.addAll(enrichmentSchema.getFields());
        Assertions.assertEquals(new HashSet(combinedFields), new HashSet(resultFields));
        Record combined = strategy.combineRecords(null, null, resultSchema);
        Assertions.assertNull((Object)combined);
    }

    @Test
    public void testRecordPathPointsToNonExistentField() {
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        InsertRecordFieldsJoinStrategy strategy = new InsertRecordFieldsJoinStrategy((ComponentLog)new MockComponentLogger(), "/abc");
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals((int)555, (Integer)combined.getAsInt("id"));
        Assertions.assertArrayEquals((Object[])new Integer[]{555}, (Object[])combined.getValues());
    }

    @Test
    public void testRecordPathPointingToChildRecord() {
        RecordSchema simpleOriginalSchema = this.getOriginalSchema();
        ArrayList<RecordField> complexSchemaFields = new ArrayList<RecordField>();
        complexSchemaFields.addAll(simpleOriginalSchema.getFields());
        SimpleRecordSchema emptySchema = new SimpleRecordSchema(Collections.emptyList());
        complexSchemaFields.add(new RecordField("xyz", RecordFieldType.RECORD.getRecordDataType((RecordSchema)emptySchema)));
        SimpleRecordSchema complexOriginalSchema = new SimpleRecordSchema(complexSchemaFields);
        HashMap<String, Integer> originalValues = new HashMap<String, Integer>();
        originalValues.put("id", 555);
        originalValues.put("xyz", (Integer)new MapRecord((RecordSchema)emptySchema, new HashMap()));
        MapRecord originalRecord = new MapRecord((RecordSchema)complexOriginalSchema, originalValues);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        InsertRecordFieldsJoinStrategy strategy = new InsertRecordFieldsJoinStrategy((ComponentLog)new MockComponentLogger(), "/xyz");
        RecordSchema resultSchema = strategy.createResultSchema((Record)originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)2, (int)resultFields.size());
        Assertions.assertTrue((boolean)resultFields.contains(simpleOriginalSchema.getFields().get(0)));
        DataType xyzDataType = (DataType)resultSchema.getDataType("xyz").get();
        RecordSchema xyzSchema = ((RecordDataType)xyzDataType).getChildSchema();
        Assertions.assertEquals((Object)RecordFieldType.INT, (Object)((DataType)xyzSchema.getDataType("id").get()).getFieldType());
        Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((DataType)xyzSchema.getDataType("name").get()).getFieldType());
        Assertions.assertEquals((Object)RecordFieldType.INT, (Object)((DataType)xyzSchema.getDataType("number").get()).getFieldType());
        Record combined = strategy.combineRecords((Record)originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals((int)555, (Integer)combined.getAsInt("id"));
        Object xyzValue = combined.getValue("xyz");
        Assertions.assertTrue((boolean)(xyzValue instanceof Record));
        Record xyzRecord = (Record)xyzValue;
        Assertions.assertEquals((Object)"John Doe", (Object)xyzRecord.getValue("name"));
        Assertions.assertEquals((Object)100, (Object)xyzRecord.getValue("number"));
        Assertions.assertEquals((Object)555, (Object)xyzRecord.getValue("id"));
    }
}

