/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.avro.AvroReader;
import org.apache.nifi.avro.AvroReaderWithEmbeddedSchema;
import org.apache.nifi.avro.AvroRecordSetWriter;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVReader;
import org.apache.nifi.csv.CSVRecordSetWriter;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.ValidateRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestValidateRecord {
    private TestRunner runner;

    @BeforeEach
    public void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(ValidateRecord.class);
    }

    @Test
    public void testColumnsOrder() throws InitializationException {
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        CSVRecordSetWriter csvWriter = new CSVRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)csvWriter);
        this.runner.setProperty((ControllerService)csvWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)csvWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        String content = "fieldA,fieldB,fieldC,fieldD,fieldE,fieldF\nvalueA,valueB,valueC,valueD,valueE,valueF\nvalueA,valueB,valueC,valueD,valueE,valueF\n";
        this.runner.enqueue("fieldA,fieldB,fieldC,fieldD,fieldE,fieldF\nvalueA,valueB,valueC,valueD,valueE,valueF\nvalueA,valueB,valueC,valueD,valueE,valueF\n");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ValidateRecord.REL_VALID, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0)).assertContentEquals("fieldA,fieldB,fieldC,fieldD,fieldE,fieldF\nvalueA,valueB,valueC,valueD,valueE,valueF\nvalueA,valueB,valueC,valueD,valueE,valueF\n");
    }

    @Test
    public void testWriteFailureRoutesToFaliure() throws InitializationException {
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        MockRecordWriter writer = new MockRecordWriter("header", false, 1);
        this.runner.addControllerService("writer", (ControllerService)writer);
        this.runner.enableControllerService((ControllerService)writer);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        String content = "fieldA,fieldB,fieldC,fieldD,fieldE,fieldF\nvalueA,valueB,valueC,valueD,valueE,valueF\nvalueA,valueB,valueC,valueD,valueE,valueF\n";
        this.runner.enqueue("fieldA,fieldB,fieldC,fieldD,fieldE,fieldF\nvalueA,valueB,valueC,valueD,valueE,valueF\nvalueA,valueB,valueC,valueD,valueE,valueF\n");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ValidateRecord.REL_FAILURE, 1);
    }

    @Test
    public void testAppropriateServiceUsedForInvalidRecords() throws InitializationException, UnsupportedEncodingException, IOException {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string.avsc", new String[0])), "UTF-8");
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_TEXT, schema);
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "false");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        MockRecordWriter validWriter = new MockRecordWriter("valid", false);
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        String content = "1, John Doe\n2, Jane Doe\nThree, Jack Doe\n";
        this.runner.enqueue("1, John Doe\n2, Jane Doe\nThree, Jack Doe\n");
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        validFlowFile.assertAttributeEquals("record.count", "2");
        validFlowFile.assertContentEquals("valid\n1,John Doe\n2,Jane Doe\n");
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertAttributeEquals("record.count", "1");
        invalidFlowFile.assertContentEquals("invalid\n\"Three\",\"Jack Doe\"\n");
    }

    @Test
    public void testStrictTypeCheck() throws InitializationException, IOException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string-fields.avsc", new String[0])), "UTF-8");
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "csv-header-derived");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.IGNORE_CSV_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "true");
        String content = "id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n";
        this.runner.enqueue("id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n");
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertAttributeEquals("record.count", "3");
        String expectedInvalidContents = "invalid\n\"1\",\"John\",\"Doe\"\n\"2\",\"Jane\",\"Doe\"\n\"Three\",\"Jack\",\"Doe\"\n";
        invalidFlowFile.assertContentEquals("invalid\n\"1\",\"John\",\"Doe\"\n\"2\",\"Jane\",\"Doe\"\n\"Three\",\"Jack\",\"Doe\"\n");
    }

    @Test
    public void testNonStrictTypeCheckWithAvroWriter() throws InitializationException, IOException, MalformedRecordException, SchemaNotFoundException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string-fields.avsc", new String[0])), "UTF-8");
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "csv-header-derived");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.IGNORE_CSV_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        AvroRecordSetWriter validWriter = new AvroRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "false");
        String content = "id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n";
        this.runner.enqueue("id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n");
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        AvroReader avroReader = new AvroReader();
        this.runner.addControllerService("avroReader", (ControllerService)avroReader);
        this.runner.setProperty((ControllerService)avroReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.enableControllerService((ControllerService)avroReader);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        byte[] validFlowFileBytes = validFlowFile.toByteArray();
        try (ByteArrayInputStream resultContentStream = new ByteArrayInputStream(validFlowFileBytes);
             RecordReader recordReader = avroReader.createRecordReader(validFlowFile.getAttributes(), (InputStream)resultContentStream, (long)validFlowFileBytes.length, (ComponentLog)this.runner.getLogger());){
            RecordSchema resultSchema = recordReader.getSchema();
            Assertions.assertEquals((int)3, (int)resultSchema.getFieldCount());
            Optional idField = resultSchema.getField("id");
            Assertions.assertTrue((boolean)idField.isPresent());
            Assertions.assertEquals((Object)RecordFieldType.INT, (Object)((RecordField)idField.get()).getDataType().getFieldType());
            validFlowFile.assertAttributeEquals("record.count", "2");
            Record record = recordReader.nextRecord();
            Assertions.assertEquals((Object)1, (Object)record.getValue("id"));
            Assertions.assertEquals((Object)"John", (Object)record.getValue("firstName"));
            Assertions.assertEquals((Object)"Doe", (Object)record.getValue("lastName"));
            record = recordReader.nextRecord();
            Assertions.assertEquals((Object)2, (Object)record.getValue("id"));
            Assertions.assertEquals((Object)"Jane", (Object)record.getValue("firstName"));
            Assertions.assertEquals((Object)"Doe", (Object)record.getValue("lastName"));
        }
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertAttributeEquals("record.count", "1");
        String expectedInvalidContents = "invalid\n\"Three\",\"Jack\",\"Doe\"\n";
        invalidFlowFile.assertContentEquals("invalid\n\"Three\",\"Jack\",\"Doe\"\n");
    }

    @Test
    public void testNonStrictTypeCheckWithJsonWriter() throws InitializationException, IOException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string-fields.avsc", new String[0])), "UTF-8");
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "csv-header-derived");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.IGNORE_CSV_HEADER, "true");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "false");
        String content = "id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n";
        this.runner.enqueue("id, firstName, lastName\n1, John, Doe\n2, Jane, Doe\nThree, Jack, Doe\n");
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        validFlowFile.assertAttributeEquals("record.count", "2");
        String expectedValidContents = "[{\"id\":\"1\",\"firstName\":\"John\",\"lastName\":\"Doe\"},{\"id\":\"2\",\"firstName\":\"Jane\",\"lastName\":\"Doe\"}]";
        validFlowFile.assertContentEquals("[{\"id\":\"1\",\"firstName\":\"John\",\"lastName\":\"Doe\"},{\"id\":\"2\",\"firstName\":\"Jane\",\"lastName\":\"Doe\"}]");
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertAttributeEquals("record.count", "1");
        String expectedInvalidContents = "invalid\n\"Three\",\"Jack\",\"Doe\"\n";
        invalidFlowFile.assertContentEquals("invalid\n\"Three\",\"Jack\",\"Doe\"\n");
    }

    @Test
    public void testValidateNestedMap() throws InitializationException, IOException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestValidateRecord/nested-map-schema.avsc", new String[0])), StandardCharsets.UTF_8);
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "schema-text-property");
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, validateSchema);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "false");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/nested-map-input.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "true");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/nested-map-input.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
    }

    @Test
    public void testValidateMissingRequiredArray() throws InitializationException, IOException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestValidateRecord/missing-array.avsc", new String[0])), StandardCharsets.UTF_8);
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "schema-text-property");
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, validateSchema);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "true");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "false");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/missing-array.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testValidateMissingRequiredArrayWithDefault() throws InitializationException, IOException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestValidateRecord/missing-array-with-default.avsc", new String[0])), StandardCharsets.UTF_8);
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "schema-text-property");
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, validateSchema);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "true");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "false");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/missing-array.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testValidateJsonTimestamp() throws IOException, InitializationException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestValidateRecord/timestamp.avsc", new String[0])), StandardCharsets.UTF_8);
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "schema-text-property");
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty((ControllerService)jsonReader, DateTimeUtils.TIMESTAMP_FORMAT, "yyyy/MM/dd HH:mm:ss");
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter validWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.setProperty((ControllerService)validWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.setProperty((ControllerService)validWriter, DateTimeUtils.TIMESTAMP_FORMAT, "yyyy/MM/dd HH:mm:ss");
        this.runner.enableControllerService((ControllerService)validWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.STRICT_TYPE_CHECKING, "true");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/timestamp.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        validFlowFile.assertContentEquals(new File("src/test/resources/TestValidateRecord/timestamp.json"));
        this.runner.clearTransferState();
        this.runner.disableControllerService((ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, DateTimeUtils.TIMESTAMP_FORMAT, "yyyy-MM-dd HH:mm:ss");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/timestamp.json", new String[0]));
        this.runner.enableControllerService((ControllerService)jsonReader);
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertContentEquals(new File("src/test/resources/TestValidateRecord/timestamp.json"));
        this.runner.disableControllerService((ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA.getValue());
        this.runner.setProperty((ControllerService)jsonReader, DateTimeUtils.TIMESTAMP_FORMAT, "yyyy/MM/dd HH:mm:ss");
        this.runner.enableControllerService((ControllerService)jsonReader);
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/timestamp.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        MockFlowFile validFlowFileInferredSchema = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        validFlowFileInferredSchema.assertContentEquals(new File("src/test/resources/TestValidateRecord/timestamp.json"));
    }

    @Test
    public void testValidateMaps() throws IOException, InitializationException, MalformedRecordException {
        String validateSchema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestValidateRecord/int-maps-schema.avsc", new String[0])), StandardCharsets.UTF_8);
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, "schema-text-property");
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, validateSchema);
        this.runner.enableControllerService((ControllerService)jsonReader);
        AvroRecordSetWriter avroWriter = new AvroRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)avroWriter);
        this.runner.enableControllerService((ControllerService)avroWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty(ValidateRecord.SCHEMA_TEXT, validateSchema);
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/int-maps-data.json", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        byte[] source = validFlowFile.toByteArray();
        try (ByteArrayInputStream in = new ByteArrayInputStream(source);
             AvroReaderWithEmbeddedSchema reader = new AvroReaderWithEmbeddedSchema((InputStream)in);){
            Object[] values = reader.nextRecord().getValues();
            Assertions.assertEquals((Object)"uuid", (Object)values[0]);
            Assertions.assertEquals((int)2, (int)((Map)values[1]).size());
            Object[] data = (Object[])values[2];
            Assertions.assertEquals((int)3, (int)data.length);
            Assertions.assertEquals((int)2, (int)((Map)((Record)data[0]).getValue("points")).size());
            Assertions.assertEquals((int)2, (int)((Map)((Record)data[1]).getValue("points")).size());
            Assertions.assertEquals((int)2, (int)((Map)((Record)data[2]).getValue("points")).size());
        }
    }

    @Test
    public void testValidationsDetailsAttributeForInvalidRecords() throws InitializationException, UnsupportedEncodingException, IOException {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string.avsc", new String[0])), "UTF-8");
        CSVReader csvReader = new CSVReader();
        this.runner.addControllerService("reader", (ControllerService)csvReader);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_TEXT, schema);
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.FIRST_LINE_IS_HEADER, "false");
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_MINIMAL.getValue());
        this.runner.setProperty((ControllerService)csvReader, CSVUtils.TRAILING_DELIMITER, "false");
        this.runner.enableControllerService((ControllerService)csvReader);
        MockRecordWriter validWriter = new MockRecordWriter("valid", false);
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.MAX_VALIDATION_DETAILS_LENGTH, "150");
        this.runner.setProperty(ValidateRecord.VALIDATION_DETAILS_ATTRIBUTE_NAME, "valDetails");
        String content = "1, John Doe\n2, Jane Doe\nThree, Jack Doe\n";
        this.runner.enqueue("1, John Doe\n2, Jane Doe\nThree, Jack Doe\n");
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        MockFlowFile invalidFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_INVALID).get(0);
        invalidFlowFile.assertAttributeEquals("record.count", "1");
        invalidFlowFile.assertContentEquals("invalid\n\"Three\",\"Jack Doe\"\n");
        invalidFlowFile.assertAttributeExists("valDetails");
        invalidFlowFile.assertAttributeEquals("valDetails", "Records in this FlowFile were invalid for the following reasons: ; The following 1 fields had values whose type did not match the schema: [/id]");
    }

    @Test
    public void testValidationForNullElementArrayAndMap() throws Exception {
        AvroReader avroReader = new AvroReader();
        this.runner.addControllerService("reader", (ControllerService)avroReader);
        this.runner.enableControllerService((ControllerService)avroReader);
        MockRecordWriter validWriter = new MockRecordWriter("valid", false);
        this.runner.addControllerService("writer", (ControllerService)validWriter);
        this.runner.enableControllerService((ControllerService)validWriter);
        MockRecordWriter invalidWriter = new MockRecordWriter("invalid", true);
        this.runner.addControllerService("invalid-writer", (ControllerService)invalidWriter);
        this.runner.enableControllerService((ControllerService)invalidWriter);
        this.runner.setProperty(ValidateRecord.RECORD_READER, "reader");
        this.runner.setProperty(ValidateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(ValidateRecord.INVALID_RECORD_WRITER, "invalid-writer");
        this.runner.setProperty(ValidateRecord.ALLOW_EXTRA_FIELDS, "false");
        this.runner.setProperty(ValidateRecord.MAX_VALIDATION_DETAILS_LENGTH, "150");
        this.runner.setProperty(ValidateRecord.VALIDATION_DETAILS_ATTRIBUTE_NAME, "valDetails");
        this.runner.enqueue(Paths.get("src/test/resources/TestValidateRecord/array-and-map-with-null-element.avro", new String[0]));
        this.runner.run();
        this.runner.assertTransferCount(ValidateRecord.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateRecord.REL_VALID, 1);
        MockFlowFile validFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ValidateRecord.REL_VALID).get(0);
        validFlowFile.assertAttributeEquals("record.count", "1");
        validFlowFile.assertContentEquals("valid\n[text, null],{key=null}\n");
    }
}

