/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.processors.standard.SplitText;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSplitText {
    final String originalFilename = "original.txt";
    final Path dataPath = Paths.get("src/test/resources/TestSplitText", new String[0]);
    final Path file = this.dataPath.resolve("original.txt");
    static final String TEST_INPUT_DATA = "HeaderLine1\nLine2SpacesAtEnd  \nLine3\nLine4\n\n\nLine8\nLine9\n\n\n13\n14\n15    EndofLine15\n16\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nLastLine\n";

    @Test
    public void testLastLineExceedsSizeLimit() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "20 B");
        runner.enqueue("Line #1\nLine #2\nLine #3\nLong line exceeding limit");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeEquals(SplitText.FRAGMENT_COUNT, "3");
        originalFlowFile.assertAttributeExists(SplitText.FRAGMENT_ID);
        runner.assertTransferCount(SplitText.REL_SPLITS, 3);
    }

    @Test
    public void testIncompleteHeader() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "50 B");
        runner.enqueue("Header Line #1");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 1);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 0);
        runner.assertTransferCount(SplitText.REL_SPLITS, 0);
    }

    @Test
    public void testSingleCharacterHeaderMarker() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "7");
        runner.setProperty(SplitText.HEADER_MARKER, "H");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "2");
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertAttributeEquals("text.line.count", "7");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "86");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals("text.line.count", "3");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "54");
        String fragmentUUID = ((MockFlowFile)splits.get(0)).getAttribute(SplitText.FRAGMENT_ID);
        for (int i = 0; i < splits.size(); ++i) {
            MockFlowFile split = (MockFlowFile)splits.get(i);
            split.assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(i + 1));
            split.assertAttributeEquals(SplitText.FRAGMENT_ID, fragmentUUID);
            split.assertAttributeEquals(SplitText.FRAGMENT_COUNT, String.valueOf(splits.size()));
            split.assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, this.file.getFileName().toString());
        }
    }

    @Test
    public void testMultipleHeaderIndicators() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.HEADER_MARKER, "Head");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "3");
        runner.assertTransferCount(SplitText.REL_SPLITS, 3);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertAttributeEquals("text.line.count", "5");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "62");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals("text.line.count", "5");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "55");
        ((MockFlowFile)splits.get(2)).assertAttributeEquals("text.line.count", "1");
        ((MockFlowFile)splits.get(2)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "23");
        String fragmentUUID = ((MockFlowFile)splits.get(0)).getAttribute(SplitText.FRAGMENT_ID);
        for (int i = 0; i < splits.size(); ++i) {
            MockFlowFile split = (MockFlowFile)splits.get(i);
            split.assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(i + 1));
            split.assertAttributeEquals(SplitText.FRAGMENT_ID, fragmentUUID);
            split.assertAttributeEquals(SplitText.FRAGMENT_COUNT, String.valueOf(splits.size()));
            split.assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, this.file.getFileName().toString());
        }
    }

    @Test
    public void testZeroLinesNoMaxSize() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "0");
        runner.assertNotValid();
    }

    @Test
    public void testMultipleSplitDirectives() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "50 B");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue("Header Line #1\nHeader Line #2\nLine #1\nLine #2\nLine #3 This line has additional text added so that it exceeds the maximum fragment size\nLine #4\nLine #5\nLine #6\nLine #7\nLine #8\nLine #9\nLine #10\n");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "6");
        runner.assertTransferCount(SplitText.REL_SPLITS, 6);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        Assertions.assertEquals((long)46L, (long)((MockFlowFile)splits.get(0)).getSize());
        Assertions.assertEquals((long)119L, (long)((MockFlowFile)splits.get(1)).getSize());
        Assertions.assertEquals((long)46L, (long)((MockFlowFile)splits.get(2)).getSize());
        Assertions.assertEquals((long)46L, (long)((MockFlowFile)splits.get(3)).getSize());
        Assertions.assertEquals((long)46L, (long)((MockFlowFile)splits.get(4)).getSize());
        Assertions.assertEquals((long)39L, (long)((MockFlowFile)splits.get(5)).getSize());
    }

    @Test
    public void testFlowFileIsOnlyHeader() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "50 B");
        runner.setProperty(SplitText.HEADER_MARKER, "Head");
        runner.enqueue("Header Line #1\nHeaderLine#2\n");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "1");
        runner.assertTransferCount(SplitText.REL_SPLITS, 1);
        runner.clearTransferState();
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "50 B");
        runner.enqueue("Header Line #1\nHeaderLine #2\n");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "1");
        runner.assertTransferCount(SplitText.REL_SPLITS, 1);
        runner.clearTransferState();
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "2");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "50 B");
        runner.enqueue("Header Line #1");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals("fragment.count", "1");
        runner.assertTransferCount(SplitText.REL_SPLITS, 1);
    }

    @Test
    public void testMaxSizeExceeded() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "0");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "71 B");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        String fragmentUUID = ((MockFlowFile)splits.get(0)).getAttribute(SplitText.FRAGMENT_ID);
        for (int i = 0; i < splits.size(); ++i) {
            MockFlowFile split = (MockFlowFile)splits.get(i);
            split.assertAttributeEquals("text.line.count", "5");
            split.assertAttributeEquals(SplitText.FRAGMENT_SIZE, "70");
            split.assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(i + 1));
            split.assertAttributeEquals(SplitText.FRAGMENT_ID, fragmentUUID);
            split.assertAttributeEquals(SplitText.FRAGMENT_COUNT, String.valueOf(splits.size()));
            split.assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, this.file.getFileName().toString());
        }
        runner.clearTransferState();
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "0");
        runner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "71 B");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        fragmentUUID = ((MockFlowFile)splits.get(0)).getAttribute(SplitText.FRAGMENT_ID);
        ((MockFlowFile)splits.get(0)).assertContentEquals("Header Line #1\nHeader Line #2\nLine #1\nLine #2\nLine #3\nLine #4\nLine #5\n");
        ((MockFlowFile)splits.get(1)).assertContentEquals("Line #6\nLine #7\nLine #8\nLine #9\nLine #10");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals("text.line.count", "7");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "70");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_INDEX, "1");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_ID, fragmentUUID);
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, this.file.getFileName().toString());
        ((MockFlowFile)splits.get(1)).assertAttributeEquals("text.line.count", "5");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_SIZE, "40");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_INDEX, "2");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_ID, fragmentUUID);
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, this.file.getFileName().toString());
    }

    @Test
    public void testSplitWithOnlyCarriageReturn() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue("H1\rH2\r1\r2\r3\r\r\r\r\r\r\r10\r11\r12\r");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\rH2\r1\r2\r3");
        ((MockFlowFile)splits.get(1)).assertContentEquals("H1\rH2");
        ((MockFlowFile)splits.get(2)).assertContentEquals("H1\rH2");
        ((MockFlowFile)splits.get(3)).assertContentEquals("H1\rH2\r10\r11\r12");
        runner.clearTransferState();
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue("1\r2\r3\r\r\r\r\r\r\r10\r11\r12\r");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        List splitsWithNoHeader = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splitsWithNoHeader.get(0)).assertContentEquals("1\r2\r3");
        ((MockFlowFile)splitsWithNoHeader.get(1)).assertContentEquals("10\r11\r12");
    }

    @Test
    public void testSplitWithCarriageReturnAndNewLines() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue("H1\r\nH2\r\n1\r\n2\r\n3\r\n\r\n\r\n\r\n\r\n\r\n\r\n10\r\n11\r\n12\r\n");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\r\nH2\r\n1\r\n2\r\n3");
        ((MockFlowFile)splits.get(1)).assertContentEquals("H1\r\nH2");
        ((MockFlowFile)splits.get(2)).assertContentEquals("H1\r\nH2");
        ((MockFlowFile)splits.get(3)).assertContentEquals("H1\r\nH2\r\n10\r\n11\r\n12");
        runner.clearTransferState();
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue("1\r\n2\r\n3\r\n\r\n\r\n\r\n\r\n\r\n\r\n10\r\n11\r\n12\r\n");
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        List splitsWithNoHeader = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splitsWithNoHeader.get(0)).assertContentEquals("1\r\n2\r\n3");
        ((MockFlowFile)splitsWithNoHeader.get(1)).assertContentEquals("10\r\n11\r\n12");
    }

    @Test
    public void testRoutesToFailureIfHeaderLinesNotAllPresent() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "100");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue(this.file);
        runner.run();
        runner.assertAllFlowFilesTransferred(SplitText.REL_FAILURE, 1);
    }

    @Test
    public void testZeroByteOutput() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
    }

    @Test
    public void testZeroByteInputWithoutHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "1");
        runner.enqueue("".getBytes());
        runner.run();
        runner.assertTransferCount(SplitText.REL_SPLITS, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
    }

    @Test
    public void testZeroByteInput() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "1");
        runner.enqueue("".getBytes());
        runner.run();
        runner.assertTransferCount(SplitText.REL_SPLITS, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
    }

    @Test
    public void testSplitWithoutHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        String expected0 = "Header Line #1\nHeader Line #2\nLine #1";
        String expected1 = "Line #2\nLine #3\nLine #4";
        String expected2 = "Line #5\nLine #6\nLine #7";
        String expected3 = "Line #8\nLine #9\nLine #10";
        ((MockFlowFile)splits.get(0)).assertContentEquals("Header Line #1\nHeader Line #2\nLine #1");
        ((MockFlowFile)splits.get(1)).assertContentEquals("Line #2\nLine #3\nLine #4");
        ((MockFlowFile)splits.get(2)).assertContentEquals("Line #5\nLine #6\nLine #7");
        ((MockFlowFile)splits.get(3)).assertContentEquals("Line #8\nLine #9\nLine #10");
    }

    @Test
    public void testOneLineSplitWithoutHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "1");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitText.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitText.FRAGMENT_COUNT, "11");
        runner.assertTransferCount(SplitText.REL_SPLITS, 11);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(1)).assertContentEquals("Line2SpacesAtEnd  ");
        ((MockFlowFile)splits.get(2)).assertContentEquals("Line3");
        ((MockFlowFile)splits.get(3)).assertContentEquals("Line4");
        ((MockFlowFile)splits.get(4)).assertContentEquals("Line8");
        ((MockFlowFile)splits.get(5)).assertContentEquals("Line9");
        ((MockFlowFile)splits.get(6)).assertContentEquals("13");
        ((MockFlowFile)splits.get(7)).assertContentEquals("14");
        ((MockFlowFile)splits.get(8)).assertContentEquals("15    EndofLine15");
        ((MockFlowFile)splits.get(9)).assertContentEquals("16");
        ((MockFlowFile)splits.get(10)).assertContentEquals("LastLine");
    }

    @Test
    public void testFiveLineSplitWithoutHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1\nLine2SpacesAtEnd  \nLine3\nLine4");
        ((MockFlowFile)splits.get(1)).assertContentEquals("\nLine8\nLine9");
        ((MockFlowFile)splits.get(2)).assertContentEquals("13\n14\n15    EndofLine15\n16");
        ((MockFlowFile)splits.get(3)).assertContentEquals("\n\nLastLine");
    }

    @Test
    public void testFiveLineSplitWithoutHeaderRetainNewline() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 10);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1\nLine2SpacesAtEnd  \nLine3\nLine4\n\n");
        ((MockFlowFile)splits.get(1)).assertContentEquals("\nLine8\nLine9\n\n\n");
        ((MockFlowFile)splits.get(2)).assertContentEquals("13\n14\n15    EndofLine15\n16\n\n");
        ((MockFlowFile)splits.get(3)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(4)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(5)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(6)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(7)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(8)).assertContentEquals("\n\n\n\n\n");
        ((MockFlowFile)splits.get(9)).assertContentEquals("\n\nLastLine\n");
    }

    @Test
    public void testFiveLineSplitWithHeaderRetainNewline() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 10);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1\nLine2SpacesAtEnd  \nLine3\nLine4\n\n\n");
        ((MockFlowFile)splits.get(1)).assertContentEquals("HeaderLine1\nLine8\nLine9\n\n\n13\n");
        ((MockFlowFile)splits.get(2)).assertContentEquals("HeaderLine1\n14\n15    EndofLine15\n16\n\n\n");
        ((MockFlowFile)splits.get(3)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(4)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(5)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(6)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(7)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(8)).assertContentEquals("HeaderLine1\n\n\n\n\n\n");
        ((MockFlowFile)splits.get(9)).assertContentEquals("HeaderLine1\n\nLastLine\n");
    }

    @Test
    public void testFiveLineSplitWithHeaderNotRetainNewline() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 10);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1\nLine2SpacesAtEnd  \nLine3\nLine4");
        ((MockFlowFile)splits.get(1)).assertContentEquals("HeaderLine1\nLine8\nLine9\n\n\n13");
        ((MockFlowFile)splits.get(2)).assertContentEquals("HeaderLine1\n14\n15    EndofLine15\n16");
        ((MockFlowFile)splits.get(3)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(4)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(5)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(6)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(7)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(8)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(9)).assertContentEquals("HeaderLine1\n\nLastLine");
    }

    @Test
    public void testOneLineSplitWithHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "1");
        runner.enqueue(TEST_INPUT_DATA);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 47);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("HeaderLine1\nLine2SpacesAtEnd  ");
        ((MockFlowFile)splits.get(1)).assertContentEquals("HeaderLine1\nLine3");
        ((MockFlowFile)splits.get(2)).assertContentEquals("HeaderLine1\nLine4");
        ((MockFlowFile)splits.get(3)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(4)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(5)).assertContentEquals("HeaderLine1\nLine8");
        ((MockFlowFile)splits.get(6)).assertContentEquals("HeaderLine1\nLine9");
        ((MockFlowFile)splits.get(7)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(8)).assertContentEquals("HeaderLine1");
        ((MockFlowFile)splits.get(9)).assertContentEquals("HeaderLine1\n13");
        ((MockFlowFile)splits.get(10)).assertContentEquals("HeaderLine1\n14");
        ((MockFlowFile)splits.get(11)).assertContentEquals("HeaderLine1\n15    EndofLine15");
        ((MockFlowFile)splits.get(12)).assertContentEquals("HeaderLine1\n16");
        for (int i = 13; i < 46; ++i) {
            ((MockFlowFile)splits.get(i)).assertContentEquals("HeaderLine1");
        }
        ((MockFlowFile)splits.get(46)).assertContentEquals("HeaderLine1\nLastLine");
    }

    @Test
    public void testSplitWithTwoLineHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 4);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        for (int i = 0; i < splits.size(); ++i) {
            MockFlowFile split = (MockFlowFile)splits.get(i);
            split.assertContentEquals(this.file.getParent().resolve(i + 1 + ".txt"));
            split.assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(i + 1));
        }
    }

    @Test
    public void testSplitWithTwoLineHeaderAndEvenMultipleOfLines() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitText());
        runner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        runner.setProperty(SplitText.LINE_SPLIT_COUNT, "5");
        runner.enqueue(this.file);
        runner.run();
        runner.assertTransferCount(SplitText.REL_FAILURE, 0);
        runner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitText.REL_SPLITS, 2);
        List splits = runner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals(this.file.getParent().resolve("5.txt"));
        ((MockFlowFile)splits.get(0)).assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(1));
        ((MockFlowFile)splits.get(1)).assertContentEquals(this.file.getParent().resolve("6.txt"));
        ((MockFlowFile)splits.get(1)).assertAttributeEquals(SplitText.FRAGMENT_INDEX, String.valueOf(2));
    }

    @Test
    public void testSplitThenMerge() throws IOException {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "false");
        splitRunner.enqueue(this.file);
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 4);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        for (MockFlowFile flowFile : splits) {
            flowFile.assertAttributeEquals(SplitText.SEGMENT_ORIGINAL_FILENAME, "original.txt");
            flowFile.assertAttributeEquals(SplitText.FRAGMENT_COUNT, "4");
        }
        TestRunner mergeRunner = TestRunners.newTestRunner((Processor)new MergeContent());
        mergeRunner.setProperty(MergeContent.MERGE_FORMAT, MergeContent.MERGE_FORMAT_CONCAT);
        mergeRunner.setProperty(MergeContent.MERGE_STRATEGY, MergeContent.MERGE_STRATEGY_DEFRAGMENT);
        mergeRunner.enqueue((FlowFile[])splits.toArray(new MockFlowFile[0]));
        mergeRunner.run();
        mergeRunner.assertTransferCount(MergeContent.REL_MERGED, 1);
        mergeRunner.assertTransferCount(MergeContent.REL_ORIGINAL, 4);
        mergeRunner.assertTransferCount(MergeContent.REL_FAILURE, 0);
        List packed = mergeRunner.getFlowFilesForRelationship(MergeContent.REL_MERGED);
        MockFlowFile flowFile = (MockFlowFile)packed.get(0);
        flowFile.assertAttributeEquals(CoreAttributes.FILENAME.key(), "original.txt");
        Assertions.assertEquals((long)Files.size(this.dataPath.resolve("original.txt")), (long)flowFile.getSize());
        flowFile.assertContentEquals(this.file);
    }

    @Test
    public void testSplitWithOnlyNewLines() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("H1\nH2\n1\n2\n3\n\n\n\n\n\n\n10\n11\n12\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 4);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\nH2\n1\n2\n3");
        ((MockFlowFile)splits.get(1)).assertContentEquals("H1\nH2");
        ((MockFlowFile)splits.get(2)).assertContentEquals("H1\nH2");
        ((MockFlowFile)splits.get(3)).assertContentEquals("H1\nH2\n10\n11\n12");
        splitRunner.clearTransferState();
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("1\n2\n3\n\n\n\n\n\n\n10\n11\n12\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splitsWithNoHeader = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splitsWithNoHeader.get(0)).assertContentEquals("1\n2\n3");
        ((MockFlowFile)splitsWithNoHeader.get(1)).assertContentEquals("10\n11\n12");
    }

    @Test
    public void testWithLotsOfBlankLinesAtEnd() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "10");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("H1\nH2\n1\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 1);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\nH2\n1");
        splitRunner.clearTransferState();
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        splitRunner.enqueue("1\n2\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 1);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splitsWithNoHeader = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splitsWithNoHeader.get(0)).assertContentEquals("1\n2");
    }

    @Test
    public void testAllNewLinesTrimmed() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("1\n2\n\n\n\n\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 1);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        MockFlowFile split0 = (MockFlowFile)splits.get(0);
        split0.assertContentEquals("1\n2");
        split0.assertAttributeEquals(SplitText.FRAGMENT_INDEX, "1");
        split0.assertAttributeEquals(SplitText.FRAGMENT_COUNT, "1");
        split0.assertAttributeEquals("text.line.count", "2");
    }

    @Test
    public void testFragmentCountIsActualFlowFileCount() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "1");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("1\n2\n\n\n\n\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        MockFlowFile split0 = (MockFlowFile)splits.get(0);
        split0.assertContentEquals("1");
        split0.assertAttributeEquals(SplitText.FRAGMENT_INDEX, "1");
        split0.assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        split0.assertAttributeEquals("text.line.count", "1");
        MockFlowFile split1 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals("2");
        split1.assertAttributeEquals(SplitText.FRAGMENT_INDEX, "2");
        split1.assertAttributeEquals(SplitText.FRAGMENT_COUNT, "2");
        split1.assertAttributeEquals("text.line.count", "1");
    }

    @Test
    public void testConsistentTrailingOfNewLines() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("H1\n1\n\n\n\n\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 3);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\n1");
        ((MockFlowFile)splits.get(1)).assertContentEquals("H1");
        ((MockFlowFile)splits.get(2)).assertContentEquals("H1");
    }

    @Test
    public void testWithSplitThatStartsWithNewLine() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "1");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("H1\n1\n2\n3\n\n\n4\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("H1\n1\n2\n3");
        ((MockFlowFile)splits.get(1)).assertContentEquals("H1\n\n\n4");
        splitRunner.clearTransferState();
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "0");
        splitRunner.enqueue("1\n2\n3\n\n\n4\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splitsWithoutHeader = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splitsWithoutHeader.get(0)).assertContentEquals("1\n2\n3");
        ((MockFlowFile)splitsWithoutHeader.get(1)).assertContentEquals("\n\n4");
    }

    @Test
    public void testWithEmptyHeaderLines() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "3");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("\n\n1\n\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 2);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("\n\n1");
        ((MockFlowFile)splits.get(1)).assertContentEquals("\n");
    }

    @Test
    public void testMaxFragmentSizeWithTrimmedEndlines() {
        TestRunner splitRunner = TestRunners.newTestRunner((Processor)new SplitText());
        splitRunner.setProperty(SplitText.HEADER_LINE_COUNT, "2");
        splitRunner.setProperty(SplitText.LINE_SPLIT_COUNT, "0");
        splitRunner.setProperty(SplitText.FRAGMENT_MAX_SIZE, "30 B");
        splitRunner.setProperty(SplitText.REMOVE_TRAILING_NEWLINES, "true");
        splitRunner.enqueue("header1\nheader2\nline1 longer than limit\nline2\nline3\n\n\n\n\n");
        splitRunner.run();
        splitRunner.assertTransferCount(SplitText.REL_SPLITS, 3);
        splitRunner.assertTransferCount(SplitText.REL_ORIGINAL, 1);
        splitRunner.assertTransferCount(SplitText.REL_FAILURE, 0);
        List splits = splitRunner.getFlowFilesForRelationship(SplitText.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("header1\nheader2\nline1 longer than limit");
        ((MockFlowFile)splits.get(1)).assertContentEquals("header1\nheader2\nline2\nline3");
        ((MockFlowFile)splits.get(2)).assertContentEquals("header1\nheader2");
    }
}

