/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processors.standard.PartitionRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPartitionRecord {
    private TestRunner runner;
    private MockRecordParser readerService;
    private MockRecordWriter writerService;

    @BeforeEach
    public void setup() throws InitializationException {
        this.readerService = new MockRecordParser();
        this.writerService = new MockRecordWriter(null, false);
        this.runner = TestRunners.newTestRunner(PartitionRecord.class);
        this.runner.addControllerService("reader", (ControllerService)this.readerService);
        this.runner.enableControllerService((ControllerService)this.readerService);
        this.runner.addControllerService("writer", (ControllerService)this.writerService);
        this.runner.enableControllerService((ControllerService)this.writerService);
        this.runner.setProperty(PartitionRecord.RECORD_READER, "reader");
        this.runner.setProperty(PartitionRecord.RECORD_WRITER, "writer");
        this.readerService.addSchemaField("name", RecordFieldType.STRING);
        this.readerService.addSchemaField("age", RecordFieldType.INT);
        this.readerService.addSchemaField("sports", RecordFieldType.ARRAY);
    }

    @Test
    public void groupByStringMixedNumberOfRecords() {
        this.runner.setProperty("person-name", "/name");
        this.readerService.addRecord(new Object[]{"John", 28, null});
        this.readerService.addRecord(new Object[]{"Jake", 49, null});
        this.readerService.addRecord(new Object[]{"Mark", 19, null});
        this.readerService.addRecord(new Object[]{"Jane", 20, null});
        this.readerService.addRecord(new Object[]{"Jake", 14, null});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 4);
        List out = this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS);
        Assertions.assertEquals((long)3L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("1")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("2")).count());
        out.forEach(ff -> ff.assertAttributeEquals("fragment.count", "4"));
        IntStream.of(1, 3).forEach(i -> ((MockFlowFile)out.get(i)).assertAttributeEquals("fragment.id", ((MockFlowFile)out.get(0)).getAttribute("fragment.id")));
        IntStream.of(0, 3).forEach(i -> Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("fragment.index").equals(String.valueOf(i))).count()));
        out.stream().filter(ff -> ff.getAttribute("record.count").equals("2")).forEach(ff -> ff.assertContentEquals("Jake,49,\nJake,14,\n"));
        for (String name : new String[]{"John", "Jake", "Mark", "Jane"}) {
            Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("person-name").equals(name)).count());
        }
    }

    @Test
    public void groupByIsEmpty() {
        this.runner.setProperty("unknown-age", "isEmpty( /age )");
        this.runner.setProperty("another-unknown", "isEmpty( /nonExistentField )");
        this.readerService.addRecord(new Object[]{"John", 28, null});
        this.readerService.addRecord(new Object[]{"Jake", 49, null});
        this.readerService.addRecord(new Object[]{"Mark", null, null});
        this.readerService.addRecord(new Object[]{"Jane", 20, null});
        this.readerService.addRecord(new Object[]{"Jake", 14, null});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 2);
        List out = this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS);
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("1")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("4")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("unknown-age").equals("true")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("unknown-age").equals("false")).count());
        out.forEach(ff -> ff.assertAttributeEquals("another-unknown", "true"));
    }

    @Test
    public void testExpressionAsPath() {
        this.runner.setProperty("adult", "/age >= 18");
        this.readerService.addRecord(new Object[]{"John", 28, null});
        this.readerService.addRecord(new Object[]{"Jake", 49, null});
        this.readerService.addRecord(new Object[]{"Mark", null, null});
        this.readerService.addRecord(new Object[]{"Jane", 20, null});
        this.readerService.addRecord(new Object[]{"Jake", 14, null});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 2);
        List out = this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS);
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("2")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("record.count").equals("3")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("adult").equals("true")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(ff -> ff.getAttribute("adult").equals("false")).count());
    }

    @Test
    public void testGroupByIntAllRecordsTogether() {
        this.runner.setProperty("age", "/age");
        this.readerService.addRecord(new Object[]{"John", 30, null});
        this.readerService.addRecord(new Object[]{"Jake", 30, null});
        this.readerService.addRecord(new Object[]{"Mark", 30, null});
        this.readerService.addRecord(new Object[]{"Jane", 30, null});
        this.readerService.addRecord(new Object[]{"Jake", 30, null});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "5");
        out.assertContentEquals("John,30,\nJake,30,\nMark,30,\nJane,30,\nJake,30,\n");
        out.assertAttributeEquals("age", "30");
    }

    @Test
    public void testGroupByMultipleFields() {
        this.runner.setProperty("age", "/age");
        this.runner.setProperty("name", "/name");
        this.readerService.addRecord(new Object[]{"John", 30, null});
        this.readerService.addRecord(new Object[]{"Jane", 30, null});
        this.readerService.addRecord(new Object[]{"John", 30, null});
        this.readerService.addRecord(new Object[]{"John", 31, null});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 3);
        List out = this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS);
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("John,30,\nJohn,30,\n") && mff.isAttributeEqual("age", "30") && mff.isAttributeEqual("name", "John")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("Jane,30,\n") && mff.isAttributeEqual("age", "30") && mff.isAttributeEqual("name", "Jane")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("John,31,\n") && mff.isAttributeEqual("age", "31") && mff.isAttributeEqual("name", "John")).count());
    }

    @Test
    public void testGroupByArrayField() {
        this.runner.setProperty("sports", "/sports");
        this.readerService.addRecord(new Object[]{"John", 30, new String[]{"baseball"}});
        this.readerService.addRecord(new Object[]{"Jane", 30, new String[]{"baseball"}});
        this.readerService.addRecord(new Object[]{"John", 30, new String[]{"basketball"}});
        this.readerService.addRecord(new Object[]{"John", 31, new String[]{"football"}});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertTransferCount(PartitionRecord.REL_ORIGINAL, 1);
        this.runner.assertTransferCount(PartitionRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(PartitionRecord.REL_SUCCESS, 3);
        List out = this.runner.getFlowFilesForRelationship(PartitionRecord.REL_SUCCESS);
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("John,30,[baseball]\nJane,30,[baseball]\n")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("John,30,[basketball]\n")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("John,31,[football]\n")).count());
        Assertions.assertTrue((boolean)out.stream().noneMatch(mff -> mff.getAttributes().containsKey("sports")));
    }

    @Test
    public void testReadFailure() throws IOException {
        this.runner.setProperty("sports", "/sports");
        this.readerService.failAfter(2);
        this.readerService.addRecord(new Object[]{"John", 30, new String[]{"baseball"}});
        this.readerService.addRecord(new Object[]{"Jane", 30, new String[]{"baseball"}});
        this.readerService.addRecord(new Object[]{"John", 30, new String[]{"basketball"}});
        this.readerService.addRecord(new Object[]{"John", 31, new String[]{"football"}});
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PartitionRecord.REL_FAILURE, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(PartitionRecord.REL_FAILURE).get(0)).assertContentEquals(new byte[0]);
    }

    @Test
    public void testValueWrapperEqualityWithArrays() {
        String[] a = new String[]{"baseball"};
        String[] b = new String[]{"baseball"};
        Assertions.assertEquals((Object)new PartitionRecord.ValueWrapper((Object)a), (Object)new PartitionRecord.ValueWrapper((Object)b));
    }
}

