/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ParseSyslog;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestParseSyslog {
    static final String PRI = "34";
    static final String SEV = "2";
    static final String FAC = "4";
    static final String TIME = "Oct 13 15:43:23";
    static final String HOST = "localhost.home";
    static final String IPV6SRC = "fe80::216:3300:eeaa:eeaa";
    static final String IPV4SRC = "8.8.4.4";
    static final String BODY = "some message";
    static final String VALID_MESSAGE_RFC3164_0 = "<34>Oct 13 15:43:23 localhost.home some message\n";
    static final String VALID_MESSAGE_RFC3164_1 = "<34>Oct 13 15:43:23 fe80::216:3300:eeaa:eeaa some message\n";
    static final String VALID_MESSAGE_RFC3164_2 = "<34>Oct 13 15:43:23 8.8.4.4 some message\n";

    @Test
    public void testSuccessfulParse3164() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog());
        runner.enqueue(VALID_MESSAGE_RFC3164_0.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseSyslog.REL_SUCCESS).get(0);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_BODY.key(), BODY);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_FACILITY.key(), FAC);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_HOSTNAME.key(), HOST);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_PRIORITY.key(), PRI);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_SEVERITY.key(), SEV);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_TIMESTAMP.key(), TIME);
    }

    @Test
    public void testValidIPv6Source() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog());
        runner.enqueue(VALID_MESSAGE_RFC3164_1.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseSyslog.REL_SUCCESS).get(0);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_BODY.key(), BODY);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_FACILITY.key(), FAC);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_HOSTNAME.key(), IPV6SRC);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_PRIORITY.key(), PRI);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_SEVERITY.key(), SEV);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_TIMESTAMP.key(), TIME);
    }

    @Test
    public void testValidIPv4Source() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog());
        runner.enqueue(VALID_MESSAGE_RFC3164_2.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseSyslog.REL_SUCCESS).get(0);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_BODY.key(), BODY);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_FACILITY.key(), FAC);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_HOSTNAME.key(), IPV4SRC);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_PRIORITY.key(), PRI);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_SEVERITY.key(), SEV);
        mff.assertAttributeEquals(SyslogAttributes.SYSLOG_TIMESTAMP.key(), TIME);
    }

    @Test
    public void testInvalidMessage() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog());
        runner.enqueue("<hello> yesterday localhost\n".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog.REL_FAILURE, 1);
    }
}

