/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.LinkedHashMap;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.LogAttribute;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Test;

public class TestLogAttribute {
    @Test
    public void testLogPropertyCSVNoIgnore() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_CSV, "foo, bar");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"bar-value"));
    }

    @Test
    public void testLogPropertyRegexNoIgnore() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_REGEX, "foo.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foobaz-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyWithCSVAndRegexNoIgnore() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_CSV, "foo, bar");
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_REGEX, "foo*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyWithIgnoreCSV() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_CSV, "bar");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foobaz-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyWithIgnoreRegex() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_REGEX, "foo.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foo-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"bar-value"));
    }

    @Test
    public void testLogPropertyWithIgnoreCSVAndRegex() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_CSV, "foo,bar");
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_REGEX, "foo.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foo-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyCSVWithIgnoreRegex() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_CSV, "foo");
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_REGEX, "foo.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foo-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyCSVWithIgnoreCSV() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_CSV, "foo,foobaz");
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_CSV, "foobaz");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }

    @Test
    public void testLogPropertyRegexWithIgnoreRegex() {
        LogAttribute logAttribute = new LogAttribute();
        TestRunner runner = TestRunners.newTestRunner((Processor)logAttribute);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockComponentLog LOG = runner.getLogger();
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_LOG_REGEX, "foo.*");
        runner.setProperty(LogAttribute.ATTRIBUTES_TO_IGNORE_REGEX, "foobaz.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("foo", "foo-value");
        attrs.put("bar", "bar-value");
        attrs.put("foobaz", "foobaz-value");
        MockFlowFile flowFile = runner.enqueue("content", attrs);
        String logMessage = logAttribute.processFlowFile((ComponentLog)LOG, LogAttribute.DebugLevels.info, (FlowFile)flowFile, session, context);
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"foobaz-value")));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)CoreMatchers.containsString((String)"foo-value"));
        MatcherAssert.assertThat((Object)logMessage, (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)"bar-value")));
    }
}

