/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.JoinEnrichment;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.ArrayListRecordWriter;
import org.apache.nifi.serialization.record.CommaSeparatedRecordReader;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJoinEnrichment {
    private static final File EXAMPLES_DIR = new File("src/test/resources/TestJoinEnrichment");

    @Test
    public void testManyQueued() throws InitializationException {
        char letter;
        int i;
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupCsvServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_SQL);
        runner.setProperty(JoinEnrichment.SQL, "SELECT original.i, original.lower_letter, enrichment.upper_letter FROM original JOIN enrichment ON original.i = enrichment.i");
        for (i = 0; i < 26; ++i) {
            HashMap<String, String> originalAttributes = new HashMap<String, String>();
            originalAttributes.put("enrichment.group.id", String.valueOf(i));
            originalAttributes.put("enrichment.role", "ORIGINAL");
            letter = (char)(97 + i);
            runner.enqueue("i,lower_letter\n" + i + "," + letter, originalAttributes);
        }
        for (i = 0; i < 26; ++i) {
            HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
            enrichmentAttributes.put("enrichment.group.id", String.valueOf(i));
            enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
            letter = (char)(65 + i);
            runner.enqueue("i,upper_letter\n" + i + "," + letter, enrichmentAttributes);
        }
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 26);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 52);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)26, (int)written.size());
        BitSet found = new BitSet();
        for (Record outRecord : written) {
            RecordSchema schema = outRecord.getSchema();
            Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((RecordField)schema.getField("i").get()).getDataType().getFieldType());
            Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((RecordField)schema.getField("lower_letter").get()).getDataType().getFieldType());
            Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((RecordField)schema.getField("upper_letter").get()).getDataType().getFieldType());
            int id = outRecord.getAsInt("i");
            String expectedLower = "" + (char)(97 + id);
            Assertions.assertEquals((Object)expectedLower, (Object)outRecord.getValue("lower_letter"));
            String expectedUpper = "" + (char)(65 + id);
            Assertions.assertEquals((Object)expectedUpper, (Object)outRecord.getValue("upper_letter"));
            Assertions.assertEquals((Object)outRecord.getAsString("lower_letter"), (Object)outRecord.getAsString("upper_letter").toLowerCase());
            found.set(id);
        }
        for (int i2 = 0; i2 < 26; ++i2) {
            Assertions.assertTrue((boolean)found.get(i2));
        }
    }

    @Test
    public void testSimpleSqlJoin() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupCsvServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_SQL);
        runner.setProperty(JoinEnrichment.SQL, "SELECT original.id, enrichment.name FROM original JOIN enrichment ON original.id = enrichment.id");
        HashMap<String, String> originalAttributes = new HashMap<String, String>();
        originalAttributes.put("enrichment.group.id", "abc");
        originalAttributes.put("enrichment.role", "ORIGINAL");
        runner.enqueue("id\n5", originalAttributes);
        HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
        enrichmentAttributes.put("enrichment.group.id", "abc");
        enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
        runner.enqueue("id,name\n5,John Doe", enrichmentAttributes);
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 1);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 2);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record outRecord = (Record)written.get(0);
        Assertions.assertEquals((int)5, (Integer)outRecord.getAsInt("id"));
        Assertions.assertEquals((Object)"John Doe", (Object)outRecord.getValue("name"));
        RecordSchema schema = outRecord.getSchema();
        Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((RecordField)schema.getField("id").get()).getDataType().getFieldType());
        Assertions.assertEquals((Object)RecordFieldType.STRING, (Object)((RecordField)schema.getField("name").get()).getDataType().getFieldType());
    }

    @Test
    public void testLeftOuterJoin() throws InitializationException, IOException, SchemaNotFoundException, MalformedRecordException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupCsvServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_SQL);
        runner.setProperty(JoinEnrichment.SQL, "SELECT o.*, e.* FROM original o LEFT OUTER JOIN enrichment e ON o.id = e.customer_id");
        HashMap<String, String> originalAttributes = new HashMap<String, String>();
        originalAttributes.put("enrichment.group.id", "abc");
        originalAttributes.put("enrichment.role", "ORIGINAL");
        runner.enqueue(new File(EXAMPLES_DIR, "left-outer-join-original.csv").toPath(), originalAttributes);
        HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
        enrichmentAttributes.put("enrichment.group.id", "abc");
        enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
        runner.enqueue(new File(EXAMPLES_DIR, "left-outer-join-enrichment.csv").toPath(), enrichmentAttributes);
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 1);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 2);
        List<Record> expected = this.readCsvRecords(new File(EXAMPLES_DIR, "left-outer-join-expected.csv"));
        Assertions.assertEquals(new HashSet<Record>(expected), new HashSet(writer.getRecordsWritten()));
    }

    @Test
    public void testLeftOuterJoinRenameFields() throws InitializationException, IOException, SchemaNotFoundException, MalformedRecordException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupCsvServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_SQL);
        runner.setProperty(JoinEnrichment.SQL, "SELECT o.id, o.name, e.customer_name AS preferred_name, o.age, e.customer_email AS email FROM original o LEFT OUTER JOIN enrichment e ON o.id = e.customer_id");
        HashMap<String, String> originalAttributes = new HashMap<String, String>();
        originalAttributes.put("enrichment.group.id", "abc");
        originalAttributes.put("enrichment.role", "ORIGINAL");
        runner.enqueue(new File(EXAMPLES_DIR, "left-outer-join-original.csv").toPath(), originalAttributes);
        HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
        enrichmentAttributes.put("enrichment.group.id", "abc");
        enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
        runner.enqueue(new File(EXAMPLES_DIR, "left-outer-join-enrichment.csv").toPath(), enrichmentAttributes);
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 1);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 2);
        List<Record> expected = this.readCsvRecords(new File(EXAMPLES_DIR, "left-outer-join-rename-expected.csv"));
        Assertions.assertEquals(new HashSet<Record>(expected), new HashSet(writer.getRecordsWritten()));
    }

    @Test
    public void testInsertEnrichmentFields() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupJsonServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_INSERT_ENRICHMENT_FIELDS);
        runner.setProperty(JoinEnrichment.INSERTION_RECORD_PATH, "/purchase/customer");
        HashMap<String, String> originalAttributes = new HashMap<String, String>();
        originalAttributes.put("enrichment.group.id", "abc");
        originalAttributes.put("enrichment.role", "ORIGINAL");
        runner.enqueue(new File(EXAMPLES_DIR, "insert-original.json").toPath(), originalAttributes);
        HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
        enrichmentAttributes.put("enrichment.group.id", "abc");
        enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
        runner.enqueue(new File(EXAMPLES_DIR, "insert-enrichment.json").toPath(), enrichmentAttributes);
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 1);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 2);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)2, (int)written.size());
        RecordPath recordPath = RecordPath.compile((String)"/purchase/customer/customerDetails");
        List firstCustomerDetailsList = recordPath.evaluate((Record)written.get(0)).getSelectedFields().map(FieldValue::getValue).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)firstCustomerDetailsList.size());
        Record customerDetails = (Record)firstCustomerDetailsList.get(0);
        Assertions.assertEquals((Object)48202, (Object)customerDetails.getValue("id"));
        Assertions.assertEquals((Object)"555-555-5555", (Object)customerDetails.getValue("phone"));
        Assertions.assertEquals((Object)"john.doe@nifi.apache.org", (Object)customerDetails.getValue("email"));
        List secondCustomerDetailsList = recordPath.evaluate((Record)written.get(1)).getSelectedFields().map(FieldValue::getValue).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)secondCustomerDetailsList.size());
        Record secondCustomerDetails = (Record)secondCustomerDetailsList.get(0);
        Assertions.assertEquals((Object)5512, (Object)secondCustomerDetails.getValue("id"));
        Assertions.assertEquals((Object)"555-555-5511", (Object)secondCustomerDetails.getValue("phone"));
        Assertions.assertEquals((Object)"jane.doe@nifi.apache.org", (Object)secondCustomerDetails.getValue("email"));
    }

    @Test
    public void testFirstEnrichmentRecordNull() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoinEnrichment());
        ArrayListRecordWriter writer = this.setupJsonServices(runner);
        runner.setProperty(JoinEnrichment.JOIN_STRATEGY, JoinEnrichment.JOIN_INSERT_ENRICHMENT_FIELDS);
        runner.setProperty(JoinEnrichment.INSERTION_RECORD_PATH, "/purchase/customer");
        HashMap<String, String> originalAttributes = new HashMap<String, String>();
        originalAttributes.put("enrichment.group.id", "abc");
        originalAttributes.put("enrichment.role", "ORIGINAL");
        runner.enqueue(new File(EXAMPLES_DIR, "insert-original.json").toPath(), originalAttributes);
        HashMap<String, String> enrichmentAttributes = new HashMap<String, String>();
        enrichmentAttributes.put("enrichment.group.id", "abc");
        enrichmentAttributes.put("enrichment.role", "ENRICHMENT");
        runner.enqueue(new File(EXAMPLES_DIR, "insert-enrichment-first-value-null.json").toPath(), enrichmentAttributes);
        runner.run();
        runner.assertTransferCount(JoinEnrichment.REL_JOINED, 1);
        runner.assertTransferCount(JoinEnrichment.REL_ORIGINAL, 2);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)2, (int)written.size());
        RecordPath recordPath = RecordPath.compile((String)"/purchase/customer/customerDetails");
        List firstCustomerDetailsList = recordPath.evaluate((Record)written.get(0)).getSelectedFields().map(FieldValue::getValue).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)firstCustomerDetailsList.size());
        Record customerDetails = (Record)firstCustomerDetailsList.get(0);
        Assertions.assertNull((Object)customerDetails);
        List secondCustomerDetailsList = recordPath.evaluate((Record)written.get(1)).getSelectedFields().map(FieldValue::getValue).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)secondCustomerDetailsList.size());
        Record secondCustomerDetails = (Record)secondCustomerDetailsList.get(0);
        Assertions.assertEquals((Object)5512, (Object)secondCustomerDetails.getValue("id"));
        Assertions.assertEquals((Object)"555-555-5511", (Object)secondCustomerDetails.getValue("phone"));
        Assertions.assertEquals((Object)"jane.doe@nifi.apache.org", (Object)secondCustomerDetails.getValue("email"));
    }

    private List<Record> readCsvRecords(File file) throws IOException, SchemaNotFoundException, MalformedRecordException {
        CommaSeparatedRecordReader reader = new CommaSeparatedRecordReader();
        reader.setUseNullForEmptyString(true);
        return this.readRecords((RecordReaderFactory)reader, file);
    }

    private List<Record> readRecords(RecordReaderFactory readerFactory, File file) throws IOException, SchemaNotFoundException, MalformedRecordException {
        ArrayList<Record> records = new ArrayList<Record>();
        try (FileInputStream rawIn = new FileInputStream(file);
             BufferedInputStream in = new BufferedInputStream(rawIn);){
            Record record;
            RecordReader recordReader = readerFactory.createRecordReader(Collections.emptyMap(), (InputStream)in, file.length(), (ComponentLog)new MockComponentLogger());
            while ((record = recordReader.nextRecord()) != null) {
                records.add(record);
            }
        }
        return records;
    }

    private ArrayListRecordWriter setupCsvServices(TestRunner runner) throws InitializationException {
        CommaSeparatedRecordReader originalReader = new CommaSeparatedRecordReader();
        originalReader.setUseNullForEmptyString(true);
        CommaSeparatedRecordReader enrichmentReader = new CommaSeparatedRecordReader();
        enrichmentReader.setUseNullForEmptyString(true);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(null);
        runner.addControllerService("originalReader", (ControllerService)originalReader);
        runner.enableControllerService((ControllerService)originalReader);
        runner.addControllerService("enrichmentReader", (ControllerService)enrichmentReader);
        runner.enableControllerService((ControllerService)enrichmentReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(JoinEnrichment.ORIGINAL_RECORD_READER, "originalReader");
        runner.setProperty(JoinEnrichment.ENRICHMENT_RECORD_READER, "enrichmentReader");
        runner.setProperty(JoinEnrichment.RECORD_WRITER, "writer");
        return writer;
    }

    private ArrayListRecordWriter setupJsonServices(TestRunner runner) throws InitializationException {
        JsonTreeReader originalReader = new JsonTreeReader();
        JsonTreeReader enrichmentReader = new JsonTreeReader();
        ArrayListRecordWriter writer = new ArrayListRecordWriter(null);
        runner.addControllerService("originalReader", (ControllerService)originalReader);
        runner.enableControllerService((ControllerService)originalReader);
        runner.addControllerService("enrichmentReader", (ControllerService)enrichmentReader);
        runner.enableControllerService((ControllerService)enrichmentReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(JoinEnrichment.ORIGINAL_RECORD_READER, "originalReader");
        runner.setProperty(JoinEnrichment.ENRICHMENT_RECORD_READER, "enrichmentReader");
        runner.setProperty(JoinEnrichment.RECORD_WRITER, "writer");
        return writer;
    }
}

