/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.GetFile;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGetFile {
    @Test
    public void testFilePickedUp() throws IOException {
        File directory = new File("target/test/data/in");
        this.deleteDirectory(directory);
        Assertions.assertTrue((directory.exists() || directory.mkdirs() ? 1 : 0) != 0, (String)("Unable to create test data directory " + directory.getAbsolutePath()));
        File inFile = new File("src/test/resources/hello.txt");
        Path inPath = inFile.toPath();
        File destFile = new File(directory, inFile.getName());
        Path targetPath = destFile.toPath();
        Path absTargetPath = targetPath.toAbsolutePath();
        String absTargetPathStr = absTargetPath.getParent() + "/";
        Files.copy(inPath, targetPath, new CopyOption[0]);
        TestRunner runner = TestRunners.newTestRunner((Processor)new GetFile());
        runner.setProperty(GetFile.DIRECTORY, directory.getAbsolutePath());
        runner.run();
        runner.assertAllFlowFilesTransferred(GetFile.REL_SUCCESS, 1);
        List successFiles = runner.getFlowFilesForRelationship(GetFile.REL_SUCCESS);
        ((MockFlowFile)successFiles.get(0)).assertContentEquals("Hello, World!".getBytes("UTF-8"));
        String path = ((MockFlowFile)successFiles.get(0)).getAttribute("path");
        Assertions.assertEquals((Object)"/", (Object)path);
        String absolutePath = ((MockFlowFile)successFiles.get(0)).getAttribute(CoreAttributes.ABSOLUTE_PATH.key());
        Assertions.assertEquals((Object)absTargetPathStr, (Object)absolutePath);
    }

    private void deleteDirectory(File directory) {
        if (directory != null && directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                }
                Assertions.assertTrue((boolean)file.delete(), (String)("Could not delete " + file.getAbsolutePath()));
            }
        }
    }

    @Test
    public void testTodaysFilesPickedUp() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd", Locale.US);
        String dirStruc = sdf.format(new Date());
        File directory = new File("target/test/data/in/" + dirStruc);
        this.deleteDirectory(directory);
        Assertions.assertTrue((directory.exists() || directory.mkdirs() ? 1 : 0) != 0, (String)("Unable to create test data directory " + directory.getAbsolutePath()));
        File inFile = new File("src/test/resources/hello.txt");
        Path inPath = inFile.toPath();
        File destFile = new File(directory, inFile.getName());
        Path targetPath = destFile.toPath();
        Files.copy(inPath, targetPath, new CopyOption[0]);
        TestRunner runner = TestRunners.newTestRunner((Processor)new GetFile());
        runner.setProperty(GetFile.DIRECTORY, "target/test/data/in/${now():format('yyyy/MM/dd')}");
        runner.run();
        runner.assertAllFlowFilesTransferred(GetFile.REL_SUCCESS, 1);
        List successFiles = runner.getFlowFilesForRelationship(GetFile.REL_SUCCESS);
        ((MockFlowFile)successFiles.get(0)).assertContentEquals("Hello, World!".getBytes("UTF-8"));
    }

    @Test
    public void testPath() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd/", Locale.US);
        String dirStruc = sdf.format(new Date());
        File directory = new File("target/test/data/in/" + dirStruc);
        this.deleteDirectory(new File("target/test/data/in"));
        Assertions.assertTrue((directory.exists() || directory.mkdirs() ? 1 : 0) != 0, (String)("Unable to create test data directory " + directory.getAbsolutePath()));
        File inFile = new File("src/test/resources/hello.txt");
        Path inPath = inFile.toPath();
        File destFile = new File(directory, inFile.getName());
        Path targetPath = destFile.toPath();
        Path absTargetPath = targetPath.toAbsolutePath();
        String absTargetPathStr = absTargetPath.getParent().toString() + "/";
        Files.copy(inPath, targetPath, new CopyOption[0]);
        TestRunner runner = TestRunners.newTestRunner((Processor)new GetFile());
        runner.setProperty(GetFile.DIRECTORY, "target/test/data/in");
        runner.run();
        runner.assertAllFlowFilesTransferred(GetFile.REL_SUCCESS, 1);
        List successFiles = runner.getFlowFilesForRelationship(GetFile.REL_SUCCESS);
        ((MockFlowFile)successFiles.get(0)).assertContentEquals("Hello, World!".getBytes("UTF-8"));
        String path = ((MockFlowFile)successFiles.get(0)).getAttribute("path");
        Assertions.assertEquals((Object)dirStruc, (Object)path.replace('\\', '/'));
        String absolutePath = ((MockFlowFile)successFiles.get(0)).getAttribute(CoreAttributes.ABSOLUTE_PATH.key());
        Assertions.assertEquals((Object)absTargetPathStr, (Object)absolutePath);
    }

    @Test
    public void testAttributes() throws IOException, ParseException {
        File directory = new File("target/test/data/in/");
        this.deleteDirectory(directory);
        Assertions.assertTrue((directory.exists() || directory.mkdirs() ? 1 : 0) != 0, (String)("Unable to create test data directory " + directory.getAbsolutePath()));
        File inFile = new File("src/test/resources/hello.txt");
        Path inPath = inFile.toPath();
        File destFile = new File(directory, inFile.getName());
        Path targetPath = destFile.toPath();
        Files.copy(inPath, targetPath, new CopyOption[0]);
        boolean verifyLastModified = false;
        try {
            destFile.setLastModified(1000000000L);
            verifyLastModified = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestRunner runner = TestRunners.newTestRunner((Processor)new GetFile());
        runner.setProperty(GetFile.DIRECTORY, "target/test/data/in");
        runner.run();
        runner.assertAllFlowFilesTransferred(GetFile.REL_SUCCESS, 1);
        List successFiles = runner.getFlowFilesForRelationship(GetFile.REL_SUCCESS);
        if (verifyLastModified) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
            Date fileModifyTime = formatter.parse(((MockFlowFile)successFiles.get(0)).getAttribute("file.lastModifiedTime"));
            Assertions.assertEquals((Object)new Date(1000000000L), (Object)fileModifyTime);
        }
    }
}

