/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.FilterAttribute;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class TestFilterAttribute {
    private final TestRunner runner = TestRunners.newTestRunner(FilterAttribute.class);
    private final String exampleContent = "lorem ipsum dolor sit amet";
    private final Map<String, String> exampleAttributes = TestFilterAttribute.mapOf("foo", "fooValue", "bar", "barValue", "batz", "batzValue");

    TestFilterAttribute() {
    }

    @Test
    void supportMultiThreadedExecution() {
        this.runner.setThreadCount(5);
        int flowFileCount = 10000;
        for (int i = 0; i < 10000; ++i) {
            this.runner.enqueue("lorem ipsum dolor sit amet", TestFilterAttribute.mapOf("foo", "" + i, "bar", "" + i));
        }
        this.runner.setProperty(FilterAttribute.ATTRIBUTE_ENUMERATION, "foo");
        this.runner.run(10000);
        this.runner.assertAllFlowFilesTransferred(FilterAttribute.REL_SUCCESS, 10000);
        List resultFlowFiles = this.runner.getFlowFilesForRelationship(FilterAttribute.REL_SUCCESS);
        for (MockFlowFile resultFlowFile : resultFlowFiles) {
            resultFlowFile.assertAttributeExists("foo");
            resultFlowFile.assertAttributeNotExists("bar");
        }
        Set fooValues = resultFlowFiles.stream().map(flowFile -> flowFile.getAttribute("foo")).collect(Collectors.toSet());
        Assertions.assertEquals((int)10000, (int)fooValues.size());
    }

    private static Map<String, String> mapOf(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    private static Set<String> setOf(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    @Nested
    class WithStrategyRegex {
        WithStrategyRegex() {
        }

        @Test
        void supportsDefiningAttributeSetInFlowFileAttribute() {
            HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
            attributes.put("lookup", "bar|batz");
            String attributeRegex = "${lookup}";
            Set<String> expectedAttributes = TestFilterAttribute.setOf("bar", "batz", "uuid");
            this.runTestWith(attributes, "${lookup}", expectedAttributes);
        }

        private void runTestWith(Map<String, String> attributes, Pattern regex, Set<String> expectedAttributes) {
            this.runTestWith(attributes, regex.pattern(), expectedAttributes);
        }

        private void runTestWith(Map<String, String> attributes, String regexPattern, Set<String> expectedAttributes) {
            TestFilterAttribute.this.runner.setProperty(FilterAttribute.MATCHING_STRATEGY, FilterAttribute.MatchingStrategy.PATTERN.getValue());
            TestFilterAttribute.this.runner.setProperty(FilterAttribute.ATTRIBUTE_PATTERN, regexPattern);
            MockFlowFile input = TestFilterAttribute.this.runner.enqueue("lorem ipsum dolor sit amet", attributes);
            Map inputAttributes = input.getAttributes();
            HashSet notExpectedAttributes = new HashSet(inputAttributes.keySet());
            notExpectedAttributes.removeAll(expectedAttributes);
            TestFilterAttribute.this.runner.run();
            TestFilterAttribute.this.runner.assertAllFlowFilesTransferred(FilterAttribute.REL_SUCCESS, 1);
            MockFlowFile result = (MockFlowFile)TestFilterAttribute.this.runner.getFlowFilesForRelationship(FilterAttribute.REL_SUCCESS).get(0);
            result.assertContentEquals("lorem ipsum dolor sit amet");
            for (String expectedName : expectedAttributes) {
                String expectedValue = (String)inputAttributes.get(expectedName);
                result.assertAttributeEquals(expectedName, expectedValue);
            }
            for (String notExpectedName : notExpectedAttributes) {
                result.assertAttributeNotExists(notExpectedName);
            }
        }

        @Nested
        class InModeRemove {
            InModeRemove() {
            }

            @BeforeEach
            void setUp() {
                TestFilterAttribute.this.runner.setProperty(FilterAttribute.FILTER_MODE, FilterAttribute.FilterMode.REMOVE.getValue());
            }

            @Test
            void removesAllAttributesExceptUUIDWhenAllAreFiltered() {
                Pattern attributeRegex = Pattern.compile("foo|bar|batz|uuid|path|filename");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("uuid");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void removesFilteredAttributesExceptUUIDWhenOnlySomeAreFiltered() {
                Pattern attributeRegex = Pattern.compile("bar|uuid|path|filename");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "batz", "uuid");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void removesNoAttributeWhenNoneOfTheAttributesAreFiltered() {
                Pattern attributeRegex = Pattern.compile("other");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid", "path", "filename");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void supportsAttributeNamesWithWhitespace() {
                HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
                attributes.put("fo\no", "some value");
                Pattern attributeRegex = Pattern.compile("fo\no");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid", "path", "filename");
                WithStrategyRegex.this.runTestWith(attributes, attributeRegex, expectedAttributes);
            }
        }

        @Nested
        class InModeRetain {
            InModeRetain() {
            }

            @Test
            void retainsAllAttributesWhenAllAreFiltered() {
                Pattern attributeRegex = Pattern.compile("foo|bar|batz");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void retainsUUIDAndFilteredAttributesWhenOnlySomeAreFiltered() {
                Pattern attributeRegex = Pattern.compile("bar");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("bar", "uuid");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void retainsUUIDOnlyWhenNoneOfTheAttributesAreFiltered() {
                Pattern attributeRegex = Pattern.compile("other");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("uuid");
                WithStrategyRegex.this.runTestWith(TestFilterAttribute.this.exampleAttributes, attributeRegex, expectedAttributes);
            }

            @Test
            void supportsAttributeNamesWithWhitespace() {
                HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
                attributes.put("fo\no", "some value");
                Pattern attributeRegex = Pattern.compile("fo\no");
                Set<String> expectedAttributes = TestFilterAttribute.setOf("fo\no", "uuid");
                WithStrategyRegex.this.runTestWith(attributes, attributeRegex, expectedAttributes);
            }
        }
    }

    @Nested
    class WithStrategyEnumeration {
        WithStrategyEnumeration() {
        }

        @Test
        void supportsDefiningAttributeSetInFlowFileAttribute() {
            HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
            attributes.put("lookup", "bar,batz");
            String attributeSet = "${lookup}";
            Set<String> expectedAttributes = TestFilterAttribute.setOf("bar", "batz", "uuid");
            this.runTestWith(attributes, "${lookup}", expectedAttributes);
        }

        private void runTestWith(Map<String, String> attributes, String attributeSet, Set<String> expectedAttributes) {
            TestFilterAttribute.this.runner.setProperty(FilterAttribute.MATCHING_STRATEGY, FilterAttribute.MatchingStrategy.ENUMERATION.getValue());
            TestFilterAttribute.this.runner.setProperty(FilterAttribute.ATTRIBUTE_ENUMERATION, attributeSet);
            MockFlowFile input = TestFilterAttribute.this.runner.enqueue("lorem ipsum dolor sit amet", attributes);
            Map inputAttributes = input.getAttributes();
            HashSet notExpectedAttributes = new HashSet(inputAttributes.keySet());
            notExpectedAttributes.removeAll(expectedAttributes);
            TestFilterAttribute.this.runner.run();
            TestFilterAttribute.this.runner.assertAllFlowFilesTransferred(FilterAttribute.REL_SUCCESS, 1);
            MockFlowFile result = (MockFlowFile)TestFilterAttribute.this.runner.getFlowFilesForRelationship(FilterAttribute.REL_SUCCESS).get(0);
            result.assertContentEquals("lorem ipsum dolor sit amet");
            for (String expectedName : expectedAttributes) {
                String expectedValue = (String)inputAttributes.get(expectedName);
                result.assertAttributeEquals(expectedName, expectedValue);
            }
            for (String notExpectedName : notExpectedAttributes) {
                result.assertAttributeNotExists(notExpectedName);
            }
        }

        @Nested
        class RegardingAttributeSetParsing {
            RegardingAttributeSetParsing() {
            }

            @Test
            void ignoresLeadingDelimiters() {
                String attributeSet = ",foo,bar";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, ",foo,bar", expectedAttributes);
            }

            @Test
            void ignoresTrailingDelimiters() {
                String attributeSet = "foo,bar,";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo,bar,", expectedAttributes);
            }

            @Test
            void doesNotYieldErrorWhenAttributeSetIsEffectivelyEmpty() {
                String attributeSet = " , ";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, " , ", expectedAttributes);
            }

            @Test
            void worksWithSingleAttributeInSet() {
                String attributeSet = "batz";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("batz", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "batz", expectedAttributes);
            }

            @Test
            void worksWithMultipleAttributesInSet() {
                String attributeSet = "foo,bar,batz";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo,bar,batz", expectedAttributes);
            }

            @Test
            void ignoresLeadingWhitespaceInAttributeName() {
                String attributeSet = "foo,  batz";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "batz", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo,  batz", expectedAttributes);
            }

            @Test
            void ignoresTrailingWhitespaceInAttributeName() {
                String attributeSet = "foo  ,bar";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo  ,bar", expectedAttributes);
            }
        }

        @Nested
        class InModeRemove {
            InModeRemove() {
            }

            @BeforeEach
            void setUp() {
                TestFilterAttribute.this.runner.setProperty(FilterAttribute.FILTER_MODE, FilterAttribute.FilterMode.REMOVE.getValue());
            }

            @Test
            void removesAllAttributesExceptUUIDWhenAllAreFiltered() {
                String attributeSet = "foo,bar,batz,uuid,path,filename";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo,bar,batz,uuid,path,filename", expectedAttributes);
            }

            @Test
            void removesFilteredAttributesExceptUUIDWhenOnlySomeAreFiltered() {
                String attributeSet = "bar,uuid,path,filename";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "batz", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "bar,uuid,path,filename", expectedAttributes);
            }

            @Test
            void removesNoAttributeWhenNoneOfTheAttributesAreFiltered() {
                String attributeSet = "other";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid", "path", "filename");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "other", expectedAttributes);
            }

            @Test
            void supportsAttributeNamesWithWhitespace() {
                HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
                attributes.put("fo\no", "some value");
                String attributeSet = "fo\no";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid", "path", "filename");
                WithStrategyEnumeration.this.runTestWith(attributes, "fo\no", expectedAttributes);
            }
        }

        @Nested
        class InModeRetain {
            InModeRetain() {
            }

            @Test
            void retainsAllAttributesWhenAllAreFiltered() {
                String attributeSet = "foo,bar,batz";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("foo", "bar", "batz", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "foo,bar,batz", expectedAttributes);
            }

            @Test
            void retainsUUIDAndFilteredAttributesWhenOnlySomeAreFiltered() {
                String attributeSet = "bar";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("bar", "uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "bar", expectedAttributes);
            }

            @Test
            void retainsUUIDOnlyWhenNoneOfTheAttributesAreFiltered() {
                String attributeSet = "other";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("uuid");
                WithStrategyEnumeration.this.runTestWith(TestFilterAttribute.this.exampleAttributes, "other", expectedAttributes);
            }

            @Test
            void supportsAttributeNamesWithWhitespace() {
                HashMap<String, String> attributes = new HashMap<String, String>(TestFilterAttribute.this.exampleAttributes);
                attributes.put("fo\no", "some value");
                String attributeSet = "fo\no";
                Set<String> expectedAttributes = TestFilterAttribute.setOf("fo\no", "uuid");
                WithStrategyEnumeration.this.runTestWith(attributes, "fo\no", expectedAttributes);
            }
        }
    }
}

