/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.FetchFile;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test only runs on *nix")
public class TestFetchFile {
    @BeforeEach
    public void prepDestDirectory() throws IOException {
        File targetDir = new File("target/move-target");
        if (!targetDir.exists()) {
            Files.createDirectories(targetDir.toPath(), new FileAttribute[0]);
            return;
        }
        targetDir.setReadable(true);
        for (File file : targetDir.listFiles()) {
            Files.delete(file.toPath());
        }
    }

    @Test
    public void notFound() throws IOException {
        File sourceFile = new File("notFound");
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_NONE.getValue());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_NOT_FOUND, 1);
    }

    @Test
    public void testSimpleSuccess() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_NONE.getValue());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        Assertions.assertTrue((boolean)sourceFile.exists());
    }

    @Test
    public void testDeleteOnComplete() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_DELETE.getValue());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        Assertions.assertFalse((boolean)sourceFile.exists());
    }

    @Test
    public void testMoveOnCompleteWithTargetDirExisting() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.assertValid();
        File destDir = new File("target/move-target");
        destDir.mkdirs();
        Assertions.assertTrue((boolean)destDir.exists());
        File destFile = new File(destDir, sourceFile.getName());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        Assertions.assertFalse((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testMoveOnCompleteWithTargetDirMissing() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.assertValid();
        File destDir = new File("target/move-target");
        if (destDir.exists()) {
            destDir.delete();
        }
        Assertions.assertFalse((boolean)destDir.exists());
        File destFile = new File(destDir, sourceFile.getName());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        Assertions.assertFalse((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testMoveOnCompleteWithTargetExistsButNotWritable() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.assertValid();
        File destDir = new File("target/move-target");
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        destDir.setWritable(false);
        Assertions.assertTrue((boolean)destDir.exists());
        Assertions.assertFalse((boolean)destDir.canWrite());
        File destFile = new File(destDir, sourceFile.getName());
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_FAILURE, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_FAILURE).get(0)).assertContentEquals("");
        Assertions.assertTrue((boolean)sourceFile.exists());
        Assertions.assertFalse((boolean)destFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveOnCompleteWithParentOfTargetDirNotAccessible() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        String moveTargetParent = "target/fetch-file";
        String moveTarget = "target/fetch-file/move-target";
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/fetch-file/move-target");
        runner.assertValid();
        File moveTargetParentDir = new File("target/fetch-file");
        moveTargetParentDir.mkdirs();
        moveTargetParentDir.setReadable(false);
        moveTargetParentDir.setWritable(false);
        try {
            runner.enqueue(new byte[0]);
            runner.run();
            runner.assertAllFlowFilesTransferred(FetchFile.REL_FAILURE, 1);
            ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_FAILURE).get(0)).assertContentEquals("");
            Assertions.assertTrue((boolean)sourceFile.exists());
        }
        finally {
            moveTargetParentDir.setReadable(true);
            moveTargetParentDir.setWritable(true);
        }
    }

    @Test
    public void testMoveAndReplace() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.setProperty(FetchFile.CONFLICT_STRATEGY, FetchFile.CONFLICT_REPLACE.getValue());
        runner.assertValid();
        File destDir = new File("target/move-target");
        File destFile = new File(destDir, sourceFile.getName());
        Files.write(destFile.toPath(), "Good-bye".getBytes(), StandardOpenOption.CREATE);
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        byte[] replacedContent = Files.readAllBytes(destFile.toPath());
        Assertions.assertTrue((boolean)Arrays.equals(content, replacedContent));
        Assertions.assertFalse((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testMoveAndKeep() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.setProperty(FetchFile.CONFLICT_STRATEGY, FetchFile.CONFLICT_KEEP_INTACT.getValue());
        runner.assertValid();
        File destDir = new File("target/move-target");
        File destFile = new File(destDir, sourceFile.getName());
        byte[] goodBye = "Good-bye".getBytes();
        Files.write(destFile.toPath(), goodBye, new OpenOption[0]);
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(FetchFile.REL_SUCCESS).get(0)).assertContentEquals(content);
        byte[] replacedContent = Files.readAllBytes(destFile.toPath());
        Assertions.assertTrue((boolean)Arrays.equals(goodBye, replacedContent));
        Assertions.assertFalse((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testMoveAndFail() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.setProperty(FetchFile.CONFLICT_STRATEGY, FetchFile.CONFLICT_FAIL.getValue());
        runner.assertValid();
        File destDir = new File("target/move-target");
        File destFile = new File(destDir, sourceFile.getName());
        byte[] goodBye = "Good-bye".getBytes();
        Files.write(destFile.toPath(), goodBye, new OpenOption[0]);
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_FAILURE, 1);
        byte[] replacedContent = Files.readAllBytes(destFile.toPath());
        Assertions.assertTrue((boolean)Arrays.equals(goodBye, replacedContent));
        Assertions.assertTrue((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testMoveAndRename() throws IOException {
        File sourceFile = new File("target/1.txt");
        byte[] content = "Hello, World!".getBytes();
        Files.write(sourceFile.toPath(), content, StandardOpenOption.CREATE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new FetchFile());
        runner.setProperty(FetchFile.FILENAME, sourceFile.getAbsolutePath());
        runner.setProperty(FetchFile.COMPLETION_STRATEGY, FetchFile.COMPLETION_MOVE.getValue());
        runner.assertNotValid();
        runner.setProperty(FetchFile.MOVE_DESTINATION_DIR, "target/move-target");
        runner.setProperty(FetchFile.CONFLICT_STRATEGY, FetchFile.CONFLICT_RENAME.getValue());
        runner.assertValid();
        File destDir = new File("target/move-target");
        File destFile = new File(destDir, sourceFile.getName());
        byte[] goodBye = "Good-bye".getBytes();
        Files.write(destFile.toPath(), goodBye, new OpenOption[0]);
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertAllFlowFilesTransferred(FetchFile.REL_SUCCESS, 1);
        byte[] replacedContent = Files.readAllBytes(destFile.toPath());
        Assertions.assertTrue((boolean)Arrays.equals(goodBye, replacedContent));
        Assertions.assertFalse((boolean)sourceFile.exists());
        Assertions.assertTrue((boolean)destFile.exists());
        Assertions.assertEquals((int)2, (int)destDir.list().length);
    }
}

