/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.ExtractRecordSchema;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestExtractRecordSchema {
    static final Path NAME_AGE_SCHEMA_PATH = Paths.get("src/test/resources/TestExtractRecordSchema/name_age_schema.avsc", new String[0]);

    @Test
    public void testSuccessfulExtraction() throws Exception {
        MockRecordParser readerService = new MockRecordParser();
        TestRunner runner = TestRunners.newTestRunner(ExtractRecordSchema.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.setProperty(ExtractRecordSchema.RECORD_READER, "reader");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(ExtractRecordSchema.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ExtractRecordSchema.REL_SUCCESS).get(0);
        String expectedAttributeValue = new String(Files.readAllBytes(NAME_AGE_SCHEMA_PATH));
        out.assertAttributeEquals("avro.schema", expectedAttributeValue);
    }

    @Test
    public void testNoSchema() throws Exception {
        MockRecordParserSchemaNotFound readerService = new MockRecordParserSchemaNotFound();
        TestRunner runner = TestRunners.newTestRunner(ExtractRecordSchema.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.setProperty(ExtractRecordSchema.RECORD_READER, "reader");
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(ExtractRecordSchema.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ExtractRecordSchema.REL_FAILURE).get(0);
        out.assertAttributeEquals("record.error.message", "org.apache.nifi.schema.access.SchemaNotFoundException Thrown");
    }

    private static class MockRecordParserSchemaNotFound
    extends MockRecordParser {
        private MockRecordParserSchemaNotFound() {
        }

        public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws SchemaNotFoundException {
            throw new SchemaNotFoundException("test");
        }
    }
}

