/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.util.Utf8;
import org.apache.nifi.avro.AvroRecordSetWriter;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractExecuteSQL;
import org.apache.nifi.processors.standard.ExecuteSQL;
import org.apache.nifi.processors.standard.ExecuteSQLRecord;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.db.SimpleCommerceDataSet;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecuteSQLRecord {
    private final Logger LOGGER = LoggerFactory.getLogger(TestExecuteSQLRecord.class);
    static final String DB_LOCATION = "target/db";
    static final String QUERY_WITH_EL = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID = ${person.id}";
    static final String QUERY_WITHOUT_EL = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID = 10";
    static final String QUERY_WITHOUT_EL_WITH_PARAMS = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID < ? AND REL.ID < ?";
    private TestRunner runner;

    @BeforeAll
    public static void setupClass() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
    }

    @AfterAll
    public static void cleanupClass() {
        System.clearProperty("derby.stream.error.file");
    }

    @BeforeEach
    public void setup() throws InitializationException {
        DBCPServiceSimpleImpl dbcp = new DBCPServiceSimpleImpl("derby");
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner(ExecuteSQLRecord.class);
        this.runner.addControllerService("dbcp", (ControllerService)dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(AbstractExecuteSQL.DBCP_SERVICE, "dbcp");
    }

    @Test
    public void testIncomingConnectionWithNoFlowFile() throws InitializationException {
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM persons");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_SUCCESS, 0);
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_FAILURE, 0);
    }

    @Test
    public void testIncomingConnectionWithNoFlowFileAndNoQuery() throws InitializationException {
        this.runner.setIncomingConnection(true);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_SUCCESS, 0);
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_FAILURE, 0);
    }

    @Test
    public void testNoIncomingConnectionAndNoQuery() throws InitializationException {
        this.runner.setIncomingConnection(false);
        Assertions.assertThrows(AssertionError.class, () -> this.runner.run());
    }

    @Test
    public void testNoIncomingConnection() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        this.runner.setIncomingConnection(false);
        this.invokeOnTriggerRecords(null, QUERY_WITHOUT_EL, false, null, true);
        Assertions.assertEquals((Object)ProvenanceEventType.RECEIVE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    public void testSelectQueryInFlowFile() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.invokeOnTriggerRecords(null, QUERY_WITHOUT_EL, true, null, false);
        Assertions.assertEquals((Object)ProvenanceEventType.FORK, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
        Assertions.assertEquals((Object)ProvenanceEventType.FETCH, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(1)).getEventType());
    }

    @Test
    public void testAutoCommitFalse() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.runner.setProperty(ExecuteSQL.AUTO_COMMIT, "false");
        this.invokeOnTriggerRecords(null, QUERY_WITHOUT_EL, true, null, false);
    }

    @Test
    public void testAutoCommitTrue() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.runner.setProperty(ExecuteSQL.AUTO_COMMIT, "true");
        this.invokeOnTriggerRecords(null, QUERY_WITHOUT_EL, true, null, false);
    }

    @Test
    public void testWithOutputBatching() throws InitializationException, SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQLRecord.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.setProperty(ExecuteSQLRecord.OUTPUT_BATCH_SIZE, "5");
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_SUCCESS, 200);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQLRecord.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQLRecord.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeNotExists(FragmentAttributes.FRAGMENT_COUNT.key());
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
    }

    @Test
    public void testWithOutputBatchingAndIncomingFlowFile() throws InitializationException, SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        String testAttrName = "attr1";
        String testAttrValue = "value1";
        attrMap.put(testAttrName, testAttrValue);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.setProperty(ExecuteSQLRecord.OUTPUT_BATCH_SIZE, "1");
        MockFlowFile inputFlowFile = this.runner.enqueue("SELECT * FROM TEST_NULL_INT", attrMap);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_SUCCESS, 200);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQLRecord.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQLRecord.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeNotExists(FragmentAttributes.FRAGMENT_COUNT.key());
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        lastFlowFile.assertAttributeEquals(testAttrName, testAttrValue);
        lastFlowFile.assertAttributeEquals("input.flowfile.uuid", inputFlowFile.getAttribute(CoreAttributes.UUID.key()));
    }

    @Test
    public void testWithOutputBatchingLastBatchFails() throws InitializationException, SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 varchar(50), constraint my_pk primary key (id))");
        for (int i = 0; i < 11; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1) VALUES (" + i + ", '" + i + "')");
        }
        stmt.execute("insert into TEST_NULL_INT (id, val1) VALUES (100, 'abc')");
        HashMap<String, String> attrMap = new HashMap<String, String>();
        String testAttrName = "attr1";
        String testAttrValue = "value1";
        attrMap.put(testAttrName, testAttrValue);
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.enqueue("SELECT ID, CAST(VAL1 AS INTEGER) AS TN FROM TEST_NULL_INT", attrMap);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_FAILURE, 1);
        this.runner.assertTransferCount(ExecuteSQLRecord.REL_SUCCESS, 0);
    }

    @Test
    public void testMaxRowsPerFlowFile() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(AbstractExecuteSQL.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.setProperty(AbstractExecuteSQL.OUTPUT_BATCH_SIZE, "0");
        this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_SUCCESS, 200);
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_FAILURE, 0);
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_COUNT.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeEquals("record.count", "5");
        firstFlowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "text/plain");
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals("record.count", "5");
        lastFlowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "text/plain");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
    }

    @Test
    public void testInsertStatementCreatesFlowFile() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, "insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_SUCCESS).get(0)).assertAttributeEquals("executesql.row.count", "0");
    }

    @Test
    public void testWriteLOBsToAvro() throws Exception {
        DBCPServiceSimpleImpl dbcp = new DBCPServiceSimpleImpl("h2");
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner(ExecuteSQLRecord.class);
        this.runner.addControllerService("dbcp", (ControllerService)dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(AbstractExecuteSQL.DBCP_SERVICE, "dbcp");
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, image blob(1K), words clob(1K), natwords nclob(1K), constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2, image, words, natwords) VALUES (0, NULL, 1, CAST (X'DEADBEEF' AS BLOB), CAST ('Hello World' AS CLOB), CAST ('I am an NCLOB' AS NCLOB))");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        AvroRecordSetWriter recordWriter = new AvroRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty((ControllerService)recordWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals("executesql.row.count", "1");
        ByteArrayInputStream bais = new ByteArrayInputStream(flowFile.toByteArray());
        DataFileStream dataFileStream = new DataFileStream((InputStream)bais, (DatumReader)new GenericDatumReader());
        Schema avroSchema = dataFileStream.getSchema();
        GenericData.setStringType((Schema)avroSchema, (GenericData.StringType)GenericData.StringType.String);
        GenericRecord avroRecord = (GenericRecord)dataFileStream.next();
        Object imageObj = avroRecord.get("IMAGE");
        Assertions.assertNotNull((Object)imageObj);
        Assertions.assertTrue((boolean)(imageObj instanceof ByteBuffer));
        Assertions.assertArrayEquals((byte[])new byte[]{-34, -83, -66, -17}, (byte[])((ByteBuffer)imageObj).array());
        Object wordsObj = avroRecord.get("WORDS");
        Assertions.assertNotNull((Object)wordsObj);
        Assertions.assertTrue((boolean)(wordsObj instanceof Utf8));
        Assertions.assertEquals((Object)"Hello World", (Object)wordsObj.toString());
        Object natwordsObj = avroRecord.get("NATWORDS");
        Assertions.assertNotNull((Object)natwordsObj);
        Assertions.assertTrue((boolean)(natwordsObj instanceof Utf8));
        Assertions.assertEquals((Object)"I am an NCLOB", (Object)natwordsObj.toString());
    }

    @Test
    public void testNoRowsStatementCreatesEmptyFlowFile() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.enqueue("Hello".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "0");
        firstFlowFile.assertContentEquals("");
    }

    @Test
    public void testWithSqlException() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NO_ROWS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NO_ROWS (id integer)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, "SELECT val1 FROM TEST_NO_ROWS");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_FAILURE, 0);
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_SUCCESS, 0);
    }

    public void invokeOnTriggerRecords(Integer queryTimeout, String query, boolean incomingFlowFile, Map<String, String> attrs, boolean setQueryProperty) throws InitializationException, ClassNotFoundException, SQLException, IOException {
        if (queryTimeout != null) {
            this.runner.setProperty(AbstractExecuteSQL.QUERY_TIMEOUT, queryTimeout.toString() + " secs");
        }
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        SimpleCommerceDataSet.loadTestData2Database((Connection)con, (int)100, (int)200, (int)100);
        this.LOGGER.info("test data loaded");
        if (!con.getAutoCommit()) {
            con.commit();
        }
        int nrOfRows = 20000;
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        if (incomingFlowFile) {
            HashMap<String, String> attributes = attrs == null ? new HashMap<String, String>() : attrs;
            attributes.put("person.id", "10");
            if (!setQueryProperty) {
                this.runner.enqueue(query.getBytes(), attributes);
            } else {
                this.runner.enqueue("Hello".getBytes(), attributes);
            }
        }
        if (setQueryProperty) {
            this.runner.setProperty(AbstractExecuteSQL.SQL_SELECT_QUERY, query);
        }
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractExecuteSQL.REL_SUCCESS, 1);
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, "executesql.query.duration");
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, "executesql.query.executiontime");
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, "executesql.query.fetchtime");
        this.runner.assertAllFlowFilesContainAttribute(AbstractExecuteSQL.REL_SUCCESS, "executesql.row.count");
        List flowfiles = this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_SUCCESS);
        long executionTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.executiontime"));
        long fetchTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.fetchtime"));
        long durationTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.duration"));
        Assertions.assertEquals((long)durationTime, (long)(fetchTime + executionTime));
    }

    @Test
    public void testWithSqlExceptionErrorProcessingResultSet() throws Exception {
        DBCPService dbcp = (DBCPService)Mockito.mock(DBCPService.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dbcp.getConnection((Map)ArgumentMatchers.any(Map.class))).thenReturn((Object)conn);
        Mockito.when((Object)dbcp.getIdentifier()).thenReturn((Object)"mockdbcp");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)conn.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute()).thenReturn((Object)true);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)rs);
        Mockito.when((Object)rs.getMetaData()).thenThrow(new Throwable[]{new SQLException("test execute statement failed")});
        this.runner.addControllerService("mockdbcp", (ControllerService)dbcp, new HashMap());
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(AbstractExecuteSQL.DBCP_SERVICE, "mockdbcp");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.setIncomingConnection(true);
        this.runner.enqueue("SELECT 1");
        this.runner.run();
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_FAILURE, 1);
        this.runner.assertTransferCount(AbstractExecuteSQL.REL_SUCCESS, 0);
        MockFlowFile failedFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractExecuteSQL.REL_FAILURE).get(0);
        Assertions.assertEquals((Object)"java.sql.SQLException: test execute statement failed", (Object)failedFlowFile.getAttribute("executesql.error.message"));
    }

    @Test
    public void testPreQuery() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT values(1,2,3)");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "1");
    }

    @Test
    public void testPostQuery() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT values(1,2,3)");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.setProperty(ExecuteSQLRecord.SQL_POST_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "1");
    }

    @Test
    public void testPreQueryFail() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS()");
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_FAILURE, 1);
    }

    @Test
    public void testPostQueryFail() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQLRecord.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQLRecord.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.setProperty(ExecuteSQLRecord.SQL_POST_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS()");
        MockRecordWriter recordWriter = new MockRecordWriter(null, true, -1);
        this.runner.addControllerService("writer", (ControllerService)recordWriter);
        this.runner.setProperty(ExecuteSQLRecord.RECORD_WRITER_FACTORY, "writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQLRecord.REL_FAILURE, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQLRecord.REL_FAILURE).get(0);
        firstFlowFile.assertContentEquals("test");
    }

    class DBCPServiceSimpleImpl
    extends AbstractControllerService
    implements DBCPService {
        private final String type;

        public DBCPServiceSimpleImpl(String type) {
            this.type = type;
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Connection con;
                if ("h2".equalsIgnoreCase(this.type)) {
                    con = DriverManager.getConnection("jdbc:h2:file:./target/testdb7");
                } else {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                    con = DriverManager.getConnection("jdbc:derby:target/db;create=true");
                }
                return con;
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

