/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.nifi.avro.AvroRecordSetWriter;
import org.apache.nifi.avro.NonCachingDatumReader;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVReader;
import org.apache.nifi.csv.CSVRecordSetWriter;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.xerial.snappy.SnappyInputStream;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Pretty-printing is not portable across operating systems")
public class TestConvertRecord {
    @Test
    public void testSuccessfulConversion() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("header\nJohn Doe,48\nJane Doe,47\nJimmy Doe,14\n");
    }

    @Test
    public void testDropEmpty() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(ConvertRecord.INCLUDE_ZERO_RECORD_FLOWFILES, "false");
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 0);
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_FAILURE, 0);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("header\nJohn Doe,48\nJane Doe,47\nJimmy Doe,14\n");
    }

    @Test
    public void testReadFailure() throws InitializationException, IOException {
        MockRecordParser readerService = new MockRecordParser(2);
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        MockFlowFile original = runner.enqueue("hello");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_FAILURE).get(0);
        out.assertContentEquals(original.toByteArray());
        out.assertAttributeEquals("record.error.message", "Intentional Unit Test Exception because 2 records have been read");
    }

    @Test
    public void testWriteFailure() throws InitializationException, IOException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false, 2);
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        MockFlowFile original = runner.enqueue("hello");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_FAILURE).get(0);
        out.assertContentEquals(original.toByteArray());
        out.assertAttributeEquals("record.error.message", "Unit Test intentionally throwing IOException after 2 records were written");
    }

    @Test
    public void testJSONCompression() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        runner.setProperty((ControllerService)jsonWriter, "compression-format", "snappy");
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.enqueue(Paths.get("src/test/resources/TestConvertRecord/input/person.json", new String[0]));
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (SnappyInputStream sis = new SnappyInputStream((InputStream)new ByteArrayInputStream(flowFile.toByteArray()));
             ByteArrayOutputStream out = baos;){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = sis.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            out.flush();
        }
        Assertions.assertEquals((Object)new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/input/person.json", new String[0]))), (Object)baos.toString(StandardCharsets.UTF_8.name()));
    }

    @Test
    public void testCSVFormattingWithEL() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        CSVReader csvReader = new CSVReader();
        runner.addControllerService("csv-reader", (ControllerService)csvReader);
        runner.setProperty((ControllerService)csvReader, CSVUtils.VALUE_SEPARATOR, "${csv.in.delimiter}");
        runner.setProperty((ControllerService)csvReader, CSVUtils.QUOTE_CHAR, "${csv.in.quote}");
        runner.setProperty((ControllerService)csvReader, CSVUtils.ESCAPE_CHAR, "${csv.in.escape}");
        runner.setProperty((ControllerService)csvReader, CSVUtils.COMMENT_MARKER, "${csv.in.comment}");
        runner.enableControllerService((ControllerService)csvReader);
        CSVRecordSetWriter csvWriter = new CSVRecordSetWriter();
        runner.addControllerService("csv-writer", (ControllerService)csvWriter);
        runner.setProperty((ControllerService)csvWriter, CSVUtils.VALUE_SEPARATOR, "${csv.out.delimiter}");
        runner.setProperty((ControllerService)csvWriter, CSVUtils.QUOTE_CHAR, "${csv.out.quote}");
        runner.setProperty((ControllerService)csvWriter, CSVUtils.QUOTE_MODE, CSVUtils.QUOTE_ALL);
        runner.enableControllerService((ControllerService)csvWriter);
        runner.setProperty(ConvertRecord.RECORD_READER, "csv-reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "csv-writer");
        String ffContent = "~ comment\nid|username|password\n123|'John'|^|^'^^\n";
        HashMap<String, String> ffAttributes = new HashMap<String, String>();
        ffAttributes.put("csv.in.delimiter", "|");
        ffAttributes.put("csv.in.quote", "'");
        ffAttributes.put("csv.in.escape", "^");
        ffAttributes.put("csv.in.comment", "~");
        ffAttributes.put("csv.out.delimiter", "\t");
        ffAttributes.put("csv.out.quote", "`");
        runner.enqueue(ffContent, ffAttributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
        String expected = "`id`\t`username`\t`password`\n`123`\t`John`\t`|'^`\n";
        Assertions.assertEquals((Object)expected, (Object)new String(flowFile.toByteArray()));
    }

    @Test
    public void testJSONLongToInt() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.enqueue(Paths.get("src/test/resources/TestConvertRecord/input/person_long_id.json", new String[0]));
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_FAILURE, 1);
    }

    @Test
    public void testEnumBadValue() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person.avsc", new String[0])));
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        runner.enableControllerService((ControllerService)jsonReader);
        AvroRecordSetWriter avroWriter = new AvroRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)avroWriter);
        runner.setProperty((ControllerService)avroWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)avroWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        runner.enableControllerService((ControllerService)avroWriter);
        runner.enqueue(Paths.get("src/test/resources/TestConvertRecord/input/person_bad_enum.json", new String[0]));
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_FAILURE, 1);
    }

    @Test
    public void testEnumUnionString() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person_with_union_enum_string.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConvertRecord/schema/person_with_union_enum_string.avsc", new String[0])));
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        runner.enableControllerService((ControllerService)jsonReader);
        AvroRecordSetWriter avroWriter = new AvroRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)avroWriter);
        runner.setProperty((ControllerService)avroWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        runner.setProperty((ControllerService)avroWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        runner.enableControllerService((ControllerService)avroWriter);
        runner.enqueue(Paths.get("src/test/resources/TestConvertRecord/input/person_bad_enum.json", new String[0]));
        runner.setProperty(ConvertRecord.RECORD_READER, "reader");
        runner.setProperty(ConvertRecord.RECORD_WRITER, "writer");
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateConversionWithUTCMinusTimezone() throws Exception {
        String timezone = System.getProperty("user.timezone");
        System.setProperty("user.timezone", "EST");
        try {
            TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
            JsonTreeReader jsonTreeReader = new JsonTreeReader();
            runner.addControllerService("json-reader", (ControllerService)jsonTreeReader);
            runner.setProperty((ControllerService)jsonTreeReader, DateTimeUtils.DATE_FORMAT, "yyyy-MM-dd");
            runner.enableControllerService((ControllerService)jsonTreeReader);
            AvroRecordSetWriter avroWriter = new AvroRecordSetWriter();
            runner.addControllerService("avro-writer", (ControllerService)avroWriter);
            runner.enableControllerService((ControllerService)avroWriter);
            runner.setProperty(ConvertRecord.RECORD_READER, "json-reader");
            runner.setProperty(ConvertRecord.RECORD_WRITER, "avro-writer");
            runner.enqueue("{ \"date\": \"1970-01-02\" }");
            runner.run();
            runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
            DataFileStream avroStream = new DataFileStream(flowFile.getContentStream(), (DatumReader)new NonCachingDatumReader());
            Assertions.assertTrue((boolean)avroStream.hasNext());
            Assertions.assertEquals((Object)1, (Object)((GenericRecord)avroStream.next()).get("date"));
        }
        finally {
            if (timezone != null) {
                System.setProperty("user.timezone", timezone);
            }
        }
    }
}

